/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;

public class SqlOverlayFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.STRING_STRING_INTEGER.or(OperandTypes.STRING_STRING_INTEGER_INTEGER);

    public SqlOverlayFunction() {
        super("OVERLAY", SqlKind.OTHER_FUNCTION, ReturnTypes.DYADIC_STRING_SUM_PRECISION_NULLABLE_VARYING, null, OTC_CUSTOM, SqlFunctionCategory.STRING);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("PLACING");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        if (4 == call.operandCount()) {
            writer.sep("FOR");
            ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 3: {
                return "{0}({1} PLACING {2} FROM {3})";
            }
            case 4: {
                return "{0}({1} PLACING {2} FROM {3} FOR {4})";
            }
        }
        throw new IllegalArgumentException("operandsCount shuld be 3 or 4, got " + operandsCount);
    }
}

