/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.TimeUUID;

public class StreamInitMessage
extends StreamMessage {
    public static StreamMessage.Serializer<StreamInitMessage> serializer = new StreamInitMessageSerializer();
    public final InetAddressAndPort from;
    public final int sessionIndex;
    public final TimeUUID planId;
    public final StreamOperation streamOperation;
    public final TimeUUID pendingRepair;
    public final PreviewKind previewKind;

    public StreamInitMessage(InetAddressAndPort from, int sessionIndex, TimeUUID planId, StreamOperation streamOperation, TimeUUID pendingRepair, PreviewKind previewKind) {
        super(StreamMessage.Type.STREAM_INIT);
        this.from = from;
        this.sessionIndex = sessionIndex;
        this.planId = planId;
        this.streamOperation = streamOperation;
        this.pendingRepair = pendingRepair;
        this.previewKind = previewKind;
    }

    @Override
    public StreamSession getOrCreateAndAttachInboundSession(StreamingChannel channel, int messagingVersion) {
        StreamSession session = StreamResultFuture.createFollower(this.sessionIndex, this.planId, this.streamOperation, this.from, channel, messagingVersion, this.pendingRepair, this.previewKind).getSession(this.from, this.sessionIndex);
        session.attachInbound(channel);
        return session;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("StreamInitMessage: from = ").append(this.from);
        sb.append(", planId = ").append(this.planId).append(", session index = ").append(this.sessionIndex);
        return sb.toString();
    }

    private static class StreamInitMessageSerializer
    implements StreamMessage.Serializer<StreamInitMessage> {
        private StreamInitMessageSerializer() {
        }

        @Override
        public void serialize(StreamInitMessage message, StreamingDataOutputPlus out, int version, StreamSession session) throws IOException {
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.from, (DataOutputPlus)out, version);
            out.writeInt(message.sessionIndex);
            message.planId.serialize(out);
            out.writeUTF(message.streamOperation.getDescription());
            out.writeBoolean(message.pendingRepair != null);
            if (message.pendingRepair != null) {
                message.pendingRepair.serialize(out);
            }
            out.writeInt(message.previewKind.getSerializationVal());
        }

        @Override
        public StreamInitMessage deserialize(DataInputPlus in, int version) throws IOException {
            InetAddressAndPort from = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            int sessionIndex = in.readInt();
            TimeUUID planId = TimeUUID.deserialize(in);
            String description = in.readUTF();
            TimeUUID pendingRepair = in.readBoolean() ? TimeUUID.deserialize(in) : null;
            PreviewKind previewKind = PreviewKind.deserialize(in.readInt());
            return new StreamInitMessage(from, sessionIndex, planId, StreamOperation.fromString(description), pendingRepair, previewKind);
        }

        @Override
        public long serializedSize(StreamInitMessage message, int version) {
            long size = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.from, version);
            size += (long)TypeSizes.sizeof(message.sessionIndex);
            size += TimeUUID.sizeInBytes();
            size += (long)TypeSizes.sizeof(message.streamOperation.getDescription());
            size += (long)TypeSizes.sizeof(message.pendingRepair != null);
            if (message.pendingRepair != null) {
                size += TimeUUID.sizeInBytes();
            }
            return size += (long)TypeSizes.sizeof(message.previewKind.getSerializationVal());
        }
    }
}

