/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnLoggingGrpc;
import org.apache.beam.runners.fnexecution.logging.LogWriter;
import org.apache.beam.sdk.fn.server.FnService;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcLoggingService
extends BeamFnLoggingGrpc.BeamFnLoggingImplBase
implements FnService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GrpcLoggingService.class);
    private final @UnknownKeyFor @NonNull @Initialized LogWriter logWriter;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService. @UnknownKeyFor @NonNull @Initialized InboundObserver, @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.LogControl>> connectedClients;

    public static @UnknownKeyFor @NonNull @Initialized GrpcLoggingService forWriter(@UnknownKeyFor @NonNull @Initialized LogWriter writer) {
        return new GrpcLoggingService(writer);
    }

    private GrpcLoggingService(@UnknownKeyFor @NonNull @Initialized LogWriter logWriter) {
        this.logWriter = logWriter;
        this.connectedClients = new ConcurrentHashMap<InboundObserver, StreamObserver<BeamFnApi.LogControl>>();
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ImmutableSet remainingClients = ImmutableSet.copyOf(this.connectedClients.keySet());
        if (!remainingClients.isEmpty()) {
            LOG.info("{} Beam Fn Logging clients still connected during shutdown.", (Object)remainingClients.size());
            for (InboundObserver client : remainingClients) {
                this.completeIfNotNull((StreamObserver<BeamFnApi.LogControl>)((StreamObserver)this.connectedClients.remove(client)));
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.LogEntry.List> logging(@UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.LogControl> outboundObserver) {
        LOG.info("Beam Fn Logging client connected.");
        InboundObserver inboundObserver = new InboundObserver();
        this.connectedClients.put(inboundObserver, outboundObserver);
        return inboundObserver;
    }

    private void completeIfNotNull(@UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.LogControl> outboundObserver) {
        if (outboundObserver != null) {
            try {
                outboundObserver.onCompleted();
            }
            catch (RuntimeException ignored) {
                LOG.warn("Beam Fn Logging client failed to be complete.", (Throwable)ignored);
            }
        }
    }

    private class InboundObserver
    implements StreamObserver<BeamFnApi.LogEntry.List> {
        private InboundObserver() {
        }

        public void onNext(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.LogEntry.List value) {
            for (BeamFnApi.LogEntry logEntry : value.getLogEntriesList()) {
                GrpcLoggingService.this.logWriter.log(logEntry);
            }
        }

        public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            LOG.warn("Logging client failed unexpectedly.", t);
            GrpcLoggingService.this.completeIfNotNull((StreamObserver<BeamFnApi.LogControl>)((StreamObserver)GrpcLoggingService.this.connectedClients.remove(this)));
        }

        public void onCompleted() {
            LOG.info("Logging client hanged up.");
            GrpcLoggingService.this.completeIfNotNull((StreamObserver<BeamFnApi.LogControl>)((StreamObserver)GrpcLoggingService.this.connectedClients.remove(this)));
        }
    }
}

