/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.io.IOException;
import java.io.Writer;
import net.sf.saxon.om.FastStringBuffer;

public class CompressedWhitespace
implements CharSequence {
    private static char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};
    private long value;

    public CompressedWhitespace(long l) {
        this.value = l;
    }

    public static CharSequence compress(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = charSequence.length();
        if (n3 == 0) {
            return charSequence;
        }
        int n4 = 1;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = charSequence.charAt(n2);
            if ("\t\n\r ".indexOf(c) >= 0) {
                if (n2 == n3 - 1 || c != charSequence.charAt(n2 + 1) || n4 == 63) {
                    n4 = 1;
                    if (++n5 <= 8) continue;
                    return charSequence;
                }
                ++n4;
                continue;
            }
            return charSequence;
        }
        n2 = 0;
        n4 = 1;
        int[] nArray = new int[n5];
        for (int i = 0; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if (i == n3 - 1 || c != charSequence.charAt(i + 1) || n4 == 63) {
                n = "\t\n\r ".indexOf(c);
                nArray[n2++] = n << 6 | n4;
                n4 = 1;
                continue;
            }
            ++n4;
        }
        long l = 0L;
        for (n = 0; n < n5; ++n) {
            l = l << 8 | (long)nArray[n];
        }
        for (n = 0; n < 8 - n5; ++n) {
            l <<= 8;
        }
        return new CompressedWhitespace(l);
    }

    public FastStringBuffer uncompress(FastStringBuffer fastStringBuffer) {
        byte by;
        if (fastStringBuffer == null) {
            fastStringBuffer = new FastStringBuffer(this.length());
        }
        long l = this.value;
        for (int i = 56; i >= 0 && (by = (byte)(l >>> i & 0xFFL)) != 0; i -= 8) {
            char c = WHITE_CHARS[by >>> 6 & 3];
            int n = by & 0x3F;
            for (int j = 0; j < n; ++j) {
                fastStringBuffer.append(c);
            }
        }
        return fastStringBuffer;
    }

    public long getCompressedValue() {
        return this.value;
    }

    public int length() {
        int n;
        int n2 = 0;
        long l = this.value;
        for (int i = 56; i >= 0 && (n = (int)(l >>> i & 0x3FL)) != 0; i -= 8) {
            n2 += n;
        }
        return n2;
    }

    public char charAt(int n) {
        byte by;
        int n2 = 0;
        long l = this.value;
        for (int i = 56; i >= 0 && (by = (byte)(l >>> i & 0xFFL)) != 0; i -= 8) {
            if ((n2 += by & 0x3F) <= n) continue;
            return WHITE_CHARS[by >>> 6 & 3];
        }
        throw new IndexOutOfBoundsException(n + "");
    }

    public CharSequence subSequence(int n, int n2) {
        return this.uncompress(null).subSequence(n, n2);
    }

    public boolean equals(Object object) {
        if (object instanceof CompressedWhitespace) {
            return this.value == ((CompressedWhitespace)object).value;
        }
        return this.uncompress(null).equals(object);
    }

    public int hashCode() {
        return this.uncompress(null).hashCode();
    }

    public String toString() {
        return this.uncompress(null).toString();
    }

    public void write(Writer writer) throws IOException {
        byte by;
        long l = this.value;
        for (int i = 56; i >= 0 && (by = (byte)(l >>> i & 0xFFL)) != 0; i -= 8) {
            char c = WHITE_CHARS[by >>> 6 & 3];
            int n = by & 0x3F;
            for (int j = 0; j < n; ++j) {
                writer.write(c);
            }
        }
    }

    public void writeEscape(boolean[] blArray, Writer writer) throws IOException {
        byte by;
        long l = this.value;
        for (int i = 56; i >= 0 && (by = (byte)(l >>> i & 0xFFL)) != 0; i -= 8) {
            char c = WHITE_CHARS[by >>> 6 & 3];
            int n = by & 0x3F;
            if (blArray[c]) {
                String string = "";
                if (c == '\n') {
                    string = "&#xA;";
                } else if (c == '\r') {
                    string = "&#xD;";
                } else if (c == '\t') {
                    string = "&#x9;";
                }
                for (int j = 0; j < n; ++j) {
                    writer.write(string);
                }
                continue;
            }
            for (int j = 0; j < n; ++j) {
                writer.write(c);
            }
        }
    }

    public static void main(String[] stringArray) {
        CharSequence charSequence = CompressedWhitespace.compress("\t\n\n\t\t\n      ");
        System.err.println(charSequence);
    }
}

