/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBStoragePool;
import java.io.PrintWriter;
import java.io.StringWriter;

final class DBStorage {
    public static final int DEFAULT_SIZE = 1024;
    private byte[] data_ = new byte[1024];
    private int id_;
    private DBStoragePool pool_;
    private boolean inUse_ = false;
    private Exception allocatedLocation;

    DBStorage(int id, DBStoragePool pool) {
        this.id_ = id;
        this.pool_ = pool;
    }

    final synchronized boolean checkSize(int size) {
        if (size > this.data_.length) {
            int increment = this.data_.length;
            byte[] newdata = new byte[Math.max(this.data_.length + increment, size)];
            System.arraycopy(this.data_, 0, newdata, 0, this.data_.length);
            this.data_ = newdata;
            return true;
        }
        return false;
    }

    public synchronized void reclaim(int length) {
        if (this.data_.length > length && length >= 1024) {
            byte[] oldData = this.data_;
            this.data_ = new byte[length];
            System.arraycopy(oldData, 6, this.data_, 6, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool() {
        DBStorage dBStorage = this;
        synchronized (dBStorage) {
            this.inUse_ = false;
        }
        if (this.id_ >= 0) {
            this.pool_.returned(this.id_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUse() {
        if (this.inUse_) {
            return false;
        }
        DBStorage dBStorage = this;
        synchronized (dBStorage) {
            if (this.inUse_) {
                return false;
            }
            this.inUse_ = true;
            return true;
        }
    }

    public synchronized byte[] getData() {
        return this.data_;
    }

    public void setAllocatedLocation() {
        this.allocatedLocation = new Exception("location");
    }

    String getAllocatedLocation() {
        if (this.allocatedLocation == null) {
            return "NONE";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.allocatedLocation.printStackTrace(pw);
        String result = sw.toString();
        result = result.replace('\n', ' ');
        return result;
    }
}

