/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;

class DDMSECCHKRequestDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2024 International Business Machines Corporation and others.";

    DDMSECCHKRequestDataStream(byte[] userIDbytes, byte[] authenticationBytes, byte[] iasp, int authScheme, byte[] addAuthFactor, byte[] verificationID, byte[] clientIPAddr) {
        super(new byte[authenticationBytes.length + userIDbytes.length + (iasp == null ? 0 : 22) + (authScheme == 0 || authScheme == 4 ? 24 : 16) + ((authScheme == 0 || authScheme == 4) && addAuthFactor != null ? addAuthFactor.length + 12 : 0) + (authScheme == 2 && verificationID != null ? verificationID.length + 8 : 0) + (authScheme == 2 && clientIPAddr != null ? clientIPAddr.length + 8 : 0)]);
        this.setGDSId((byte)-48);
        if (authScheme != 0 && authScheme != 4) {
            byte[] verficationIDBytes = (byte[])(authScheme == 2 ? verificationID : null);
            byte[] clientIPAddrBytes = (byte[])(authScheme == 2 ? clientIPAddr : null);
            this.setLength(16 + (verficationIDBytes != null ? verficationIDBytes.length + 8 : 0) + (clientIPAddrBytes != null ? clientIPAddrBytes.length + 8 : 0));
            this.setIsChained(true);
            this.setHasSameRequestCorrelation(true);
            this.setType(1);
            this.set16bit(10 + (verficationIDBytes != null ? verficationIDBytes.length + 8 : 0) + (clientIPAddrBytes != null ? clientIPAddrBytes.length + 8 : 0), 6);
            this.set16bit(4206, 8);
            this.set16bit(6, 10);
            this.set16bit(4514, 12);
            if (authScheme == 1) {
                this.set16bit(11, 14);
            } else {
                this.set16bit(16, 14);
            }
            int offset = 16;
            if (authScheme == 2) {
                if (verficationIDBytes != null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Sending SECCHK request with verification ID.");
                    }
                    this.set16bit(8 + verficationIDBytes.length, offset);
                    this.set16bit(53571, offset + 2);
                    this.set32bit(1208, offset + 4);
                    System.arraycopy(verficationIDBytes, 0, this.data_, offset + 8, verficationIDBytes.length);
                    offset += 8 + verficationIDBytes.length;
                }
                if (clientIPAddrBytes != null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Sending SECCHK request with client IP address.");
                    }
                    this.set16bit(8 + clientIPAddrBytes.length, offset);
                    this.set16bit(53572, offset + 2);
                    this.set32bit(1208, offset + 4);
                    System.arraycopy(clientIPAddrBytes, 0, this.data_, offset + 8, clientIPAddrBytes.length);
                    offset += 8 + clientIPAddrBytes.length;
                }
            }
            this.set16bit(authenticationBytes.length + 10, offset);
            this.set16bit(53251, offset + 2);
            this.set16bit(authenticationBytes.length + 4, offset += 6);
            this.set16bit(4572, offset + 2);
            System.arraycopy(authenticationBytes, 0, this.data_, offset + 4, authenticationBytes.length);
            offset += 4 + authenticationBytes.length;
        } else {
            boolean useRDB = iasp != null;
            this.setType(1);
            this.set16bit(authenticationBytes.length + userIDbytes.length + (useRDB ? 40 : 18) + (addAuthFactor != null && 0 < addAuthFactor.length ? addAuthFactor.length + 12 : 0), 6);
            this.set16bit(4206, 8);
            this.set16bit(6, 10);
            this.set16bit(4514, 12);
            if (authScheme == 4) {
                this.set16bit(9, 14);
            } else if (authenticationBytes.length == 20 || authenticationBytes.length == 64) {
                this.set16bit(8, 14);
            } else {
                this.set16bit(6, 14);
            }
            if (authScheme == 4) {
                this.set16bit(userIDbytes.length + 4, 16);
                this.set16bit(4572, 18);
                System.arraycopy(userIDbytes, 0, this.data_, 20, userIDbytes.length);
                this.set16bit(authenticationBytes.length + 4, 20 + userIDbytes.length);
                this.set16bit(4572, 22 + userIDbytes.length);
                System.arraycopy(authenticationBytes, 0, this.data_, 24 + userIDbytes.length, authenticationBytes.length);
            } else {
                this.set16bit(14, 16);
                this.set16bit(4512, 18);
                System.arraycopy(userIDbytes, 0, this.data_, 20, 10);
                this.set16bit(authenticationBytes.length + 4, 30);
                this.set16bit(4513, 32);
                System.arraycopy(authenticationBytes, 0, this.data_, 34, authenticationBytes.length);
            }
            int offset = 24 + userIDbytes.length + authenticationBytes.length;
            if (useRDB) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Sending SECCHK request with RDB / IASP name.");
                }
                this.set16bit(22, offset);
                this.set16bit(8464, offset + 2);
                System.arraycopy(iasp, 0, this.data_, offset + 4, iasp.length);
                offset += 22;
            }
            if (addAuthFactor != null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Sending SECCHK request with additional authentication factor.");
                }
                this.set16bit(12 + addAuthFactor.length, offset);
                this.set16bit(53570, offset + 2);
                this.set16bit(0, offset + 4);
                this.set32bit(1208, offset + 6);
                this.set16bit(addAuthFactor.length, offset + 10);
                System.arraycopy(addAuthFactor, 0, this.data_, offset + 12, addAuthFactor.length);
                offset += 12 + addAuthFactor.length;
            }
        }
    }

    @Override
    void write(OutputStream out) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Sending DDM SECCHK request...");
        }
        super.write(out);
    }
}

