/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSCopyReq
extends IFSDataStreamReq {
    private static final int SOURCE_CCSID_OFFSET = 22;
    private static final int TARGET_CCSID_OFFSET = 24;
    private static final int SOURCE_WORKING_DIR_HANDLE_OFFSET = 26;
    private static final int TARGET_WORKING_DIR_HANDLE_OFFSET = 30;
    private static final int DUPLICATE_TARGET_OPTION_OFFSET = 34;
    private static final int TEMPLATE_LENGTH = 16;
    private static final int SOURCE_NAME_LL_OFFSET = 36;

    IFSCopyReq(String sourcePath, String destinationPath, boolean replace) {
        super(48 + (sourcePath.length() + destinationPath.length()) * 2);
        int i;
        this.setLength(this.data_.length);
        this.setTemplateLen(16);
        this.setReqRepID(1);
        this.set16bit(13488, 22);
        this.set16bit(13488, 24);
        this.set32bit(1, 26);
        this.set32bit(1, 30);
        int dupTargetOpt = 8 + (replace ? 1 : 0);
        this.set16bit(dupTargetOpt, 34);
        int offset = 36;
        this.set32bit(6 + sourcePath.length() * 2, offset);
        this.set16bit(3, offset + 4);
        for (i = 0; i < sourcePath.length(); ++i) {
            this.set16bit(sourcePath.charAt(i), offset + 6 + i * 2);
        }
        this.set32bit(6 + destinationPath.length() * 2, offset += 6 + sourcePath.length() * 2);
        this.set16bit(4, offset + 4);
        for (i = 0; i < destinationPath.length(); ++i) {
            this.set16bit(destinationPath.charAt(i), offset + 6 + i * 2);
        }
    }
}

