/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class PrinterStartAction
extends DialogAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_START");
    private static String generalTabText_;
    private static String prtStartWtrText_;
    private static String outQText_;
    private static String outQLibText_;
    private static String msgQText_;
    private static String msgQLibText_;
    private static String libListText_;
    private static String curLibText_;
    private static String prtrDefText_;
    private static String userDefText_;
    private static String dvceDefText_;
    private static String fileDefText_;
    private static String inqMsgTypeText_;
    private static String inqInfoMsgTypeText_;
    private static String infoMsgTypeText_;
    private static String noneMsgTypeText_;
    private static String formTypeText_;
    private static String formTypeNotifyText_;
    private static String formTypeAllText_;
    private static String formTypeStdText_;
    private static String formTypeAGBTText_;
    private static String numSepPagesText_;
    private static String sepDrawerText_;
    private static String advancedTabText_;
    private static String autoEndText_;
    private static String whenToEndText_;
    private static String directPrintText_;
    private static String formAlignText_;
    private static String firstFileText_;
    private static String jobNameText_;
    private static String jobUserText_;
    private static String jobNumberText_;
    private static String fileNumberText_;
    private static String startPageText_;
    private static String writerNameText_;
    private static String noText_;
    private static String yesText_;
    private static String onlyText_;
    private static String afterAllText_;
    private static String afterCurrentText_;
    private static String writerDefText_;
    private static String onlyFirstFileText_;
    private static String fileFirstAvailText_;
    private static String fileLastAvailText_;
    private static String defStartPageText_;
    private static boolean stringsLoaded_;
    private Object stringsLock_ = new Object();
    private Printer printer_ = null;
    private JComboBox outqBox_ = null;
    private JComboBox outqLibBox_ = null;
    private JComboBox msgqBox_ = null;
    private JComboBox msgqLibBox_ = null;
    private JComboBox formTypeBox_ = null;
    private JComboBox formNotifyBox_ = null;
    private JComboBox numSepPageBox_ = null;
    private JComboBox sepDrawerBox_ = null;
    private JComboBox writerNameBox_ = null;
    private JComboBox autoEndBox_ = null;
    private JComboBox whenToEndBox_ = null;
    private JComboBox directPrintBox_ = null;
    private JComboBox formAlignBox_ = null;
    private JComboBox firstFileBox_ = null;
    private JComboBox fileNumberBox_ = null;
    private JComboBox startingPageBox_ = null;
    private JTextField jobNameField_ = null;
    private JTextField jobUserField_ = null;
    private JTextField jobNumberField_ = null;

    public PrinterStartAction(VObject object, Printer printer) {
        super(object);
        this.printer_ = printer;
    }

    private JPanel buildGeneralPane() throws Exception {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            int i;
            String tempStr = prtStartWtrText_;
            VUtilities.constrain(new JLabel(tempStr), panel, layout, 0, 0, 1, 1);
            JTextField text = new JTextField(this.printer_.getName().trim());
            text.setEditable(false);
            VUtilities.constrain(text, panel, layout, 1, 0, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 1, 2, 1);
            VUtilities.constrain(new JLabel(outQText_), panel, layout, 0, 2, 1, 1);
            this.outqBox_ = new JComboBox();
            this.outqBox_.setEditable(true);
            this.outqBox_.addItem(prtrDefText_);
            this.outqBox_.setSelectedItem(prtrDefText_);
            VUtilities.constrain(this.outqBox_, panel, layout, 1, 2, 1, 1);
            VUtilities.constrain(new JLabel(outQLibText_), panel, layout, 0, 3, 1, 1);
            this.outqLibBox_ = new JComboBox();
            this.outqLibBox_.setEditable(true);
            this.outqLibBox_.addItem(libListText_);
            this.outqLibBox_.addItem(curLibText_);
            this.outqLibBox_.setSelectedItem(libListText_);
            VUtilities.constrain(this.outqLibBox_, panel, layout, 1, 3, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 4, 2, 1);
            VUtilities.constrain(new JLabel(msgQText_), panel, layout, 0, 5, 1, 1);
            this.msgqBox_ = new JComboBox();
            this.msgqBox_.setEditable(true);
            this.msgqBox_.addItem(prtrDefText_);
            this.msgqBox_.addItem(userDefText_);
            this.msgqBox_.setSelectedItem(prtrDefText_);
            VUtilities.constrain(this.msgqBox_, panel, layout, 1, 5, 1, 1);
            VUtilities.constrain(new JLabel(msgQLibText_), panel, layout, 0, 6, 1, 1);
            this.msgqLibBox_ = new JComboBox();
            this.msgqLibBox_.setEditable(true);
            this.msgqLibBox_.addItem(libListText_);
            this.msgqLibBox_.addItem(curLibText_);
            this.msgqLibBox_.setSelectedItem(libListText_);
            VUtilities.constrain(this.msgqLibBox_, panel, layout, 1, 6, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 7, 2, 1);
            VUtilities.constrain(new JLabel(formTypeText_), panel, layout, 0, 8, 1, 1);
            this.formTypeBox_ = new JComboBox();
            this.formTypeBox_.setEditable(true);
            this.formTypeBox_.addItem(formTypeAllText_);
            this.formTypeBox_.addItem(formTypeStdText_);
            this.formTypeBox_.addItem(formTypeAGBTText_);
            this.formTypeBox_.setSelectedItem(formTypeAllText_);
            VUtilities.constrain(this.formTypeBox_, panel, layout, 1, 8, 1, 1);
            VUtilities.constrain(new JLabel(formTypeNotifyText_), panel, layout, 0, 9, 1, 1);
            this.formNotifyBox_ = new JComboBox();
            this.formNotifyBox_.setEditable(false);
            this.formNotifyBox_.addItem(inqMsgTypeText_);
            this.formNotifyBox_.addItem(inqInfoMsgTypeText_);
            this.formNotifyBox_.addItem(infoMsgTypeText_);
            this.formNotifyBox_.addItem(noneMsgTypeText_);
            VUtilities.constrain(this.formNotifyBox_, panel, layout, 1, 9, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 10, 2, 1);
            VUtilities.constrain(new JLabel(numSepPagesText_), panel, layout, 0, 11, 1, 1);
            this.numSepPageBox_ = new JComboBox();
            this.numSepPageBox_.setEditable(false);
            this.numSepPageBox_.addItem(fileDefText_);
            for (i = 0; i < 10; ++i) {
                this.numSepPageBox_.addItem(String.valueOf(i));
            }
            this.numSepPageBox_.addItem(userDefText_);
            VUtilities.constrain(this.numSepPageBox_, panel, layout, 1, 11, 1, 1);
            VUtilities.constrain(new JLabel(sepDrawerText_), panel, layout, 0, 12, 1, 1);
            this.sepDrawerBox_ = new JComboBox();
            this.sepDrawerBox_.setEditable(false);
            this.sepDrawerBox_.addItem(dvceDefText_);
            for (i = 1; i < 256; ++i) {
                this.sepDrawerBox_.addItem(String.valueOf(i));
            }
            VUtilities.constrain(this.sepDrawerBox_, panel, layout, 1, 12, 1, 1);
        }
        catch (Exception e) {
            panel = null;
            this.fireError(e);
        }
        return panel;
    }

    private JPanel buildAdvancedPane() throws Exception {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            VUtilities.constrain(new JLabel(writerNameText_), panel, layout, 0, 0, 1, 1);
            this.writerNameBox_ = new JComboBox();
            this.writerNameBox_.setEditable(true);
            this.writerNameBox_.addItem(prtrDefText_);
            this.writerNameBox_.setSelectedItem(prtrDefText_);
            VUtilities.constrain(this.writerNameBox_, panel, layout, 1, 0, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 1, 2, 1);
            VUtilities.constrain(new JLabel(autoEndText_), panel, layout, 0, 2, 1, 1);
            this.autoEndBox_ = new JComboBox();
            this.autoEndBox_.setEditable(false);
            this.autoEndBox_.addItem(noText_);
            this.autoEndBox_.addItem(yesText_);
            VUtilities.constrain(this.autoEndBox_, panel, layout, 1, 2, 1, 1);
            VUtilities.constrain(new JLabel(whenToEndText_), panel, layout, 0, 3, 1, 1);
            this.whenToEndBox_ = new JComboBox();
            this.whenToEndBox_.setEditable(false);
            this.whenToEndBox_.addItem(afterAllText_);
            this.whenToEndBox_.addItem(afterCurrentText_);
            VUtilities.constrain(this.whenToEndBox_, panel, layout, 1, 3, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 4, 2, 1);
            VUtilities.constrain(new JLabel(directPrintText_), panel, layout, 0, 5, 1, 1);
            this.directPrintBox_ = new JComboBox();
            this.directPrintBox_.setEditable(false);
            this.directPrintBox_.addItem(noText_);
            this.directPrintBox_.addItem(yesText_);
            VUtilities.constrain(this.directPrintBox_, panel, layout, 1, 5, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 6, 2, 1);
            VUtilities.constrain(new JLabel(formAlignText_), panel, layout, 0, 7, 1, 1);
            this.formAlignBox_ = new JComboBox();
            this.formAlignBox_.setEditable(false);
            this.formAlignBox_.addItem(fileDefText_);
            this.formAlignBox_.addItem(writerDefText_);
            this.formAlignBox_.addItem(onlyFirstFileText_);
            this.formAlignBox_.setSelectedItem(writerDefText_);
            VUtilities.constrain(this.formAlignBox_, panel, layout, 1, 7, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 8, 2, 1);
            VUtilities.constrain(new JLabel(firstFileText_), panel, layout, 0, 9, 1, 1);
            this.firstFileBox_ = new JComboBox();
            this.firstFileBox_.setEditable(true);
            this.firstFileBox_.addItem(fileFirstAvailText_);
            this.firstFileBox_.addItem(fileLastAvailText_);
            this.firstFileBox_.setSelectedItem(fileFirstAvailText_);
            VUtilities.constrain(this.firstFileBox_, panel, layout, 1, 9, 1, 1);
            VUtilities.constrain(new JLabel(jobNameText_), panel, layout, 0, 10, 1, 1);
            this.jobNameField_ = new JTextField(10);
            this.jobNameField_.setText("*");
            this.jobNameField_.setEditable(true);
            VUtilities.constrain(this.jobNameField_, panel, layout, 1, 10, 1, 1);
            VUtilities.constrain(new JLabel(jobUserText_), panel, layout, 0, 11, 1, 1);
            this.jobUserField_ = new JTextField(10);
            this.jobUserField_.setText("");
            this.jobUserField_.setEditable(true);
            VUtilities.constrain(this.jobUserField_, panel, layout, 1, 11, 1, 1);
            VUtilities.constrain(new JLabel(jobNumberText_), panel, layout, 0, 12, 1, 1);
            this.jobNumberField_ = new JTextField(10);
            this.jobNumberField_.setText("");
            this.jobNumberField_.setEditable(true);
            VUtilities.constrain(this.jobNumberField_, panel, layout, 1, 12, 1, 1);
            VUtilities.constrain(new JLabel(fileNumberText_), panel, layout, 0, 13, 1, 1);
            this.fileNumberBox_ = new JComboBox();
            this.fileNumberBox_.setEditable(true);
            this.fileNumberBox_.addItem(onlyText_);
            this.fileNumberBox_.addItem(fileLastAvailText_);
            this.fileNumberBox_.setSelectedItem(onlyText_);
            VUtilities.constrain(this.fileNumberBox_, panel, layout, 1, 13, 1, 1);
            VUtilities.constrain(new JLabel(" "), panel, layout, 0, 14, 2, 1);
            VUtilities.constrain(new JLabel(startPageText_), panel, layout, 0, 15, 1, 1);
            this.startingPageBox_ = new JComboBox();
            this.startingPageBox_.setEditable(true);
            this.startingPageBox_.addItem(defStartPageText_);
            this.startingPageBox_.setSelectedItem(defStartPageText_);
            VUtilities.constrain(this.startingPageBox_, panel, layout, 1, 15, 1, 1);
        }
        catch (Exception e) {
            panel = null;
            this.fireError(e);
        }
        return panel;
    }

    @Override
    public JComponent getInputComponent() {
        JTabbedPane tabbedPane = null;
        try {
            if (!stringsLoaded_) {
                this.loadMRI();
            }
            tabbedPane = new JTabbedPane();
            tabbedPane.addTab(generalTabText_, null, this.buildGeneralPane());
            tabbedPane.addTab(advancedTabText_, null, this.buildAdvancedPane());
            tabbedPane.setSelectedIndex(0);
            return tabbedPane;
        }
        catch (Exception e) {
            tabbedPane = null;
            this.fireError(e);
            return tabbedPane;
        }
    }

    @Override
    public String getText() {
        return displayName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMRI() {
        Object object = this.stringsLock_;
        synchronized (object) {
            prtStartWtrText_ = ResourceLoader.getPrintText("PRINTER_TO_START") + ":";
            generalTabText_ = ResourceLoader.getPrintText("GENERAL");
            outQText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE") + ":";
            outQLibText_ = ResourceLoader.getPrintText("OUTPUT_QUEUE_LIB") + ":";
            msgQText_ = ResourceLoader.getText("MESSAGE_QUEUE_DESCRIPTION") + ":";
            msgQLibText_ = ResourceLoader.getPrintText("MESSAGE_QUEUE_LIB_DESCRIPTION") + ":";
            libListText_ = ResourceLoader.getPrintText("USE_LIBRARY_LIST");
            curLibText_ = ResourceLoader.getPrintText("USE__CURRENT_LIBRARY");
            prtrDefText_ = ResourceLoader.getPrintText("PRINTER_DEFAULT");
            userDefText_ = ResourceLoader.getPrintText("USER_DEFAULT");
            dvceDefText_ = ResourceLoader.getPrintText("DEVICE_DEFAULT");
            fileDefText_ = ResourceLoader.getPrintText("FILE_DEFAULT");
            inqMsgTypeText_ = ResourceLoader.getPrintText("MESSAGE_TYPE_INQUIRY");
            inqInfoMsgTypeText_ = ResourceLoader.getPrintText("MESSAGE_TYPE_INQ_INFO");
            infoMsgTypeText_ = ResourceLoader.getPrintText("MESSAGE_TYPE_INFO");
            noneMsgTypeText_ = ResourceLoader.getPrintText("MESSAGE_TYPE_NONE");
            formTypeText_ = ResourceLoader.getPrintText("FORM_TYPE") + ":";
            formTypeNotifyText_ = ResourceLoader.getPrintText("FORM_TYPE_NOTIFY") + ":";
            formTypeAllText_ = ResourceLoader.getPrintText("FORM_TYPE_ALL");
            formTypeStdText_ = ResourceLoader.getPrintText("FORM_TYPE_STANDARD");
            formTypeAGBTText_ = ResourceLoader.getPrintText("FORM_TYPE_ALL_GBT");
            numSepPagesText_ = ResourceLoader.getPrintText("NUMBER_OF_SEP_PAGES") + ":";
            sepDrawerText_ = ResourceLoader.getPrintText("SEPARATOR_DRAWER") + ":";
            advancedTabText_ = ResourceLoader.getPrintText("ADVANCED");
            autoEndText_ = ResourceLoader.getPrintText("WRITER_AUTO_END") + ":";
            whenToEndText_ = ResourceLoader.getPrintText("WRITER_WHEN_TO_END") + ":";
            directPrintText_ = ResourceLoader.getPrintText("DIRECT_PRINT") + ":";
            formAlignText_ = ResourceLoader.getPrintText("FORM_ALIGN") + ":";
            firstFileText_ = ResourceLoader.getPrintText("FIRST_FILE_NAME") + ":";
            jobNameText_ = ResourceLoader.getPrintText("FIRST_JOB_NAME") + ":";
            jobUserText_ = ResourceLoader.getPrintText("FIRST_JOB_USER") + ":";
            jobNumberText_ = ResourceLoader.getPrintText("FIRST_JOB_NUMBER") + ":";
            fileNumberText_ = ResourceLoader.getPrintText("FIRST_FILE_NUMBER") + ":";
            startPageText_ = ResourceLoader.getPrintText("FIRST_START_PAGE") + ":";
            writerNameText_ = ResourceLoader.getPrintText("WRITER_NAME") + ":";
            noText_ = ResourceLoader.getPrintText("NO");
            yesText_ = ResourceLoader.getPrintText("YES");
            onlyText_ = ResourceLoader.getPrintText("ONLY");
            afterAllText_ = ResourceLoader.getPrintText("FILE_AFTER_ALL");
            afterCurrentText_ = ResourceLoader.getPrintText("FILE_AFTER_CURRENT");
            writerDefText_ = ResourceLoader.getPrintText("WRITER_DEFAULT");
            onlyFirstFileText_ = ResourceLoader.getPrintText("FILE_FORM_ALIGNMENT");
            fileFirstAvailText_ = ResourceLoader.getPrintText("FILE_FIRST_AVAILABLE");
            fileLastAvailText_ = ResourceLoader.getPrintText("FILE_LAST");
            defStartPageText_ = ResourceLoader.getPrintText("DEF_START_PAGE");
            stringsLoaded_ = true;
        }
    }

    @Override
    public void perform2() {
        try {
            String selectedItem = null;
            String selectedItem2 = null;
            this.fireStartWorking();
            StringBuilder cmdString_ = new StringBuilder("STRPRTWTR DEV(" + this.printer_.getName().trim() + ") OUTQ(");
            selectedItem = (String)this.outqBox_.getModel().getSelectedItem();
            if (selectedItem == null || selectedItem.equals(prtrDefText_)) {
                cmdString_.append("*DEV) MSGQ(");
            } else {
                selectedItem2 = (String)this.outqLibBox_.getModel().getSelectedItem();
                if (selectedItem2.equals(libListText_)) {
                    cmdString_.append("*LIBL/");
                } else if (selectedItem2.equals(curLibText_)) {
                    cmdString_.append("*CURLIB/");
                } else if (selectedItem2.equals("")) {
                    cmdString_.append("*LIBL/");
                } else {
                    cmdString_.append(selectedItem2).append("/");
                }
                cmdString_.append(selectedItem).append(") MSGQ(");
            }
            selectedItem = (String)this.msgqBox_.getModel().getSelectedItem();
            if (selectedItem == null || selectedItem.equals(prtrDefText_)) {
                cmdString_.append("*DEVD) FORMTYPE(");
            } else if (selectedItem.equals(userDefText_)) {
                cmdString_.append("*REQUESTER) FORMTYPE(");
            } else {
                selectedItem2 = (String)this.msgqLibBox_.getModel().getSelectedItem();
                if (selectedItem2.equals(libListText_)) {
                    cmdString_.append("*LIBL/");
                } else if (selectedItem2.equals(curLibText_)) {
                    cmdString_.append("*CURLIB/");
                } else if (selectedItem2.equals("")) {
                    cmdString_.append("*LIBL/");
                } else {
                    cmdString_.append(selectedItem2).append("/");
                }
                cmdString_.append(selectedItem).append(") FORMTYPE(");
            }
            selectedItem = (String)this.formTypeBox_.getModel().getSelectedItem();
            if (selectedItem == null || selectedItem.equals(formTypeAllText_)) {
                cmdString_.append("*ALL ");
            } else if (selectedItem.equals(formTypeStdText_)) {
                cmdString_.append("*STD ");
            } else if (selectedItem.equals(formTypeAGBTText_)) {
                cmdString_.append("*FORMS ");
            } else {
                cmdString_.append(selectedItem).append(" ");
            }
            selectedItem = (String)this.formNotifyBox_.getModel().getSelectedItem();
            if (selectedItem == null || selectedItem.equals(inqMsgTypeText_)) {
                cmdString_.append("*INQMSG) FILESEP(");
            } else if (selectedItem.equals(inqInfoMsgTypeText_)) {
                cmdString_.append("*MSG) FILESEP(");
            } else if (selectedItem.equals(infoMsgTypeText_)) {
                cmdString_.append("*INFOMSG) FILESEP(");
            } else {
                cmdString_.append("*NOMSG) FILESEP(");
            }
            selectedItem = (String)this.numSepPageBox_.getModel().getSelectedItem();
            if (selectedItem == null || selectedItem.equals(fileDefText_)) {
                cmdString_.append("*FILE) SEPDRAWER(");
            } else {
                cmdString_.append(selectedItem).append(") SEPDRAWER(");
            }
            selectedItem = (String)this.sepDrawerBox_.getModel().getSelectedItem();
            if (selectedItem == null || selectedItem.equals(dvceDefText_)) {
                cmdString_.append("*DEVD)");
            } else if (selectedItem.equals(fileDefText_)) {
                cmdString_.append("*FILE)");
            } else {
                cmdString_.append(selectedItem).append(")");
            }
            selectedItem = (String)this.writerNameBox_.getModel().getSelectedItem();
            if (selectedItem != null && !selectedItem.equals(prtrDefText_)) {
                cmdString_.append(" WTR(").append(selectedItem).append(")");
            }
            if ((selectedItem = (String)this.autoEndBox_.getModel().getSelectedItem()) != null && !selectedItem.equals(noText_)) {
                cmdString_.append(" AUTOEND(*YES ");
                selectedItem = (String)this.whenToEndBox_.getModel().getSelectedItem();
                if (selectedItem.equals(afterCurrentText_)) {
                    cmdString_.append("*FILEEND)");
                } else {
                    cmdString_.append("*NORDYF)");
                }
            }
            if ((selectedItem = (String)this.directPrintBox_.getModel().getSelectedItem()) != null && selectedItem.equals(yesText_)) {
                cmdString_.append(" ALWDRTPRT(*YES)");
            }
            if ((selectedItem = (String)this.formAlignBox_.getModel().getSelectedItem()) != null) {
                if (selectedItem.equals(fileDefText_)) {
                    cmdString_.append(" ALIGN(*FILE)");
                } else if (!selectedItem.equals(onlyFirstFileText_)) {
                    cmdString_.append(" ALIGN(*FIRST)");
                }
            } else {
                cmdString_.append(" ALIGN(*FIRST)");
            }
            selectedItem = (String)this.firstFileBox_.getModel().getSelectedItem();
            if (selectedItem != null && !selectedItem.equals(fileFirstAvailText_)) {
                if (selectedItem.equals(fileLastAvailText_)) {
                    cmdString_.append(" FILE(*LAST)");
                } else {
                    cmdString_.append(" FILE(").append(selectedItem).append(") JOB(");
                    cmdString_.append(this.jobNumberField_.getText()).append("/");
                    cmdString_.append(this.jobUserField_.getText()).append("/");
                    cmdString_.append(this.jobNameField_.getText()).append(") SPLNBR(");
                    selectedItem = (String)this.fileNumberBox_.getModel().getSelectedItem();
                    if (selectedItem.equals(onlyText_)) {
                        cmdString_.append("*ONLY)");
                    } else if (selectedItem.equals(fileLastAvailText_)) {
                        cmdString_.append("*LAST)");
                    } else {
                        cmdString_.append(selectedItem).append(")");
                    }
                }
            }
            if ((selectedItem = (String)this.startingPageBox_.getModel().getSelectedItem()) != null && !selectedItem.equals(defStartPageText_)) {
                cmdString_.append(" PAGE(").append(selectedItem).append(")");
            }
            CommandCall cmd = new CommandCall(this.printer_.getSystem());
            try {
                if (!cmd.run(cmdString_.toString())) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "STRPRTWTR cmd=false for [" + this.printer_.getName() + "].");
                    }
                    Exception e = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                    this.fireError(e);
                } else {
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Started writer for printer[" + this.printer_.getName() + "].");
                    }
                    this.fireObjectChanged();
                }
                if (Trace.isTraceOn()) {
                    AS400Message[] messagelist = cmd.getMessageList();
                    for (int i = 0; i < messagelist.length; ++i) {
                        Trace.log(3, messagelist[i].getText());
                    }
                }
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "ERROR CommandCall exception for starting [" + this.printer_.getName() + "].");
                }
                this.fireError(e);
            }
            this.fireStopWorking();
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR Starting writer for printer [" + this.printer_.getName() + "].");
            }
            this.fireError(e);
        }
    }

    static {
        stringsLoaded_ = false;
    }
}

