/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SQLStatementDocument
extends PlainDocument
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    private SQLConnection connection_ = null;
    private transient SQLWarning warnings_ = null;
    private transient Statement statement_ = null;
    private transient String sql_ = "";

    public SQLStatementDocument() {
    }

    public SQLStatementDocument(SQLConnection connection, String text) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        try {
            this.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.connection_ = connection;
    }

    public void addActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.addActionCompletedListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingListeners_.addWorkingListener(listener);
    }

    public void execute() {
        if (this.connection_ == null) {
            IllegalStateException e = new IllegalStateException("connection");
            this.errorListeners_.fireError(e);
            return;
        }
        this.workingListeners_.fireStartWorking();
        if (this.statement_ == null) {
            Connection conn;
            try {
                conn = this.connection_.getConnection();
                this.statement_ = conn.createStatement();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
                return;
            }
            try {
                this.warnings_ = conn.getWarnings();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
        } else {
            this.warnings_ = null;
            try {
                this.statement_.clearWarnings();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
        }
        try {
            this.sql_ = this.getText(0, this.getLength());
            this.statement_.execute(this.sql_);
        }
        catch (BadLocationException e) {
            this.errorListeners_.fireError(e);
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        this.actionListeners_.fireActionCompleted();
        this.workingListeners_.fireStopWorking();
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public void getMoreResults() {
        if (this.statement_ != null) {
            this.workingListeners_.fireStartWorking();
            try {
                this.statement_.getMoreResults();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
            this.workingListeners_.fireStopWorking();
        }
    }

    public ResultSet getResultSet() {
        if (this.statement_ == null) {
            return null;
        }
        this.workingListeners_.fireStartWorking();
        ResultSet result = null;
        try {
            result = this.statement_.getResultSet();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        this.workingListeners_.fireStopWorking();
        return result;
    }

    public String getSQLStatement() {
        return this.sql_;
    }

    public int getUpdateCount() {
        if (this.statement_ == null) {
            return -1;
        }
        try {
            return this.statement_.getUpdateCount();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
            return 0;
        }
    }

    public SQLWarning getWarnings() {
        if (this.statement_ == null) {
            return null;
        }
        SQLWarning s_warnings = null;
        try {
            s_warnings = this.statement_.getWarnings();
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        if (this.warnings_ != null) {
            SQLWarning next;
            if (s_warnings == null) {
                return this.warnings_;
            }
            SQLWarning last = this.warnings_;
            while ((next = last.getNextWarning()) != null) {
                last = next;
            }
            last.setNextWarning(s_warnings);
            return this.warnings_;
        }
        return s_warnings;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.warnings_ = null;
        this.statement_ = null;
        this.sql_ = "";
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.removeActionCompletedListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingListeners_.removeWorkingListener(listener);
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.vetoListeners_.fireVetoableChange("connection", this.connection_, connection);
        SQLConnection old = this.connection_;
        this.connection_ = connection;
        if (old != connection) {
            if (this.statement_ != null) {
                try {
                    this.statement_.close();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
            }
            this.statement_ = null;
            this.warnings_ = null;
        }
        this.changeListeners_.firePropertyChange("connection", old, this.connection_);
    }
}

