/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc.saml;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.hive.jdbc.saml.IJdbcBrowserClient;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class HiveJdbcSamlRedirectStrategy
extends DefaultRedirectStrategy {
    private final IJdbcBrowserClient browserClient;

    public HiveJdbcSamlRedirectStrategy(IJdbcBrowserClient browserClient) {
        this.browserClient = (IJdbcBrowserClient)Preconditions.checkNotNull((Object)browserClient);
    }

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 302 || status == 303) {
            URI locationUri = this.getLocationURI(request, response, context);
            Header clientIdentifier = response.getFirstHeader("X-Hive-Client-Identifier");
            IJdbcBrowserClient.JdbcBrowserClientContext browserClientContext = new IJdbcBrowserClient.JdbcBrowserClientContext(locationUri, clientIdentifier.getValue());
            this.browserClient.init(browserClientContext);
        }
        return super.isRedirected(request, response, context);
    }

    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        return HiveJdbcSamlRedirectStrategy.checkSsoUri(super.getLocationURI(request, response, context));
    }

    static URI checkSsoUri(URI uri) throws ProtocolException {
        boolean valid;
        if (uri == null) {
            throw new ProtocolException("SSO Url is null");
        }
        String scheme = uri.getScheme();
        boolean bl = valid = ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) && uri.isAbsolute();
        if (!valid) {
            throw new ProtocolException("SSO Url " + uri.toString() + "is invalid");
        }
        return uri;
    }
}

