/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.flink.translation.wrappers.streaming.SingletonKeyedWorkItem;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SingletonKeyedWorkItemCoder<@UnknownKeyFor K, @UnknownKeyFor ElemT>
extends StructuredCoder<KeyedWorkItem<K, ElemT>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WindowedValues.FullWindowedValueCoder<ElemT> valueCoder;

    public static <K, ElemT> @UnknownKeyFor @NonNull @Initialized SingletonKeyedWorkItemCoder<K, ElemT> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        return new SingletonKeyedWorkItemCoder<K, ElemT>(keyCoder, elemCoder, windowCoder);
    }

    private SingletonKeyedWorkItemCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.elemCoder = elemCoder;
        this.windowCoder = windowCoder;
        this.valueCoder = WindowedValues.FullWindowedValueCoder.of(elemCoder, windowCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<ElemT> getElementCoder() {
        return this.elemCoder;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, ElemT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        SingletonKeyedWorkItem cast = (SingletonKeyedWorkItem)value;
        this.keyCoder.encode(cast.key(), outStream);
        this.valueCoder.encode(cast.value(), outStream, context);
    }

    public @UnknownKeyFor @NonNull @Initialized SingletonKeyedWorkItem<K, ElemT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public @UnknownKeyFor @NonNull @Initialized SingletonKeyedWorkItem<K, ElemT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        Object key = this.keyCoder.decode(inStream);
        WindowedValue value = this.valueCoder.decode(inStream, context);
        return new SingletonKeyedWorkItem(key, value);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return ImmutableList.of(this.keyCoder, this.elemCoder, this.windowCoder);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
        this.elemCoder.verifyDeterministic();
        this.windowCoder.verifyDeterministic();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return false;
    }
}

