/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class WriteGroupedRecordsToFiles<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends DoFn<KV<DestinationT, Iterable<ElementT>>, WriteBundlesToFiles.Result<DestinationT>> {
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix;
    private final @UnknownKeyFor @NonNull @Initialized long maxFileSize;
    private final @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory;
    private final @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized WriteBundlesToFiles.Result<DestinationT>> successfulResultsTag;
    private final @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder;

    WriteGroupedRecordsToFiles(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix, @UnknownKeyFor @NonNull @Initialized long maxFileSize, @UnknownKeyFor @NonNull @Initialized RowWriterFactory<ElementT, DestinationT> rowWriterFactory, @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized WriteBundlesToFiles.Result<DestinationT>> successfulResultsTag, @UnknownKeyFor @NonNull @Initialized Coder<ElementT> elementCoder) {
        this.tempFilePrefix = tempFilePrefix;
        this.maxFileSize = maxFileSize;
        this.rowWriterFactory = rowWriterFactory;
        this.badRecordRouter = badRecordRouter;
        this.successfulResultsTag = successfulResultsTag;
        this.elementCoder = elementCoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized Iterable<ElementT>> element, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
        try (BigQueryRowWriter<ElementT> writer = this.rowWriterFactory.createRowWriter(tempFilePrefix, element.getKey());){
            for (Object tableRow : (Iterable)element.getValue()) {
                if (writer.getByteSize() > this.maxFileSize) {
                    writer.close();
                    BigQueryRowWriter.Result result = writer.getResult();
                    outputReceiver.get(this.successfulResultsTag).output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((KV)c.element()).getKey()));
                    writer = this.rowWriterFactory.createRowWriter(tempFilePrefix, element.getKey());
                }
                try {
                    writer.write(tableRow);
                }
                catch (BigQueryRowWriter.BigQueryRowSerializationException e) {
                    this.badRecordRouter.route(outputReceiver, tableRow, this.elementCoder, (Exception)e, "Unable to Write BQ Record to File");
                }
            }
        }
        BigQueryRowWriter.Result result = writer.getResult();
        outputReceiver.get(this.successfulResultsTag).output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((KV)c.element()).getKey()));
    }
}

