/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.Serializable;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProtoFromBytes<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Message>
extends PTransform<PCollection<byte[]>, PCollection<T>> {
    private final @UnknownKeyFor @NonNull @Initialized ProtoParser<T> parser;

    ProtoFromBytes(@UnknownKeyFor @NonNull @Initialized ProtoParser<T> parser) {
        this.parser = parser;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<byte[], T>(){

            public T apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
                try {
                    return (Message)ProtoFromBytes.this.parser.parse(bytes);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    static interface ProtoParser<@UnknownKeyFor T2>
    extends Serializable {
        public T2 parse(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1) throws @UnknownKeyFor @NonNull @Initialized InvalidProtocolBufferException;
    }
}

