/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl;

import io.github.spannm.jackcess.impl.DatabaseImpl;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class ByteUtil {
    private static final String[] HEX_CHARS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final int NUM_BYTES_PER_BLOCK = 4;
    private static final int NUM_BYTES_PER_LINE = 24;

    private ByteUtil() {
    }

    public static void put3ByteInt(ByteBuffer buffer, int val) {
        ByteUtil.put3ByteInt(buffer, val, buffer.order());
    }

    public static void put3ByteInt(ByteBuffer buffer, int val, ByteOrder order) {
        int pos = buffer.position();
        ByteUtil.put3ByteInt(buffer, val, pos, order);
        buffer.position(pos + 3);
    }

    public static void put3ByteInt(ByteBuffer buffer, int val, int offset, ByteOrder order) {
        int offInc = 1;
        if (order == ByteOrder.BIG_ENDIAN) {
            offInc = -1;
            offset += 2;
        }
        buffer.put(offset, (byte)(val & 0xFF));
        buffer.put(offset + 1 * offInc, (byte)(val >>> 8 & 0xFF));
        buffer.put(offset + 2 * offInc, (byte)(val >>> 16 & 0xFF));
    }

    public static int get3ByteInt(ByteBuffer buffer) {
        return ByteUtil.get3ByteInt(buffer, buffer.order());
    }

    public static int get3ByteInt(ByteBuffer buffer, ByteOrder order) {
        int pos = buffer.position();
        int rtn = ByteUtil.get3ByteInt(buffer, pos, order);
        buffer.position(pos + 3);
        return rtn;
    }

    public static int get3ByteInt(ByteBuffer buffer, int offset) {
        return ByteUtil.get3ByteInt(buffer, offset, buffer.order());
    }

    public static int get3ByteInt(ByteBuffer buffer, int offset, ByteOrder order) {
        int offInc = 1;
        if (order == ByteOrder.BIG_ENDIAN) {
            offInc = -1;
            offset += 2;
        }
        int rtn = ByteUtil.getUnsignedByte(buffer, offset);
        rtn += ByteUtil.getUnsignedByte(buffer, offset + 1 * offInc) << 8;
        return rtn += ByteUtil.getUnsignedByte(buffer, offset + 2 * offInc) << 16;
    }

    public static int getUnsignedByte(ByteBuffer buffer) {
        int pos = buffer.position();
        int rtn = ByteUtil.getUnsignedByte(buffer, pos);
        buffer.position(pos + 1);
        return rtn;
    }

    public static int getUnsignedByte(ByteBuffer buffer, int offset) {
        return ByteUtil.asUnsignedByte(buffer.get(offset));
    }

    public static int getUnsignedShort(ByteBuffer buffer) {
        int pos = buffer.position();
        int rtn = ByteUtil.getUnsignedShort(buffer, pos);
        buffer.position(pos + 2);
        return rtn;
    }

    public static int getUnsignedShort(ByteBuffer buffer, int offset) {
        return ByteUtil.asUnsignedShort(buffer.getShort(offset));
    }

    public static int getInt(ByteBuffer buffer, ByteOrder order) {
        int offset = buffer.position();
        int rtn = ByteUtil.getInt(buffer, offset, order);
        buffer.position(offset + 4);
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInt(ByteBuffer buffer, int offset, ByteOrder order) {
        ByteOrder origOrder = buffer.order();
        try {
            int n = buffer.order(order).getInt(offset);
            return n;
        }
        finally {
            buffer.order(origOrder);
        }
    }

    public static void putInt(ByteBuffer buffer, int val, ByteOrder order) {
        int offset = buffer.position();
        ByteUtil.putInt(buffer, val, offset, order);
        buffer.position(offset + 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInt(ByteBuffer buffer, int val, int offset, ByteOrder order) {
        ByteOrder origOrder = buffer.order();
        try {
            buffer.order(order).putInt(offset, val);
        }
        finally {
            buffer.order(origOrder);
        }
    }

    public static int getUnsignedVarInt(ByteBuffer buffer, int numBytes) {
        int pos = buffer.position();
        int rtn = ByteUtil.getUnsignedVarInt(buffer, pos, numBytes);
        buffer.position(pos + numBytes);
        return rtn;
    }

    public static int getUnsignedVarInt(ByteBuffer buffer, int offset, int numBytes) {
        switch (numBytes) {
            case 1: {
                return ByteUtil.getUnsignedByte(buffer, offset);
            }
            case 2: {
                return ByteUtil.getUnsignedShort(buffer, offset);
            }
            case 3: {
                return ByteUtil.get3ByteInt(buffer, offset);
            }
            case 4: {
                return buffer.getInt(offset);
            }
        }
        throw new IllegalArgumentException("Invalid num bytes " + numBytes);
    }

    public static byte[] getBytes(ByteBuffer buffer, int len) {
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ByteBuffer buffer, int offset, int len) {
        int origPos = buffer.position();
        try {
            buffer.position(offset);
            byte[] byArray = ByteUtil.getBytes(buffer, len);
            return byArray;
        }
        finally {
            buffer.position(origPos);
        }
    }

    public static byte[] concat(byte[] b1, byte[] b2) {
        byte[] out = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, out, 0, b1.length);
        System.arraycopy(b2, 0, out, b1.length, b2.length);
        return out;
    }

    public static void clearRemaining(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return;
        }
        int pos = buffer.position();
        ByteUtil.clearRange(buffer, pos, pos + buffer.remaining());
    }

    public static void clearRange(ByteBuffer buffer, int start, int end) {
        ByteUtil.putRange(buffer, start, end, (byte)0);
    }

    public static void fillRange(ByteBuffer buffer, int start, int end) {
        ByteUtil.putRange(buffer, start, end, (byte)-1);
    }

    public static void putRange(ByteBuffer buffer, int start, int end, byte b) {
        for (int i = start; i < end; ++i) {
            buffer.put(i, b);
        }
    }

    public static boolean matchesRange(ByteBuffer buffer, int start, byte[] pattern) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == buffer.get(start + i)) continue;
            return false;
        }
        return true;
    }

    public static int findRange(ByteBuffer buffer, int start, byte[] pattern) {
        byte firstByte = pattern[0];
        int limit = buffer.limit() - pattern.length;
        for (int i = start; i < limit; ++i) {
            if (firstByte != buffer.get(i) || !ByteUtil.matchesRange(buffer, i, pattern)) continue;
            return i;
        }
        return -1;
    }

    public static void insertEmptyData(ByteBuffer buffer, int len) {
        byte[] buf = buffer.array();
        int pos = buffer.position();
        int limit = buffer.limit();
        System.arraycopy(buf, pos, buf, pos + len, limit - pos);
        Arrays.fill(buf, pos, pos + len, (byte)0);
        buffer.limit(limit + len);
    }

    public static String toHexString(ByteBuffer buffer, int size) {
        return ByteUtil.toHexString(buffer, 0, size);
    }

    public static String toHexString(byte[] array) {
        return ByteUtil.toHexString(ByteBuffer.wrap(array), 0, array.length);
    }

    public static String toHexString(ByteBuffer buffer, int offset, int size) {
        return ByteUtil.toHexString(buffer, offset, size, true);
    }

    public static String toHexString(ByteBuffer buffer, int offset, int size, boolean formatted) {
        int bufLen = size * 2;
        if (formatted) {
            bufLen += size + 7 * ((size + 24 - 1) / 24);
        }
        StringBuilder rtn = new StringBuilder(bufLen);
        int position = buffer.position();
        buffer.position(offset);
        size = Math.min(size, buffer.remaining());
        for (int i = 0; i < size; ++i) {
            byte b = buffer.get();
            byte h = (byte)(b & 0xF0);
            h = (byte)(h >>> 4);
            h = (byte)(h & 0xF);
            rtn.append(HEX_CHARS[h]);
            h = (byte)(b & 0xF);
            rtn.append(HEX_CHARS[h]);
            int next = i + 1;
            if (!formatted || next >= size) continue;
            if (next % 24 == 0) {
                rtn.append("\n");
                continue;
            }
            rtn.append(' ');
            if (next % 4 != 0) continue;
            rtn.append(' ');
        }
        buffer.position(position);
        return rtn.toString();
    }

    public static String toHexString(DatabaseImpl db, int pageNumber, int size) throws IOException {
        ByteBuffer buffer = db.getPageChannel().createPageBuffer();
        db.getPageChannel().readPage(buffer, pageNumber);
        return ByteUtil.toHexString(buffer, size);
    }

    public static void writeHexString(ByteBuffer buffer, String hexStr) throws IOException {
        char[] hexChars = hexStr.toCharArray();
        if (hexChars.length % 2 != 0) {
            throw new IOException("Hex string length must be even");
        }
        for (int i = 0; i < hexChars.length; i += 2) {
            String tmpStr = new String(hexChars, i, 2);
            buffer.put((byte)Integer.parseInt(tmpStr, 16));
        }
    }

    public static void toHexFile(String fileName, ByteBuffer buffer, int offset, int size) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(fileName));){
            writer.println(ByteUtil.toHexString(buffer, offset, size));
        }
    }

    public static int asUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int asUnsignedShort(short s) {
        return s & 0xFFFF;
    }

    public static void swap8Bytes(byte[] bytes, int offset) {
        ByteUtil.swapBytesAt(bytes, offset + 0, offset + 7);
        ByteUtil.swapBytesAt(bytes, offset + 1, offset + 6);
        ByteUtil.swapBytesAt(bytes, offset + 2, offset + 5);
        ByteUtil.swapBytesAt(bytes, offset + 3, offset + 4);
    }

    public static void swap4Bytes(byte[] bytes, int offset) {
        ByteUtil.swapBytesAt(bytes, offset + 0, offset + 3);
        ByteUtil.swapBytesAt(bytes, offset + 1, offset + 2);
    }

    public static void swap2Bytes(byte[] bytes, int offset) {
        ByteUtil.swapBytesAt(bytes, offset + 0, offset + 1);
    }

    private static void swapBytesAt(byte[] bytes, int p1, int p2) {
        byte b = bytes[p1];
        bytes[p1] = bytes[p2];
        bytes[p2] = b;
    }

    public static int forward(ByteBuffer buffer, int count) {
        int newPos = buffer.position() + count;
        buffer.position(newPos);
        return newPos;
    }

    public static byte[] copyOf(byte[] arr, int newLength) {
        return ByteUtil.copyOf(arr, 0, newLength, 0);
    }

    public static byte[] copyOf(byte[] arr, int offset, int newLength) {
        return ByteUtil.copyOf(arr, offset, newLength, 0);
    }

    public static byte[] copyOf(byte[] arr, int offset, int newLength, int dstOffset) {
        byte[] newArr = new byte[newLength];
        int srcLen = arr.length - offset;
        int dstLen = newLength - dstOffset;
        System.arraycopy(arr, offset, newArr, dstOffset, Math.min(srcLen, dstLen));
        return newArr;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[8192];
        int read = 0;
        while ((read = in.read(buf)) > -1) {
            out.write(buf, 0, read);
        }
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException ignored) {
                return;
            }
        }
    }

    public static void skipFully(DataInputStream din, int len) throws IOException {
        int skipped;
        while ((len -= (skipped = din.skipBytes(len))) > 0) {
        }
    }

    public static class ByteStream
    extends OutputStream {
        private byte[] _bytes;
        private int _length;
        private int _lastLength;

        public ByteStream() {
            this(32);
        }

        public ByteStream(int capacity) {
            this._bytes = new byte[capacity];
        }

        public int getLength() {
            return this._length;
        }

        public byte[] getBytes() {
            return this._bytes;
        }

        protected void ensureNewCapacity(int numBytes) {
            this.ensureCapacity(this._length + numBytes);
        }

        protected void ensureCapacity(int newLength) {
            if (newLength > this._bytes.length) {
                byte[] temp = new byte[newLength * 2];
                System.arraycopy(this._bytes, 0, temp, 0, this._length);
                this._bytes = temp;
            }
        }

        @Override
        public void write(int b) {
            this.ensureNewCapacity(1);
            this._bytes[this._length++] = (byte)b;
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int offset, int length) {
            this.ensureNewCapacity(length);
            System.arraycopy(b, offset, this._bytes, this._length, length);
            this._length += length;
        }

        public byte get(int offset) {
            return this._bytes[offset];
        }

        public void set(int offset, byte b) {
            this._bytes[offset] = b;
        }

        public void setBits(int offset, byte b) {
            int n = offset;
            this._bytes[n] = (byte)(this._bytes[n] | b);
        }

        public void writeFill(int length, byte b) {
            this.ensureNewCapacity(length);
            int oldLength = this._length;
            this._length += length;
            Arrays.fill(this._bytes, oldLength, this._length, b);
        }

        public void skip(int n) {
            this.ensureNewCapacity(n);
            this._length += n;
        }

        public void writeTo(ByteStream out) {
            out.write(this._bytes, 0, this._length);
        }

        public byte[] toByteArray() {
            byte[] result = null;
            if (this._length == this._bytes.length) {
                result = this._bytes;
                this._bytes = null;
            } else {
                result = ByteUtil.copyOf(this._bytes, this._length);
                if (this._lastLength == this._length) {
                    this._bytes = null;
                }
            }
            this._lastLength = this._length;
            return result;
        }

        public void reset() {
            this._length = 0;
            if (this._bytes == null) {
                this._bytes = new byte[this._lastLength];
            }
        }

        public void trimTrailing(byte minTrimCode, byte maxTrimCode) {
            int val;
            int idx;
            int minTrim = ByteUtil.asUnsignedByte(minTrimCode);
            int maxTrim = ByteUtil.asUnsignedByte(maxTrimCode);
            for (idx = this._length - 1; idx >= 0 && (val = ByteUtil.asUnsignedByte(this.get(idx))) >= minTrim && val <= maxTrim; --idx) {
            }
            this._length = idx + 1;
        }
    }
}

