/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIO;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_KinesisIO_Read
extends KinesisIO.Read {
    private final @Nullable String streamName;
    private final @Nullable String consumerArn;
    private final @Nullable StartingPoint initialPosition;
    private final ClientConfiguration clientConfiguration;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;
    private final Duration upToDateThreshold;
    private final @Nullable Integer requestRecordsLimit;
    private final WatermarkPolicyFactory watermarkPolicyFactory;
    private final RateLimitPolicyFactory rateLimitPolicyFactory;
    private final @Nullable Integer maxCapacityPerShard;
    private static final long serialVersionUID = 1L;

    private AutoValue_KinesisIO_Read(@Nullable String streamName, @Nullable String consumerArn, @Nullable StartingPoint initialPosition, ClientConfiguration clientConfiguration, long maxNumRecords, @Nullable Duration maxReadTime, Duration upToDateThreshold, @Nullable Integer requestRecordsLimit, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, @Nullable Integer maxCapacityPerShard) {
        this.streamName = streamName;
        this.consumerArn = consumerArn;
        this.initialPosition = initialPosition;
        this.clientConfiguration = clientConfiguration;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.upToDateThreshold = upToDateThreshold;
        this.requestRecordsLimit = requestRecordsLimit;
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.maxCapacityPerShard = maxCapacityPerShard;
    }

    @Override
    @Nullable String getStreamName() {
        return this.streamName;
    }

    @Override
    @Nullable String getConsumerArn() {
        return this.consumerArn;
    }

    @Override
    @Nullable StartingPoint getInitialPosition() {
        return this.initialPosition;
    }

    @Override
    ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
    Duration getUpToDateThreshold() {
        return this.upToDateThreshold;
    }

    @Override
    @Nullable Integer getRequestRecordsLimit() {
        return this.requestRecordsLimit;
    }

    @Override
    WatermarkPolicyFactory getWatermarkPolicyFactory() {
        return this.watermarkPolicyFactory;
    }

    @Override
    RateLimitPolicyFactory getRateLimitPolicyFactory() {
        return this.rateLimitPolicyFactory;
    }

    @Override
    @Nullable Integer getMaxCapacityPerShard() {
        return this.maxCapacityPerShard;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KinesisIO.Read) {
            KinesisIO.Read that = (KinesisIO.Read)((Object)o);
            return (this.streamName == null ? that.getStreamName() == null : this.streamName.equals(that.getStreamName())) && (this.consumerArn == null ? that.getConsumerArn() == null : this.consumerArn.equals(that.getConsumerArn())) && (this.initialPosition == null ? that.getInitialPosition() == null : this.initialPosition.equals(that.getInitialPosition())) && this.clientConfiguration.equals(that.getClientConfiguration()) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && this.upToDateThreshold.equals((Object)that.getUpToDateThreshold()) && (this.requestRecordsLimit == null ? that.getRequestRecordsLimit() == null : this.requestRecordsLimit.equals(that.getRequestRecordsLimit())) && this.watermarkPolicyFactory.equals(that.getWatermarkPolicyFactory()) && this.rateLimitPolicyFactory.equals(that.getRateLimitPolicyFactory()) && (this.maxCapacityPerShard == null ? that.getMaxCapacityPerShard() == null : this.maxCapacityPerShard.equals(that.getMaxCapacityPerShard()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.streamName == null ? 0 : this.streamName.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerArn == null ? 0 : this.consumerArn.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialPosition == null ? 0 : this.initialPosition.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.upToDateThreshold.hashCode();
        h$ *= 1000003;
        h$ ^= this.requestRecordsLimit == null ? 0 : this.requestRecordsLimit.hashCode();
        h$ *= 1000003;
        h$ ^= this.watermarkPolicyFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.rateLimitPolicyFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxCapacityPerShard == null ? 0 : this.maxCapacityPerShard.hashCode();
    }

    @Override
    KinesisIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends KinesisIO.Read.Builder {
        private @Nullable String streamName;
        private @Nullable String consumerArn;
        private @Nullable StartingPoint initialPosition;
        private ClientConfiguration clientConfiguration;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;
        private Duration upToDateThreshold;
        private @Nullable Integer requestRecordsLimit;
        private WatermarkPolicyFactory watermarkPolicyFactory;
        private RateLimitPolicyFactory rateLimitPolicyFactory;
        private @Nullable Integer maxCapacityPerShard;

        Builder() {
        }

        private Builder(KinesisIO.Read source) {
            this.streamName = source.getStreamName();
            this.consumerArn = source.getConsumerArn();
            this.initialPosition = source.getInitialPosition();
            this.clientConfiguration = source.getClientConfiguration();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.upToDateThreshold = source.getUpToDateThreshold();
            this.requestRecordsLimit = source.getRequestRecordsLimit();
            this.watermarkPolicyFactory = source.getWatermarkPolicyFactory();
            this.rateLimitPolicyFactory = source.getRateLimitPolicyFactory();
            this.maxCapacityPerShard = source.getMaxCapacityPerShard();
        }

        @Override
        KinesisIO.Read.Builder setStreamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setConsumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setInitialPosition(StartingPoint initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setClientConfiguration(ClientConfiguration clientConfiguration) {
            if (clientConfiguration == null) {
                throw new NullPointerException("Null clientConfiguration");
            }
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setUpToDateThreshold(Duration upToDateThreshold) {
            if (upToDateThreshold == null) {
                throw new NullPointerException("Null upToDateThreshold");
            }
            this.upToDateThreshold = upToDateThreshold;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setRequestRecordsLimit(Integer requestRecordsLimit) {
            this.requestRecordsLimit = requestRecordsLimit;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setWatermarkPolicyFactory(WatermarkPolicyFactory watermarkPolicyFactory) {
            if (watermarkPolicyFactory == null) {
                throw new NullPointerException("Null watermarkPolicyFactory");
            }
            this.watermarkPolicyFactory = watermarkPolicyFactory;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setRateLimitPolicyFactory(RateLimitPolicyFactory rateLimitPolicyFactory) {
            if (rateLimitPolicyFactory == null) {
                throw new NullPointerException("Null rateLimitPolicyFactory");
            }
            this.rateLimitPolicyFactory = rateLimitPolicyFactory;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxCapacityPerShard(Integer maxCapacityPerShard) {
            this.maxCapacityPerShard = maxCapacityPerShard;
            return this;
        }

        @Override
        KinesisIO.Read build() {
            if (this.clientConfiguration == null || this.maxNumRecords == null || this.upToDateThreshold == null || this.watermarkPolicyFactory == null || this.rateLimitPolicyFactory == null) {
                StringBuilder missing = new StringBuilder();
                if (this.clientConfiguration == null) {
                    missing.append(" clientConfiguration");
                }
                if (this.maxNumRecords == null) {
                    missing.append(" maxNumRecords");
                }
                if (this.upToDateThreshold == null) {
                    missing.append(" upToDateThreshold");
                }
                if (this.watermarkPolicyFactory == null) {
                    missing.append(" watermarkPolicyFactory");
                }
                if (this.rateLimitPolicyFactory == null) {
                    missing.append(" rateLimitPolicyFactory");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KinesisIO_Read(this.streamName, this.consumerArn, this.initialPosition, this.clientConfiguration, this.maxNumRecords, this.maxReadTime, this.upToDateThreshold, this.requestRecordsLimit, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.maxCapacityPerShard);
        }
    }
}

