/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.ToolType;
import java.util.Objects;

public class ToolCall {
    private final String id;
    private final Integer index;
    private final ToolType type;
    private final FunctionCall function;

    private ToolCall(Builder builder) {
        this.id = builder.id;
        this.index = builder.index;
        this.type = builder.type;
        this.function = builder.function;
    }

    public String id() {
        return this.id;
    }

    public Integer index() {
        return this.index;
    }

    public ToolType type() {
        return this.type;
    }

    public FunctionCall function() {
        return this.function;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ToolCall && this.equalTo((ToolCall)another);
    }

    private boolean equalTo(ToolCall another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.index, another.index) && Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.function, another.function);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.function);
        return h;
    }

    public String toString() {
        return "ToolCall{id=" + this.id + ", index=" + this.index + ", type=" + (Object)((Object)this.type) + ", function=" + this.function + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer index;
        private ToolType type;
        private FunctionCall function;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public Builder type(ToolType type) {
            this.type = type;
            return this;
        }

        public Builder function(FunctionCall function) {
            this.function = function;
            return this;
        }

        public ToolCall build() {
            return new ToolCall(this);
        }
    }
}

