/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.AppendFormats;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.AutoValue_ConnectionWorkerPool_Settings;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.opentelemetry.api.common.Attributes;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class ConnectionWorkerPool {
    static final Pattern STREAM_NAME_PATTERN = Pattern.compile("projects/([^/]+)/datasets/([^/]+)/tables/([^/]+)/streams/([^/]+)");
    private static final Logger log = Logger.getLogger(ConnectionWorkerPool.class.getName());
    private final long maxInflightRequests;
    private final long maxInflightBytes;
    private final Duration maxRetryDuration;
    private RetrySettings retrySettings;
    private final FlowController.LimitExceededBehavior limitExceededBehavior;
    private final Map<StreamWriter, ConnectionWorker> streamWriterToConnection = new HashMap<StreamWriter, ConnectionWorker>();
    private final Map<ConnectionWorker, Set<StreamWriter>> connectionToWriteStream = new HashMap<ConnectionWorker, Set<StreamWriter>>();
    private final Set<ConnectionWorker> connectionWorkerPool = Collections.synchronizedSet(new HashSet());
    private Map<String, ConnectionWorker.TableSchemaAndTimestamp> tableNameToUpdatedSchema = new ConcurrentHashMap<String, ConnectionWorker.TableSchemaAndTimestamp>();
    private static boolean enableTesting = false;
    private String compressorName;
    private final AtomicInteger testValueCreateConnectionCount = new AtomicInteger(0);
    @GuardedBy(value="lock")
    private long inflightRequests = 0L;
    @GuardedBy(value="lock")
    private long inflightBytes = 0L;
    @GuardedBy(value="lock")
    private long conectionRetryCountWithoutCallback = 0L;
    @GuardedBy(value="lock")
    private boolean streamConnectionIsConnected = false;
    @GuardedBy(value="lock")
    private boolean inflightCleanuped = false;
    @GuardedBy(value="lock")
    private boolean userClosed = false;
    @GuardedBy(value="lock")
    private Throwable connectionFinalStatus = null;
    @GuardedBy(value="lock")
    private TableSchema updatedSchema;
    private BigQueryWriteSettings clientSettings;
    private int currentMaxConnectionCount;
    private final Lock lock = new ReentrantLock();
    private static Settings settings = Settings.builder().build();
    private final boolean enableRequestProfiler;
    private final boolean enableOpenTelemetry;

    ConnectionWorkerPool(long maxInflightRequests, long maxInflightBytes, Duration maxRetryDuration, FlowController.LimitExceededBehavior limitExceededBehavior, @Nullable String comperssorName, BigQueryWriteSettings clientSettings, RetrySettings retrySettings, boolean enableRequestProfiler, boolean enableOpenTelemetry) {
        this.maxInflightRequests = maxInflightRequests;
        this.maxInflightBytes = maxInflightBytes;
        this.maxRetryDuration = maxRetryDuration;
        this.limitExceededBehavior = limitExceededBehavior;
        this.compressorName = comperssorName;
        this.clientSettings = clientSettings;
        this.currentMaxConnectionCount = settings.minConnectionsPerRegion();
        this.retrySettings = retrySettings;
        this.enableRequestProfiler = enableRequestProfiler;
        this.enableOpenTelemetry = enableOpenTelemetry;
    }

    public static void setOptions(Settings settings) {
        ConnectionWorkerPool.settings = settings;
    }

    ConnectionWorker getConnectionWorker(StreamWriter streamWriter) {
        ConnectionWorker connectionWorker;
        this.lock.lock();
        try {
            connectionWorker = this.streamWriterToConnection.compute(streamWriter, (key, existingStream) -> {
                if (existingStream != null && !existingStream.getLoad().isOverwhelmed() && !existingStream.isConnectionInUnrecoverableState()) {
                    return existingStream;
                }
                if (existingStream != null && existingStream.isConnectionInUnrecoverableState()) {
                    existingStream = null;
                }
                this.clearFinalizedConnectionWorker();
                ConnectionWorker createdOrExistingConnection = null;
                try {
                    createdOrExistingConnection = this.createOrReuseConnectionWorker(streamWriter, (ConnectionWorker)existingStream);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.connectionToWriteStream.computeIfAbsent(createdOrExistingConnection, k -> new HashSet());
                this.connectionToWriteStream.get(createdOrExistingConnection).add(streamWriter);
                return createdOrExistingConnection;
            });
        }
        finally {
            this.lock.unlock();
        }
        return connectionWorker;
    }

    ApiFuture<AppendRowsResponse> append(StreamWriter streamWriter, AppendFormats.AppendRowsData rows, long offset, String uniqueRequestId) {
        ConnectionWorker connectionWorker = this.getConnectionWorker(streamWriter);
        Stopwatch stopwatch = Stopwatch.createStarted();
        ApiFuture<AppendRowsResponse> responseFuture = connectionWorker.append(streamWriter, rows, offset, uniqueRequestId);
        return ApiFutures.transform(responseFuture, response -> {
            if (response.getWriteStream() != "" && response.hasUpdatedSchema()) {
                this.tableNameToUpdatedSchema.put(response.getWriteStream(), ConnectionWorker.TableSchemaAndTimestamp.create(System.nanoTime(), response.getUpdatedSchema()));
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    Attributes getTelemetryAttributes(StreamWriter streamWriter) {
        ConnectionWorker connectionWorker = this.getConnectionWorker(streamWriter);
        return connectionWorker.getTelemetryAttributes();
    }

    private ConnectionWorker createOrReuseConnectionWorker(StreamWriter streamWriter, ConnectionWorker existingConnectionWorker) throws IOException {
        String streamReference = streamWriter.getStreamName();
        if (this.connectionWorkerPool.size() < this.currentMaxConnectionCount) {
            return this.createConnectionWorker(streamWriter.getStreamName(), streamWriter.getLocation(), streamWriter.getWriterSchema(), streamWriter.getFullTraceId());
        }
        ConnectionWorker existingBestConnection = ConnectionWorkerPool.pickBestLoadConnection(enableTesting ? ConnectionWorker.Load.TEST_LOAD_COMPARATOR : ConnectionWorker.Load.LOAD_COMPARATOR, (List<ConnectionWorker>)ImmutableList.copyOf(this.connectionWorkerPool));
        if (!existingBestConnection.getLoad().isOverwhelmed()) {
            return existingBestConnection;
        }
        if (this.currentMaxConnectionCount < settings.maxConnectionsPerRegion()) {
            ++this.currentMaxConnectionCount;
            if (this.currentMaxConnectionCount > settings.maxConnectionsPerRegion()) {
                this.currentMaxConnectionCount = settings.maxConnectionsPerRegion();
            }
            return this.createConnectionWorker(streamWriter.getStreamName(), streamWriter.getLocation(), streamWriter.getWriterSchema(), streamWriter.getFullTraceId());
        }
        if (existingConnectionWorker != null) {
            return existingConnectionWorker;
        }
        return existingBestConnection;
    }

    private void clearFinalizedConnectionWorker() {
        HashSet<ConnectionWorker> connectionWorkerSet = new HashSet<ConnectionWorker>();
        for (ConnectionWorker existingWorker : this.connectionWorkerPool) {
            if (!existingWorker.isConnectionInUnrecoverableState()) continue;
            connectionWorkerSet.add(existingWorker);
        }
        for (ConnectionWorker workerToRemove : connectionWorkerSet) {
            this.connectionWorkerPool.remove(workerToRemove);
        }
    }

    static ConnectionWorker pickBestLoadConnection(Comparator<ConnectionWorker.Load> comparator, List<ConnectionWorker> connectionWorkerList) {
        if (connectionWorkerList.isEmpty()) {
            throw new IllegalStateException(String.format("Bug in code! At least one connection worker should be passed in pickSemiBestLoadConnection(...)", new Object[0]));
        }
        int currentBestIndex = 0;
        ConnectionWorker.Load currentBestLoad = connectionWorkerList.get(currentBestIndex).getLoad();
        for (int i = 1; i < connectionWorkerList.size(); ++i) {
            ConnectionWorker.Load loadToCompare = connectionWorkerList.get(i).getLoad();
            if (comparator.compare(loadToCompare, currentBestLoad) > 0) continue;
            currentBestIndex = i;
            currentBestLoad = loadToCompare;
        }
        return connectionWorkerList.get(currentBestIndex);
    }

    private ConnectionWorker createConnectionWorker(String streamName, String location, AppendFormats.AppendRowsSchema writeSchema, String fullTraceId) throws IOException {
        if (enableTesting) {
            this.testValueCreateConnectionCount.getAndIncrement();
        }
        ConnectionWorker connectionWorker = new ConnectionWorker(streamName, location, writeSchema, this.maxInflightRequests, this.maxInflightBytes, this.maxRetryDuration, this.limitExceededBehavior, fullTraceId, this.compressorName, this.clientSettings, this.retrySettings, this.enableRequestProfiler, this.enableOpenTelemetry, true);
        this.connectionWorkerPool.add(connectionWorker);
        log.info(String.format("Scaling up new connection for stream name: %s, pool size after scaling up %d", streamName, this.connectionWorkerPool.size()));
        return connectionWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(StreamWriter streamWriter) {
        this.lock.lock();
        try {
            this.streamWriterToConnection.remove(streamWriter);
            HashSet<ConnectionWorker> connectionToRemove = new HashSet<ConnectionWorker>();
            for (ConnectionWorker connectionWorker : this.connectionToWriteStream.keySet()) {
                if (!this.connectionToWriteStream.containsKey(connectionWorker)) continue;
                this.connectionToWriteStream.get(connectionWorker).remove(streamWriter);
                if (!this.connectionToWriteStream.get(connectionWorker).isEmpty()) continue;
                connectionWorker.close();
                this.connectionWorkerPool.remove(connectionWorker);
                connectionToRemove.add(connectionWorker);
            }
            log.info(String.format("During closing of writeStream for %s with writer id %s, we decided to close %s connections, pool size after removal $s", streamWriter.getStreamName(), streamWriter.getWriterId(), connectionToRemove.size(), this.connectionToWriteStream.size() - 1));
            this.connectionToWriteStream.keySet().removeAll(connectionToRemove);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getInflightWaitSeconds(StreamWriter streamWriter) {
        this.lock.lock();
        try {
            ConnectionWorker connectionWorker = this.streamWriterToConnection.get(streamWriter);
            if (connectionWorker == null) {
                long l = 0L;
                return l;
            }
            long l = connectionWorker.getInflightWaitSeconds();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    ConnectionWorker.TableSchemaAndTimestamp getUpdatedSchema(StreamWriter streamWriter) {
        return this.tableNameToUpdatedSchema.getOrDefault(streamWriter.getStreamName(), null);
    }

    @VisibleForTesting
    static void enableTestingLogic() {
        enableTesting = true;
    }

    int getCreateConnectionCount() {
        return this.testValueCreateConnectionCount.get();
    }

    int getTotalConnectionCount() {
        return this.connectionWorkerPool.size();
    }

    FlowController.LimitExceededBehavior limitExceededBehavior() {
        return this.limitExceededBehavior;
    }

    BigQueryWriteSettings bigQueryWriteSettings() {
        return this.clientSettings;
    }

    static String toTableName(String streamName) {
        Matcher matcher = STREAM_NAME_PATTERN.matcher(streamName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid stream name: %s.", (Object)streamName);
        return "projects/" + matcher.group(1) + "/datasets/" + matcher.group(2) + "/tables/" + matcher.group(3);
    }

    @AutoValue
    public static abstract class Settings {
        abstract int minConnectionsPerRegion();

        abstract int maxConnectionsPerRegion();

        public static Builder builder() {
            return new AutoValue_ConnectionWorkerPool_Settings.Builder().setMinConnectionsPerRegion(2).setMaxConnectionsPerRegion(20);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setMinConnectionsPerRegion(int var1);

            public abstract Builder setMaxConnectionsPerRegion(int var1);

            public abstract Settings build();
        }
    }
}

