/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.threeten.bp.Duration;

public class UpdateTableRequest {
    private final String tableId;
    private final UpdateTableRequest.Builder requestBuilder = com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder();
    private final Table.AutomatedBackupPolicy.Builder automatedPolicyBuilder = Table.AutomatedBackupPolicy.newBuilder();

    public static UpdateTableRequest of(String tableId) {
        return new UpdateTableRequest(tableId);
    }

    private UpdateTableRequest(String tableId) {
        this.tableId = tableId;
    }

    public UpdateTableRequest addChangeStreamRetention(Duration retention) {
        Preconditions.checkNotNull((Object)retention);
        if (!retention.isZero()) {
            this.requestBuilder.getTableBuilder().setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(retention.getSeconds()).setNanos(retention.getNano()).build()).build());
            this.requestBuilder.getUpdateMaskBuilder().addPaths("change_stream_config.retention_period");
        } else {
            this.requestBuilder.getTableBuilder().clearChangeStreamConfig();
            this.requestBuilder.getUpdateMaskBuilder().addPaths("change_stream_config");
        }
        return this;
    }

    public UpdateTableRequest disableChangeStreamRetention() {
        return this.addChangeStreamRetention(Duration.ZERO);
    }

    public UpdateTableRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getTableBuilder().setDeletionProtection(deletionProtection);
        this.requestBuilder.getUpdateMaskBuilder().addPaths("deletion_protection");
        return this;
    }

    public UpdateTableRequest disableAutomatedBackup() {
        this.requestBuilder.getTableBuilder().setAutomatedBackupPolicy(this.automatedPolicyBuilder.build());
        this.requestBuilder.getUpdateMaskBuilder().addPaths("automated_backup_policy");
        return this;
    }

    public UpdateTableRequest setAutomatedBackup(Duration retentionPeriod, Duration frequency) {
        Table.AutomatedBackupPolicy policy = Table.AutomatedBackupPolicy.newBuilder().setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(retentionPeriod.getSeconds()).setNanos(retentionPeriod.getNano()).build()).setFrequency(com.google.protobuf.Duration.newBuilder().setSeconds(frequency.getSeconds()).setNanos(frequency.getNano()).build()).build();
        this.requestBuilder.getTableBuilder().setAutomatedBackupPolicy(policy);
        this.requestBuilder.getUpdateMaskBuilder().addPaths("automated_backup_policy");
        return this;
    }

    public UpdateTableRequest setAutomatedBackupRetentionPeriod(Duration retention) {
        this.requestBuilder.getTableBuilder().setAutomatedBackupPolicy(this.automatedPolicyBuilder.setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(retention.getSeconds()).setNanos(retention.getNano()).build()).build());
        this.requestBuilder.getUpdateMaskBuilder().addPaths("automated_backup_policy.retention_period");
        return this;
    }

    public UpdateTableRequest setAutomatedBackupFrequency(Duration frequency) {
        this.requestBuilder.getTableBuilder().setAutomatedBackupPolicy(this.automatedPolicyBuilder.setFrequency(com.google.protobuf.Duration.newBuilder().setSeconds(frequency.getSeconds()).setNanos(frequency.getNano()).build()).build());
        this.requestBuilder.getUpdateMaskBuilder().addPaths("automated_backup_policy.frequency");
        return this;
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateTableRequest toProto(String projectId, String instanceId) {
        this.requestBuilder.getTableBuilder().setName(NameUtil.formatTableName(projectId, instanceId, this.tableId));
        return this.requestBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest that = (UpdateTableRequest)o;
        return Objects.equals(this.requestBuilder, that.requestBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.requestBuilder);
    }
}

