/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ConditionalRowMutation
implements Serializable {
    private static final long serialVersionUID = -3699904745621909502L;
    private final TargetId targetId;
    private transient CheckAndMutateRowRequest.Builder builder = CheckAndMutateRowRequest.newBuilder();

    private ConditionalRowMutation(TargetId targetId, ByteString rowKey) {
        Preconditions.checkNotNull((Object)targetId, (Object)"target id can't be null.");
        this.targetId = targetId;
        this.builder.setRowKey(rowKey);
    }

    @Deprecated
    public static ConditionalRowMutation create(String tableId, String rowKey) {
        return ConditionalRowMutation.create(tableId, ByteString.copyFromUtf8((String)rowKey));
    }

    public static ConditionalRowMutation create(TargetId targetId, String rowKey) {
        return ConditionalRowMutation.create(targetId, ByteString.copyFromUtf8((String)rowKey));
    }

    @Deprecated
    public static ConditionalRowMutation create(String tableId, ByteString rowKey) {
        Validations.validateTableId(tableId);
        return new ConditionalRowMutation(TableId.of(tableId), rowKey);
    }

    public static ConditionalRowMutation create(TargetId targetId, ByteString rowKey) {
        return new ConditionalRowMutation(targetId, rowKey);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (CheckAndMutateRowRequest.Builder)CheckAndMutateRowRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public ConditionalRowMutation condition(@Nonnull Filters.Filter condition) {
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkState((!this.builder.hasPredicateFilter() ? 1 : 0) != 0, (Object)"Can only have a single condition, please use a Filters#chain or Filters#interleave filter instead");
        this.builder.setPredicateFilter(condition.toProto());
        return this;
    }

    public ConditionalRowMutation then(@Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)mutation);
        this.builder.addAllTrueMutations(mutation.getMutations());
        return this;
    }

    public ConditionalRowMutation otherwise(@Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)mutation);
        this.builder.addAllFalseMutations(mutation.getMutations());
        return this;
    }

    @InternalApi
    public CheckAndMutateRowRequest toProto(RequestContext requestContext) {
        Preconditions.checkState((!this.builder.getTrueMutationsList().isEmpty() || !this.builder.getFalseMutationsList().isEmpty() ? 1 : 0) != 0, (Object)"ConditionalRowMutations must have `then` or `otherwise` mutations.");
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForAuthorizedView()) {
            this.builder.setAuthorizedViewName(resourceName);
        } else {
            this.builder.setTableName(resourceName);
        }
        return this.builder.setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @BetaApi
    public static ConditionalRowMutation fromProto(@Nonnull CheckAndMutateRowRequest request) {
        String tableName = request.getTableName();
        String authorizedViewName = request.getAuthorizedViewName();
        ConditionalRowMutation rowMutation = ConditionalRowMutation.create(NameUtil.extractTargetId(tableName, authorizedViewName), request.getRowKey());
        rowMutation.builder = request.toBuilder();
        return rowMutation;
    }
}

