/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;

@InternalApi(value="For internal use only")
public class MetadataErrorHandlingCallable
extends ServerStreamingCallable<ExecuteQueryCallContext, SqlRow> {
    private final ServerStreamingCallable<ExecuteQueryCallContext, SqlRow> inner;

    public MetadataErrorHandlingCallable(ServerStreamingCallable<ExecuteQueryCallContext, SqlRow> inner) {
        this.inner = inner;
    }

    public void call(ExecuteQueryCallContext request, ResponseObserver<SqlRow> responseObserver, ApiCallContext context) {
        MetadataErrorHandlingObserver observer = new MetadataErrorHandlingObserver(responseObserver, request);
        this.inner.call((Object)request, (ResponseObserver)observer, context);
    }

    static final class MetadataErrorHandlingObserver
    extends SafeResponseObserver<SqlRow> {
        private final ExecuteQueryCallContext callContext;
        private final ResponseObserver<SqlRow> outerObserver;

        MetadataErrorHandlingObserver(ResponseObserver<SqlRow> outerObserver, ExecuteQueryCallContext callContext) {
            super(outerObserver);
            this.outerObserver = outerObserver;
            this.callContext = callContext;
        }

        @Override
        protected void onStartImpl(StreamController streamController) {
            this.outerObserver.onStart(streamController);
        }

        @Override
        protected void onResponseImpl(SqlRow response) {
            this.outerObserver.onResponse((Object)response);
        }

        @Override
        protected void onErrorImpl(Throwable throwable) {
            this.callContext.setMetadataException(throwable);
            this.outerObserver.onError(throwable);
        }

        @Override
        protected void onCompleteImpl() {
            this.outerObserver.onComplete();
        }
    }
}

