/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SnappyCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.AutoValue_Watch_Growth;
import org.apache.beam.sdk.transforms.AutoValue_Watch_NonPollingGrowthState;
import org.apache.beam.sdk.transforms.AutoValue_Watch_PollingGrowthState;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Funnel;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Funnels;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.PrimitiveSink;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watch {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(Watch.class);

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, OutputT> growthOf(@UnknownKeyFor @NonNull @Initialized Growth.PollFn<InputT, OutputT> pollFn, @UnknownKeyFor @NonNull @Initialized Requirements requirements) {
        return new AutoValue_Watch_Growth.Builder().setTerminationPerInput(Growth.never()).setPollFn(Contextful.of(pollFn, requirements)).setOutputKeyFn(null).build();
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, OutputT> growthOf(@UnknownKeyFor @NonNull @Initialized Growth.PollFn<InputT, OutputT> pollFn) {
        return Watch.growthOf(pollFn, Requirements.empty());
    }

    public static <InputT, OutputT, KeyT> @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> growthOf(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Growth.PollFn<InputT, OutputT>> pollFn, @UnknownKeyFor @NonNull @Initialized SerializableFunction<OutputT, KeyT> outputKeyFn) {
        Preconditions.checkArgument((pollFn != null ? 1 : 0) != 0, (Object)"pollFn can not be null");
        Preconditions.checkArgument((outputKeyFn != null ? 1 : 0) != 0, (Object)"outputKeyFn can not be null");
        return new AutoValue_Watch_Growth.Builder().setTerminationPerInput(Growth.never()).setPollFn(pollFn).setOutputKeyFn(outputKeyFn).build();
    }

    static class GrowthStateCoder<@UnknownKeyFor OutputT, @UnknownKeyFor TerminationStateT>
    extends StructuredCoder<GrowthState> {
        private static final @UnknownKeyFor @NonNull @Initialized int POLLING_GROWTH_STATE = 0;
        private static final @UnknownKeyFor @NonNull @Initialized int NON_POLLING_GROWTH_STATE = 1;
        private static final @UnknownKeyFor @NonNull @Initialized MapCoder<@UnknownKeyFor @NonNull @Initialized HashCode, @UnknownKeyFor @NonNull @Initialized Instant> COMPLETED_CODER = MapCoder.of(HashCode128Coder.of(), InstantCoder.of());
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Instant> NULLABLE_INSTANT_CODER = NullableCoder.of(InstantCoder.of());
        private final @UnknownKeyFor @NonNull @Initialized Coder<OutputT> outputCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>>> timestampedOutputCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<TerminationStateT> terminationStateCoder;

        public static <OutputT, TerminationStateT> @UnknownKeyFor @NonNull @Initialized GrowthStateCoder<OutputT, TerminationStateT> of(@UnknownKeyFor @NonNull @Initialized Coder<OutputT> outputCoder, @UnknownKeyFor @NonNull @Initialized Coder<TerminationStateT> terminationStateCoder) {
            return new GrowthStateCoder<OutputT, TerminationStateT>(outputCoder, terminationStateCoder);
        }

        private GrowthStateCoder(@UnknownKeyFor @NonNull @Initialized Coder<OutputT> outputCoder, @UnknownKeyFor @NonNull @Initialized Coder<TerminationStateT> terminationStateCoder) {
            this.outputCoder = outputCoder;
            this.terminationStateCoder = terminationStateCoder;
            this.timestampedOutputCoder = ListCoder.of(TimestampedValue.TimestampedValueCoder.of(outputCoder));
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized GrowthState value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (value instanceof PollingGrowthState) {
                VarInt.encode(0, os);
                this.encodePollingGrowthState((PollingGrowthState)value, os);
            } else if (value instanceof NonPollingGrowthState) {
                VarInt.encode(1, os);
                this.encodeNonPollingGrowthState((NonPollingGrowthState)value, os);
            } else {
                throw new IOException("Unknown growth state: " + value);
            }
        }

        private void encodePollingGrowthState(@UnknownKeyFor @NonNull @Initialized PollingGrowthState<TerminationStateT> value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.terminationStateCoder.encode(value.getTerminationState(), os);
            NULLABLE_INSTANT_CODER.encode(value.getPollWatermark(), os);
            COMPLETED_CODER.encode((Map<HashCode, Instant>)value.getCompleted(), os);
        }

        private void encodeNonPollingGrowthState(@UnknownKeyFor @NonNull @Initialized NonPollingGrowthState<OutputT> value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
            NULLABLE_INSTANT_CODER.encode(value.getPending().getWatermark(), os);
            this.timestampedOutputCoder.encode(value.getPending().getOutputs(), os);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GrowthState decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
            int type = VarInt.decodeInt(is);
            switch (type) {
                case 1: {
                    return this.decodeNonPollingGrowthState(is);
                }
                case 0: {
                    return this.decodePollingGrowthState(is);
                }
            }
            throw new IOException("Unknown growth state type " + type);
        }

        private @UnknownKeyFor @NonNull @Initialized GrowthState decodeNonPollingGrowthState(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Instant watermark = NULLABLE_INSTANT_CODER.decode(is);
            List<TimestampedValue<OutputT>> values = this.timestampedOutputCoder.decode(is);
            return NonPollingGrowthState.of(new Growth.PollResult(values, watermark));
        }

        private @UnknownKeyFor @NonNull @Initialized GrowthState decodePollingGrowthState(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
            TerminationStateT terminationState = this.terminationStateCoder.decode(is);
            Instant watermark = NULLABLE_INSTANT_CODER.decode(is);
            Object completed = COMPLETED_CODER.decode(is);
            return PollingGrowthState.of((ImmutableMap<HashCode, Instant>)ImmutableMap.copyOf((Map)completed), watermark, terminationState);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.outputCoder, this.terminationStateCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.outputCoder.verifyDeterministic();
        }
    }

    private static class HashCode128Coder
    extends AtomicCoder<HashCode> {
        private static final @UnknownKeyFor @NonNull @Initialized HashCode128Coder INSTANCE = new HashCode128Coder();

        private HashCode128Coder() {
        }

        public static @UnknownKeyFor @NonNull @Initialized HashCode128Coder of() {
            return INSTANCE;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized HashCode value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkArgument((value.bits() == 128 ? 1 : 0) != 0, (String)"Expected a 128-bit hash code, but got %s bits", (int)value.bits());
            byte[] res = new byte[16];
            value.writeBytesTo(res, 0, 16);
            os.write(res);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized HashCode decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte[] res = new byte[16];
            int numRead = is.read(res, 0, 16);
            Preconditions.checkArgument((numRead == 16 ? 1 : 0) != 0, (String)"Expected to read 16 bytes, but read %s", (int)numRead);
            return HashCode.fromBytes((byte[])res);
        }
    }

    @VisibleForTesting
    static class GrowthTracker<@UnknownKeyFor OutputT, @UnknownKeyFor TerminationStateT>
    extends RestrictionTracker<GrowthState, KV<Growth.PollResult<OutputT>, TerminationStateT>> {
        static final @UnknownKeyFor @NonNull @Initialized GrowthState EMPTY_STATE = NonPollingGrowthState.of(new Growth.PollResult(Collections.emptyList(), null));
        private final @UnknownKeyFor @NonNull @Initialized Funnel<OutputT> coderFunnel;
        private @Nullable @UnknownKeyFor @Initialized Growth.PollResult<OutputT> claimedPollResult;
        private @Nullable TerminationStateT claimedTerminationState;
        private @Nullable @UnknownKeyFor @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized HashCode, @UnknownKeyFor @NonNull @Initialized Instant> claimedHashes;
        private @UnknownKeyFor @NonNull @Initialized GrowthState state;
        private @UnknownKeyFor @NonNull @Initialized boolean shouldStop;

        GrowthTracker(@UnknownKeyFor @NonNull @Initialized GrowthState state, @UnknownKeyFor @NonNull @Initialized Funnel<OutputT> coderFunnel) {
            this.state = state;
            this.coderFunnel = coderFunnel;
            this.shouldStop = false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GrowthState currentRestriction() {
            return this.state;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized GrowthState> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            PollingGrowthState<TerminationStateT> residual;
            if (this.claimedPollResult == null) {
                residual = this.state;
                this.state = EMPTY_STATE;
            } else if (this.state instanceof NonPollingGrowthState) {
                residual = EMPTY_STATE;
            } else {
                PollingGrowthState currentState = (PollingGrowthState)this.state;
                ImmutableMap.Builder newCompleted = ImmutableMap.builder();
                newCompleted.putAll(currentState.getCompleted());
                newCompleted.putAll(this.claimedHashes);
                residual = PollingGrowthState.of((ImmutableMap<HashCode, Instant>)newCompleted.build(), (Instant)Ordering.natural().nullsFirst().max((Object)currentState.getPollWatermark(), (Object)((Growth.PollResult)this.claimedPollResult).watermark), this.claimedTerminationState);
                this.state = NonPollingGrowthState.of(this.claimedPollResult);
            }
            this.shouldStop = true;
            return SplitResult.of(this.state, residual);
        }

        private @UnknownKeyFor @NonNull @Initialized HashCode hash128(OutputT value) {
            return Hashing.murmur3_128().hashObject(value, this.coderFunnel);
        }

        @Override
        public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            Preconditions.checkState((boolean)this.shouldStop, (Object)"Missing tryClaim()/checkpoint() call. Expected one or the other.");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
            if (this.state == EMPTY_STATE || this.state instanceof NonPollingGrowthState) {
                return RestrictionTracker.IsBounded.BOUNDED;
            }
            return RestrictionTracker.IsBounded.UNBOUNDED;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Growth.PollResult<OutputT>, TerminationStateT> pollResult) {
            if (this.shouldStop) {
                return false;
            }
            ImmutableMap.Builder newClaimedHashesBuilder = ImmutableMap.builder();
            for (TimestampedValue<OutputT> value : pollResult.getKey().getOutputs()) {
                HashCode hash = this.hash128(value.getValue());
                newClaimedHashesBuilder.put((Object)hash, (Object)value.getTimestamp());
            }
            ImmutableMap newClaimedHashes = newClaimedHashesBuilder.build();
            if (this.state instanceof PollingGrowthState) {
                if (!Collections.disjoint(newClaimedHashes.keySet(), ((PollingGrowthState)this.state).getCompleted().keySet())) {
                    return false;
                }
            } else {
                HashSet<HashCode> expectedHashesToClaim = new HashSet<HashCode>();
                for (TimestampedValue value : ((NonPollingGrowthState)this.state).getPending().getOutputs()) {
                    expectedHashesToClaim.add(this.hash128(value.getValue()));
                }
                if (!expectedHashesToClaim.equals(newClaimedHashes.keySet())) {
                    return false;
                }
            }
            this.shouldStop = true;
            this.claimedPollResult = pollResult.getKey();
            this.claimedTerminationState = pollResult.getValue();
            this.claimedHashes = newClaimedHashes;
            return true;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("pollResult", this.claimedPollResult).add("terminationState", this.claimedTerminationState).add("shouldStop", this.shouldStop).toString();
        }
    }

    @AutoValue
    @VisibleForTesting
    static abstract class PollingGrowthState<@UnknownKeyFor TerminationStateT>
    extends GrowthState {
        PollingGrowthState() {
        }

        public static <TerminationStateT> @UnknownKeyFor @NonNull @Initialized PollingGrowthState<TerminationStateT> of(TerminationStateT terminationState) {
            return new AutoValue_Watch_PollingGrowthState<TerminationStateT>((ImmutableMap<HashCode, Instant>)ImmutableMap.of(), null, terminationState);
        }

        public static <TerminationStateT> @UnknownKeyFor @NonNull @Initialized PollingGrowthState<TerminationStateT> of(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized HashCode, @UnknownKeyFor @NonNull @Initialized Instant> completed, @UnknownKeyFor @NonNull @Initialized Instant pollWatermark, TerminationStateT terminationState) {
            return new AutoValue_Watch_PollingGrowthState<TerminationStateT>(completed, pollWatermark, terminationState);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized HashCode, @UnknownKeyFor @NonNull @Initialized Instant> getCompleted();

        public abstract @Nullable @UnknownKeyFor @Initialized Instant getPollWatermark();

        public abstract TerminationStateT getTerminationState();
    }

    @AutoValue
    @VisibleForTesting
    static abstract class NonPollingGrowthState<@UnknownKeyFor OutputT>
    extends GrowthState {
        NonPollingGrowthState() {
        }

        public static <OutputT> @UnknownKeyFor @NonNull @Initialized NonPollingGrowthState<OutputT> of(@UnknownKeyFor @NonNull @Initialized Growth.PollResult<OutputT> pending) {
            return new AutoValue_Watch_NonPollingGrowthState<OutputT>(pending);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Growth.PollResult<OutputT> getPending();
    }

    static abstract class GrowthState {
        GrowthState() {
        }
    }

    @DoFn.UnboundedPerElement
    @VisibleForTesting
    protected static class WatchGrowthFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor KeyT, @UnknownKeyFor TerminationStateT>
    extends DoFn<InputT, KV<InputT, List<TimestampedValue<OutputT>>>> {
        private final @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> spec;
        private final @UnknownKeyFor @NonNull @Initialized Coder<OutputT> outputCoder;
        private final @UnknownKeyFor @NonNull @Initialized Funnel<OutputT> coderFunnel;

        WatchGrowthFn(@UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> spec, @UnknownKeyFor @NonNull @Initialized Coder<OutputT> outputCoder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<OutputT, KeyT> outputKeyFn, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> outputKeyCoder) {
            this.spec = spec;
            this.outputCoder = outputCoder;
            this.coderFunnel = (Funnel & Serializable)(from, into) -> {
                try {
                    Object outputKey = outputKeyFn.apply(from);
                    outputKeyCoder.encode(outputKey, Funnels.asOutputStream((PrimitiveSink)into));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant currentElementTimestamp) {
            return currentElementTimestamp;
        }

        @DoFn.NewWatermarkEstimator
        public  @UnknownKeyFor @NonNull @Initialized WatermarkEstimators.Manual newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant watermarkEstimatorState) {
            return new WatermarkEstimators.Manual(watermarkEstimatorState);
        }

        @DoFn.ProcessElement
        public @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized GrowthState, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Growth.PollResult<OutputT>, TerminationStateT>> tracker, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) throws @UnknownKeyFor @NonNull @Initialized Exception {
            GrowthState currentRestriction = tracker.currentRestriction();
            if (currentRestriction instanceof NonPollingGrowthState) {
                Growth.PollResult priorPoll = ((NonPollingGrowthState)currentRestriction).getPending();
                if (tracker.tryClaim(KV.of(priorPoll, null)) && !priorPoll.getOutputs().isEmpty()) {
                    LOG.info("{} - re-emitting output of prior poll containing {} results.", c.element(), (Object)priorPoll.getOutputs().size());
                    c.output(KV.of(c.element(), priorPoll.getOutputs()));
                }
                return DoFn.ProcessContinuation.stop();
            }
            Instant now = Instant.now();
            Growth.PollResult res = (Growth.PollResult)this.spec.getPollFn().getClosure().apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c));
            PollingGrowthState pollingRestriction = (PollingGrowthState)currentRestriction;
            Growth.PollResult<OutputT> newResults = this.computeNeverSeenBeforeResults(pollingRestriction, res);
            LOG.info("{} - current round of polling took {} ms and returned {} results, of which {} were new.", new Object[]{c.element(), new Duration((ReadableInstant)now, (ReadableInstant)Instant.now()).getMillis(), res.getOutputs().size(), newResults.getOutputs().size()});
            Object terminationState = pollingRestriction.getTerminationState();
            if (!newResults.getOutputs().isEmpty()) {
                terminationState = this.getTerminationCondition().onSeenNewOutput(Instant.now(), terminationState);
            }
            if (!tracker.tryClaim(KV.of(newResults, terminationState = this.getTerminationCondition().onPollComplete(terminationState)))) {
                LOG.info("{} - will not emit poll result tryClaim failed.", c.element());
                return DoFn.ProcessContinuation.stop();
            }
            if (!newResults.getOutputs().isEmpty()) {
                c.output(KV.of(c.element(), newResults.getOutputs()));
            }
            Instant computedWatermark = null;
            if (newResults.getWatermark() != null) {
                computedWatermark = newResults.getWatermark();
            } else if (!newResults.getOutputs().isEmpty()) {
                computedWatermark = newResults.getOutputs().get(0).getTimestamp();
            }
            Instant currentTime = Instant.now();
            if (this.getTerminationCondition().canStopPolling(currentTime, terminationState)) {
                LOG.info("{} - told to stop polling by polling function at {} with termination state {}.", new Object[]{c.element(), currentTime, this.getTerminationCondition().toString(terminationState)});
                return DoFn.ProcessContinuation.stop();
            }
            if (BoundedWindow.TIMESTAMP_MAX_VALUE.equals((Object)computedWatermark)) {
                LOG.info("{} - will stop polling, reached max timestamp.", c.element());
                return DoFn.ProcessContinuation.stop();
            }
            if (computedWatermark != null) {
                watermarkEstimator.setWatermark(computedWatermark);
            }
            LOG.info("{} - will resume polling in {} ms.", c.element(), (Object)this.spec.getPollInterval().getMillis());
            return DoFn.ProcessContinuation.resume().withResumeDelay(this.spec.getPollInterval());
        }

        private @UnknownKeyFor @NonNull @Initialized HashCode hash128(OutputT value) {
            return Hashing.murmur3_128().hashObject(value, this.coderFunnel);
        }

        private @UnknownKeyFor @NonNull @Initialized Growth.PollResult<OutputT> computeNeverSeenBeforeResults(@UnknownKeyFor @NonNull @Initialized PollingGrowthState<TerminationStateT> state, @UnknownKeyFor @NonNull @Initialized Growth.PollResult<OutputT> pollResult) {
            HashMap newPending = Maps.newHashMap();
            for (TimestampedValue<OutputT> output : pollResult.getOutputs()) {
                OutputT value2 = output.getValue();
                HashCode hash = this.hash128(value2);
                if (state.getCompleted().containsKey((Object)hash) || newPending.containsKey(hash)) continue;
                newPending.put(hash, output);
            }
            return pollResult.withOutputs(Ordering.natural().onResultOf(value -> value.getTimestamp()).sortedCopy(newPending.values()));
        }

        private @UnknownKeyFor @NonNull @Initialized Growth.TerminationCondition<InputT, TerminationStateT> getTerminationCondition() {
            return this.spec.getTerminationPerInput();
        }

        @DoFn.GetInitialRestriction
        public @UnknownKeyFor @NonNull @Initialized GrowthState getInitialRestriction(@DoFn.Element InputT element) {
            return PollingGrowthState.of(this.getTerminationCondition().forNewInput(Instant.now(), element));
        }

        @DoFn.NewTracker
        public @UnknownKeyFor @NonNull @Initialized GrowthTracker<OutputT, TerminationStateT> newTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized GrowthState restriction) {
            return new GrowthTracker(restriction, this.coderFunnel);
        }

        @DoFn.GetRestrictionCoder
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized GrowthState> getRestrictionCoder() {
            return SnappyCoder.of(GrowthStateCoder.of(this.outputCoder, this.spec.getTerminationPerInput().getStateCoder()));
        }
    }

    @DoFn.BoundedPerElement
    private static class PollResultSplitFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends DoFn<KV<InputT, List<TimestampedValue<OutputT>>>, KV<InputT, OutputT>> {
        private PollResultSplitFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker) {
            long position = tracker.currentRestriction().getFrom();
            while (tracker.tryClaim(position)) {
                TimestampedValue value = (TimestampedValue)((List)((KV)c.element()).getValue()).get((int)position);
                c.outputWithTimestamp(KV.of(((KV)c.element()).getKey(), value.getValue()), value.getTimestamp());
                ++position;
            }
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant currentElementTimestamp) {
            return currentElementTimestamp;
        }

        @DoFn.NewWatermarkEstimator
        public  @UnknownKeyFor @NonNull @Initialized WatermarkEstimators.MonotonicallyIncreasing newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant watermarkEstimatorState) {
            return new WatermarkEstimators.MonotonicallyIncreasing(watermarkEstimatorState);
        }

        @DoFn.GetInitialRestriction
        public @UnknownKeyFor @NonNull @Initialized OffsetRange getInitialRestriction(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<InputT, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>>> element) {
            return new OffsetRange(0L, element.getValue().size());
        }

        @DoFn.NewTracker
        public @UnknownKeyFor @NonNull @Initialized OffsetRangeTracker newTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange restriction) {
            return restriction.newTracker();
        }

        @DoFn.GetRestrictionCoder
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized OffsetRange> getRestrictionCoder() {
            return OffsetRange.Coder.of();
        }
    }

    @AutoValue
    public static abstract class Growth<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor KeyT>
    extends PTransform<PCollection<InputT>, PCollection<KV<InputT, OutputT>>> {
        public static <InputT> @UnknownKeyFor @NonNull @Initialized Never<InputT> never() {
            return new Never();
        }

        public static <InputT, StateT> @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, StateT> ignoreInput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TerminationCondition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, StateT> condition) {
            return new IgnoreInput(condition);
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized AfterTotalOf<InputT> afterTotalOf(@UnknownKeyFor @NonNull @Initialized ReadableDuration timeSinceInput) {
            return Growth.afterTotalOf(SerializableFunctions.constant(timeSinceInput));
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized AfterTotalOf<InputT> afterTotalOf(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized ReadableDuration> timeSinceInput) {
            return new AfterTotalOf(timeSinceInput);
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized AfterTimeSinceNewOutput<InputT> afterTimeSinceNewOutput(@UnknownKeyFor @NonNull @Initialized ReadableDuration timeSinceNewOutput) {
            return Growth.afterTimeSinceNewOutput(SerializableFunctions.constant(timeSinceNewOutput));
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized AfterTimeSinceNewOutput<InputT> afterTimeSinceNewOutput(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized ReadableDuration> timeSinceNewOutput) {
            return new AfterTimeSinceNewOutput(timeSinceNewOutput);
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized AfterIterations<InputT> afterIterations(@UnknownKeyFor @NonNull @Initialized int iterations) {
            return new AfterIterations(iterations);
        }

        public static <InputT, FirstStateT, SecondStateT> @UnknownKeyFor @NonNull @Initialized BinaryCombined<InputT, FirstStateT, SecondStateT> eitherOf(@UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, FirstStateT> first, @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, SecondStateT> second) {
            return new BinaryCombined<InputT, FirstStateT, SecondStateT>(BinaryCombined.Operation.OR, first, second);
        }

        public static <InputT, FirstStateT, SecondStateT> @UnknownKeyFor @NonNull @Initialized BinaryCombined<InputT, FirstStateT, SecondStateT> allOf(@UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, FirstStateT> first, @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, SecondStateT> second) {
            return new BinaryCombined<InputT, FirstStateT, SecondStateT>(BinaryCombined.Operation.AND, first, second);
        }

        abstract @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized PollFn<InputT, OutputT>> getPollFn();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<OutputT, KeyT> getOutputKeyFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<KeyT> getOutputKeyCoder();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getPollInterval();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized TerminationCondition<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getTerminationPerInput();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<OutputT> getOutputCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> withOutputKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<KeyT> outputKeyCoder) {
            return this.toBuilder().setOutputKeyCoder(outputKeyCoder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> withTerminationPerInput(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationPerInput) {
            return this.toBuilder().setTerminationPerInput(terminationPerInput).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> withPollInterval(@UnknownKeyFor @NonNull @Initialized Duration pollInterval) {
            return this.toBuilder().setPollInterval(pollInterval).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> withOutputCoder(@UnknownKeyFor @NonNull @Initialized Coder<OutputT> outputCoder) {
            return this.toBuilder().setOutputCoder(outputCoder).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<InputT, OutputT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
            Preconditions.checkNotNull((Object)this.getPollInterval(), (Object)"pollInterval");
            Preconditions.checkNotNull(this.getTerminationPerInput(), (Object)"terminationPerInput");
            Coder<Object> outputCoder = this.getOutputCoder();
            if (outputCoder == null) {
                TypeDescriptor outputT = TypeDescriptors.extractFromTypeParameters(this.getPollFn().getClosure(), PollFn.class, new TypeDescriptors.TypeVariableExtractor<PollFn<InputT, OutputT>, OutputT>(){});
                try {
                    outputCoder = input.getPipeline().getCoderRegistry().getCoder(outputT);
                }
                catch (CannotProvideCoderException e) {
                    throw new RuntimeException("Unable to infer coder for OutputT (" + outputT + "). Specify it explicitly using withOutputCoder().");
                }
            }
            Coder<Object> outputKeyCoder = this.getOutputKeyCoder();
            SerializableFunction<Object, Object> outputKeyFn = this.getOutputKeyFn();
            if (this.getOutputKeyFn() == null) {
                outputKeyCoder = outputCoder;
                outputKeyFn = SerializableFunctions.identity();
            } else {
                if (outputKeyCoder == null) {
                    TypeDescriptor<KeyT> keyT = TypeDescriptors.outputOf(this.getOutputKeyFn());
                    try {
                        outputKeyCoder = input.getPipeline().getCoderRegistry().getCoder(keyT);
                    }
                    catch (CannotProvideCoderException e) {
                        throw new RuntimeException("Unable to infer coder for KeyT (" + keyT + "). Specify it explicitly using withOutputKeyCoder().");
                    }
                }
                try {
                    outputKeyCoder.verifyDeterministic();
                }
                catch (Coder.NonDeterministicException e) {
                    throw new IllegalArgumentException("Key coder " + outputKeyCoder + " must be deterministic");
                }
            }
            PCollection polledPc = ((PCollection)input.apply(ParDo.of(new WatchGrowthFn(this, outputCoder, outputKeyFn, outputKeyCoder)).withSideInputs(this.getPollFn().getRequirements().getSideInputs()))).setCoder(KvCoder.of(input.getCoder(), ListCoder.of(TimestampedValue.TimestampedValueCoder.of(outputCoder))));
            return ((PCollection)polledPc.apply(ParDo.of(new PollResultSplitFn()))).setCoder(KvCoder.of(input.getCoder(), outputCoder));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor KeyT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> setPollFn(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized PollFn<InputT, OutputT>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> setOutputKeyFn(@Nullable @UnknownKeyFor @Initialized SerializableFunction<OutputT, KeyT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> setOutputKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<KeyT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> setTerminationPerInput(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> setPollInterval(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT, KeyT> setOutputCoder(@UnknownKeyFor @NonNull @Initialized Coder<OutputT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Growth<InputT, OutputT, KeyT> build();
        }

        static class BinaryCombined<@UnknownKeyFor InputT, @UnknownKeyFor FirstStateT, @UnknownKeyFor SecondStateT>
        implements TerminationCondition<InputT, KV<FirstStateT, SecondStateT>> {
            private final @UnknownKeyFor @NonNull @Initialized Operation operation;
            private final @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, FirstStateT> first;
            private final @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, SecondStateT> second;

            public BinaryCombined(@UnknownKeyFor @NonNull @Initialized Operation operation, @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, FirstStateT> first, @UnknownKeyFor @NonNull @Initialized TerminationCondition<InputT, SecondStateT> second) {
                this.operation = operation;
                this.first = first;
                this.second = second;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT>> getStateCoder() {
                return KvCoder.of(this.first.getStateCoder(), this.second.getStateCoder());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> forNewInput(@UnknownKeyFor @NonNull @Initialized Instant now, InputT input) {
                return KV.of(this.first.forNewInput(now, input), this.second.forNewInput(now, input));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> onSeenNewOutput(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> state) {
                return KV.of(this.first.onSeenNewOutput(now, state.getKey()), this.second.onSeenNewOutput(now, state.getValue()));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> onPollComplete(@UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> state) {
                return KV.of(this.first.onPollComplete(state.getKey()), this.second.onPollComplete(state.getValue()));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> state) {
                switch (this.operation) {
                    case OR: {
                        return this.first.canStopPolling(now, state.getKey()) || this.second.canStopPolling(now, state.getValue());
                    }
                    case AND: {
                        return this.first.canStopPolling(now, state.getKey()) && this.second.canStopPolling(now, state.getValue());
                    }
                }
                throw new UnsupportedOperationException("Unexpected operation " + (Object)((Object)this.operation));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized KV<FirstStateT, SecondStateT> state) {
                return (Object)((Object)this.operation) + "{first=" + this.first.toString(state.getKey()) + ", second=" + this.second.toString(state.getValue()) + '}';
            }

            private static enum Operation {
                OR,
                AND;

            }
        }

        static class AfterTimeSinceNewOutput<@UnknownKeyFor InputT>
        implements TerminationCondition<InputT, KV<Instant, ReadableDuration>> {
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized ReadableDuration> maxTimeSinceNewOutput;

            private AfterTimeSinceNewOutput(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized ReadableDuration> maxTimeSinceNewOutput) {
                this.maxTimeSinceNewOutput = maxTimeSinceNewOutput;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration>> getStateCoder() {
                return KvCoder.of(NullableCoder.of(InstantCoder.of()), DurationCoder.of());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> forNewInput(@UnknownKeyFor @NonNull @Initialized Instant now, InputT input) {
                return KV.of(null, this.maxTimeSinceNewOutput.apply(input));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> onSeenNewOutput(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> state) {
                return KV.of(now, state.getValue());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> state) {
                Instant timeOfLastNewOutput = state.getKey();
                ReadableDuration maxTimeSinceNewOutput = state.getValue();
                return timeOfLastNewOutput != null && new Duration((ReadableInstant)timeOfLastNewOutput, (ReadableInstant)now).isLongerThan(maxTimeSinceNewOutput);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> state) {
                return "AfterTimeSinceNewOutput{timeOfLastNewOutput=" + state.getKey() + ", maxTimeSinceNewOutput=" + state.getValue() + '}';
            }
        }

        static class AfterIterations<@UnknownKeyFor InputT>
        implements TerminationCondition<InputT, Integer> {
            private final @UnknownKeyFor @NonNull @Initialized int maxIterations;

            private AfterIterations(@UnknownKeyFor @NonNull @Initialized int maxIterations) {
                this.maxIterations = maxIterations;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> getStateCoder() {
                return VarIntCoder.of();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Integer forNewInput(@UnknownKeyFor @NonNull @Initialized Instant now, InputT input) {
                return 0;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Integer onPollComplete(@UnknownKeyFor @NonNull @Initialized Integer state) {
                return state + 1;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized Integer state) {
                return state >= this.maxIterations;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Integer state) {
                return "AfterIterations{iterations=" + state + ", maxIterations=" + this.maxIterations + '}';
            }
        }

        static class AfterTotalOf<@UnknownKeyFor InputT>
        implements TerminationCondition<InputT, KV<Instant, ReadableDuration>> {
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized ReadableDuration> maxTimeSinceInput;

            private AfterTotalOf(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized ReadableDuration> maxTimeSinceInput) {
                this.maxTimeSinceInput = maxTimeSinceInput;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration>> getStateCoder() {
                return KvCoder.of(InstantCoder.of(), DurationCoder.of());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> forNewInput(@UnknownKeyFor @NonNull @Initialized Instant now, InputT input) {
                return KV.of(now, this.maxTimeSinceInput.apply(input));
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> state) {
                return new Duration((ReadableInstant)state.getKey(), (ReadableInstant)now).isLongerThan(state.getValue());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized ReadableDuration> state) {
                return "AfterTotalOf{timeStarted=" + state.getKey() + ", maxTimeSinceInput=" + state.getValue() + '}';
            }
        }

        static class IgnoreInput<@UnknownKeyFor InputT, @UnknownKeyFor StateT>
        implements TerminationCondition<InputT, StateT> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TerminationCondition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, StateT> wrapped;

            IgnoreInput(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TerminationCondition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, StateT> wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<StateT> getStateCoder() {
                return this.wrapped.getStateCoder();
            }

            @Override
            public StateT forNewInput(@UnknownKeyFor @NonNull @Initialized Instant now, InputT input) {
                return this.wrapped.forNewInput(now, null);
            }

            @Override
            public StateT onSeenNewOutput(@UnknownKeyFor @NonNull @Initialized Instant now, StateT state) {
                return this.wrapped.onSeenNewOutput(now, state);
            }

            @Override
            public StateT onPollComplete(StateT state) {
                return this.wrapped.onPollComplete(state);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant now, StateT state) {
                return this.wrapped.canStopPolling(now, state);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toString(StateT state) {
                return this.wrapped.toString(state);
            }
        }

        static class Never<@UnknownKeyFor InputT>
        implements TerminationCondition<InputT, Integer> {
            Never() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Integer> getStateCoder() {
                return VarIntCoder.of();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Integer forNewInput(@UnknownKeyFor @NonNull @Initialized Instant now, InputT input) {
                return 0;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized Integer state) {
                return false;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Integer state) {
                return "Never";
            }
        }

        public static interface TerminationCondition<@UnknownKeyFor InputT, @UnknownKeyFor StateT>
        extends Serializable {
            public @UnknownKeyFor @NonNull @Initialized Coder<StateT> getStateCoder();

            public StateT forNewInput(@UnknownKeyFor @NonNull @Initialized Instant var1, @Nullable InputT var2);

            default public StateT onSeenNewOutput(@UnknownKeyFor @NonNull @Initialized Instant now, StateT state) {
                return state;
            }

            default public StateT onPollComplete(StateT state) {
                return state;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean canStopPolling(@UnknownKeyFor @NonNull @Initialized Instant var1, StateT var2);

            public @UnknownKeyFor @NonNull @Initialized String toString(StateT var1);
        }

        public static abstract class PollFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
        implements Contextful.Fn<InputT, PollResult<OutputT>> {
        }

        public static final class PollResult<@UnknownKeyFor OutputT> {
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> outputs;
            private final @Nullable @UnknownKeyFor @Initialized Instant watermark;

            private PollResult(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> outputs, @Nullable @UnknownKeyFor @Initialized Instant watermark) {
                this.outputs = outputs;
                this.watermark = watermark;
            }

            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> getOutputs() {
                return this.outputs;
            }

            @Nullable @UnknownKeyFor @Initialized Instant getWatermark() {
                return this.watermark;
            }

            public @UnknownKeyFor @NonNull @Initialized PollResult<OutputT> withWatermark(@UnknownKeyFor @NonNull @Initialized Instant watermark) {
                Preconditions.checkNotNull((Object)watermark, (Object)"watermark");
                return new PollResult<OutputT>(this.outputs, watermark);
            }

            public @UnknownKeyFor @NonNull @Initialized PollResult<OutputT> withOutputs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> outputs) {
                Preconditions.checkNotNull(outputs);
                return new PollResult<OutputT>(outputs, this.watermark);
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper((Object)this).add("watermark", (Object)this.watermark).add("outputs", this.outputs).toString();
            }

            public static <OutputT> @UnknownKeyFor @NonNull @Initialized PollResult<OutputT> complete(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> outputs) {
                return new PollResult<OutputT>(outputs, BoundedWindow.TIMESTAMP_MAX_VALUE);
            }

            public static <OutputT> @UnknownKeyFor @NonNull @Initialized PollResult<OutputT> complete(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized List<OutputT> outputs) {
                return new PollResult<OutputT>(PollResult.addTimestamp(timestamp, outputs), BoundedWindow.TIMESTAMP_MAX_VALUE);
            }

            public static <OutputT> @UnknownKeyFor @NonNull @Initialized PollResult<OutputT> incomplete(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> outputs) {
                return new PollResult<OutputT>(outputs, null);
            }

            public static <OutputT> @UnknownKeyFor @NonNull @Initialized PollResult<OutputT> incomplete(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized List<OutputT> outputs) {
                return new PollResult<OutputT>(PollResult.addTimestamp(timestamp, outputs), null);
            }

            private static <OutputT> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<OutputT>> addTimestamp(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized List<OutputT> outputs) {
                ArrayList res = Lists.newArrayListWithExpectedSize((int)outputs.size());
                for (OutputT output : outputs) {
                    res.add(TimestampedValue.of(output, timestamp));
                }
                return res;
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PollResult that = (PollResult)o;
                return Objects.equals(this.outputs, that.outputs) && Objects.equals(this.watermark, that.watermark);
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return Objects.hash(this.outputs, this.watermark);
            }
        }
    }
}

