/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.undo.ChangeAction;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class HopGuiWorkflowUndoDelegate {
    private HopGuiWorkflowGraph workflowGraph;
    private HopGui hopGui;

    public HopGuiWorkflowUndoDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
    }

    public void undoWorkflowAction(IHopFileTypeHandler handler, WorkflowMeta workflowMeta) {
        ChangeAction changeAction = workflowMeta.previousUndo();
        if (changeAction == null) {
            return;
        }
        this.undoWorkflowAction(handler, workflowMeta, changeAction);
        handler.updateGui();
    }

    public void undoWorkflowAction(IHopFileTypeHandler handler, WorkflowMeta workflowMeta, ChangeAction changeAction) {
        switch (changeAction.getType()) {
            case NewAction: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeAction(idx);
                }
                break;
            }
            case NewNote: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeNote(idx);
                }
                break;
            }
            case NewWorkflowHop: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeWorkflowHop(idx);
                }
                break;
            }
            case DeleteAction: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    ActionMeta action = (ActionMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.addAction(idx, action);
                }
                break;
            }
            case DeleteNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.addNote(idx, ni);
                }
                break;
            }
            case DeleteWorkflowHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    WorkflowHopMeta hopMeta = (WorkflowHopMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    ActionMeta from = workflowMeta.findAction(hopMeta.getFromAction().getName());
                    ActionMeta to = workflowMeta.findAction(hopMeta.getToAction().getName());
                    WorkflowHopMeta newHopMeta = new WorkflowHopMeta(from, to);
                    newHopMeta.setEvaluation(hopMeta.isEvaluation());
                    newHopMeta.setUnconditional(hopMeta.isUnconditional());
                    workflowMeta.addWorkflowHop(idx, newHopMeta);
                }
                break;
            }
            case ChangeAction: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    ActionMeta prev = ((ActionMeta)changeAction.getPrevious()[i]).clone();
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.getAction(idx).replaceMeta(prev);
                }
                break;
            }
            case ChangeNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeNote(idx);
                    NotePadMeta prev = (NotePadMeta)changeAction.getPrevious()[i];
                    workflowMeta.addNote(idx, prev.clone());
                }
                break;
            }
            case ChangeWorkflowHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    WorkflowHopMeta prev = (WorkflowHopMeta)changeAction.getPrevious()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeWorkflowHop(idx);
                    workflowMeta.addWorkflowHop(idx, prev.clone());
                }
                break;
            }
            case PositionAction: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    ActionMeta action = workflowMeta.getAction(changeAction.getCurrentIndex()[i]);
                    action.setLocation(changeAction.getPreviousLocation()[i]);
                }
                break;
            }
            case PositionNote: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    NotePadMeta npi = workflowMeta.getNote(idx);
                    Point prev = changeAction.getPreviousLocation()[i];
                    npi.setLocation(prev);
                }
                break;
            }
        }
        if (workflowMeta.viewNextUndo() != null && workflowMeta.viewNextUndo().getNextAlso()) {
            this.undoWorkflowAction(handler, workflowMeta);
        }
    }

    public void redoWorkflowAction(IHopFileTypeHandler handler, WorkflowMeta workflowMeta) {
        ChangeAction changeAction = workflowMeta.nextUndo();
        if (changeAction == null) {
            return;
        }
        this.redoWorkflowAction(handler, workflowMeta, changeAction);
        handler.updateGui();
    }

    public void redoWorkflowAction(IHopFileTypeHandler handler, WorkflowMeta workflowMeta, ChangeAction changeAction) {
        switch (changeAction.getType()) {
            case NewAction: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    ActionMeta entryCopy = (ActionMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.addAction(idx, entryCopy);
                }
                break;
            }
            case NewNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.addNote(idx, ni);
                }
                break;
            }
            case NewWorkflowHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    WorkflowHopMeta hopMeta = (WorkflowHopMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.addWorkflowHop(idx, hopMeta);
                }
                break;
            }
            case DeleteAction: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeAction(idx);
                }
                break;
            }
            case DeleteNote: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeNote(idx);
                }
                break;
            }
            case DeleteWorkflowHop: {
                for (int i = changeAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeWorkflowHop(idx);
                }
                break;
            }
            case ChangeTransform: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    ActionMeta clonedEntry = ((ActionMeta)changeAction.getCurrent()[i]).clone();
                    workflowMeta.getAction(changeAction.getCurrentIndex()[i]).replaceMeta(clonedEntry);
                }
                break;
            }
            case ChangeNote: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeNote(idx);
                    workflowMeta.addNote(idx, ni.clone());
                }
                break;
            }
            case ChangeWorkflowHop: {
                for (int i = 0; i < changeAction.getCurrent().length; ++i) {
                    WorkflowHopMeta hi = (WorkflowHopMeta)changeAction.getCurrent()[i];
                    int idx = changeAction.getCurrentIndex()[i];
                    workflowMeta.removeWorkflowHop(idx);
                    workflowMeta.addWorkflowHop(idx, hi.clone());
                }
                break;
            }
            case PositionAction: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    ActionMeta action = workflowMeta.getAction(changeAction.getCurrentIndex()[i]);
                    action.setLocation(changeAction.getCurrentLocation()[i]);
                }
                break;
            }
            case PositionNote: {
                for (int i = 0; i < changeAction.getCurrentIndex().length; ++i) {
                    int idx = changeAction.getCurrentIndex()[i];
                    NotePadMeta npi = workflowMeta.getNote(idx);
                    Point curr = changeAction.getCurrentLocation()[i];
                    npi.setLocation(curr);
                }
                break;
            }
        }
        if (workflowMeta.viewNextUndo() != null && workflowMeta.viewNextUndo().getNextAlso()) {
            this.redoWorkflowAction(handler, workflowMeta);
        }
    }

    public HopGuiWorkflowGraph getWorkflowGraph() {
        return this.workflowGraph;
    }

    public void setWorkflowGraph(HopGuiWorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }
}

