/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.search;

import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableCallback;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;

public class HopGuiPipelineSearchable
implements ISearchable<PipelineMeta> {
    private String location;
    private PipelineMeta pipelineMeta;

    public HopGuiPipelineSearchable(String location, PipelineMeta pipelineMeta) {
        this.location = location;
        this.pipelineMeta = pipelineMeta;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.pipelineMeta.getName();
    }

    public String getType() {
        return "Pipeline";
    }

    public String getFilename() {
        return this.pipelineMeta.getFilename();
    }

    public PipelineMeta getSearchableObject() {
        return this.pipelineMeta;
    }

    public ISearchableCallback getSearchCallback() {
        return (searchable, searchResult) -> {
            TransformMeta transformMeta;
            HopGuiPipelineGraph pipelineGraph;
            ExplorerPerspective perspective = HopGui.getExplorerPerspective();
            IHopFileTypeHandler fileTypeHandler = perspective.findFileTypeHandlerByFilename(this.pipelineMeta.getFilename());
            if (fileTypeHandler != null) {
                perspective.setActiveFileTypeHandler(fileTypeHandler);
                pipelineGraph = (HopGuiPipelineGraph)fileTypeHandler;
            } else {
                pipelineGraph = (HopGuiPipelineGraph)perspective.addPipeline(this.pipelineMeta);
            }
            perspective.activate();
            if (searchResult.getComponent() != null && (transformMeta = this.pipelineMeta.findTransform(searchResult.getComponent())) != null) {
                transformMeta.setSelected(true);
                pipelineGraph.editTransform(this.pipelineMeta, transformMeta);
            }
        };
    }
}

