/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SyncSetting {
    DEFAULT,
    NOT_SYNCED,
    NOT_SYNCED_INACTIVE,
    OTHER;


    public static class Serializer
    extends UnionSerializer<SyncSetting> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(SyncSetting value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case DEFAULT: {
                    g.writeString("default");
                    break;
                }
                case NOT_SYNCED: {
                    g.writeString("not_synced");
                    break;
                }
                case NOT_SYNCED_INACTIVE: {
                    g.writeString("not_synced_inactive");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SyncSetting deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            SyncSetting value = "default".equals(tag) ? DEFAULT : ("not_synced".equals(tag) ? NOT_SYNCED : ("not_synced_inactive".equals(tag) ? NOT_SYNCED_INACTIVE : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

