/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.TeamMemberInfoV2;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class MemberAddV2Result {
    public static final MemberAddV2Result OTHER = new MemberAddV2Result().withTag(Tag.OTHER);
    private Tag _tag;
    private String teamLicenseLimitValue;
    private String freeTeamMemberLimitReachedValue;
    private String userAlreadyOnTeamValue;
    private String userOnAnotherTeamValue;
    private String userAlreadyPairedValue;
    private String userMigrationFailedValue;
    private String duplicateExternalMemberIdValue;
    private String duplicateMemberPersistentIdValue;
    private String persistentIdDisabledValue;
    private String userCreationFailedValue;
    private TeamMemberInfoV2 successValue;

    private MemberAddV2Result() {
    }

    private MemberAddV2Result withTag(Tag _tag) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        return result;
    }

    private MemberAddV2Result withTagAndTeamLicenseLimit(Tag _tag, String teamLicenseLimitValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.teamLicenseLimitValue = teamLicenseLimitValue;
        return result;
    }

    private MemberAddV2Result withTagAndFreeTeamMemberLimitReached(Tag _tag, String freeTeamMemberLimitReachedValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.freeTeamMemberLimitReachedValue = freeTeamMemberLimitReachedValue;
        return result;
    }

    private MemberAddV2Result withTagAndUserAlreadyOnTeam(Tag _tag, String userAlreadyOnTeamValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.userAlreadyOnTeamValue = userAlreadyOnTeamValue;
        return result;
    }

    private MemberAddV2Result withTagAndUserOnAnotherTeam(Tag _tag, String userOnAnotherTeamValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.userOnAnotherTeamValue = userOnAnotherTeamValue;
        return result;
    }

    private MemberAddV2Result withTagAndUserAlreadyPaired(Tag _tag, String userAlreadyPairedValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.userAlreadyPairedValue = userAlreadyPairedValue;
        return result;
    }

    private MemberAddV2Result withTagAndUserMigrationFailed(Tag _tag, String userMigrationFailedValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.userMigrationFailedValue = userMigrationFailedValue;
        return result;
    }

    private MemberAddV2Result withTagAndDuplicateExternalMemberId(Tag _tag, String duplicateExternalMemberIdValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.duplicateExternalMemberIdValue = duplicateExternalMemberIdValue;
        return result;
    }

    private MemberAddV2Result withTagAndDuplicateMemberPersistentId(Tag _tag, String duplicateMemberPersistentIdValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.duplicateMemberPersistentIdValue = duplicateMemberPersistentIdValue;
        return result;
    }

    private MemberAddV2Result withTagAndPersistentIdDisabled(Tag _tag, String persistentIdDisabledValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.persistentIdDisabledValue = persistentIdDisabledValue;
        return result;
    }

    private MemberAddV2Result withTagAndUserCreationFailed(Tag _tag, String userCreationFailedValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.userCreationFailedValue = userCreationFailedValue;
        return result;
    }

    private MemberAddV2Result withTagAndSuccess(Tag _tag, TeamMemberInfoV2 successValue) {
        MemberAddV2Result result = new MemberAddV2Result();
        result._tag = _tag;
        result.successValue = successValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTeamLicenseLimit() {
        return this._tag == Tag.TEAM_LICENSE_LIMIT;
    }

    public static MemberAddV2Result teamLicenseLimit(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndTeamLicenseLimit(Tag.TEAM_LICENSE_LIMIT, value);
    }

    public String getTeamLicenseLimitValue() {
        if (this._tag != Tag.TEAM_LICENSE_LIMIT) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_LICENSE_LIMIT, but was Tag." + this._tag.name());
        }
        return this.teamLicenseLimitValue;
    }

    public boolean isFreeTeamMemberLimitReached() {
        return this._tag == Tag.FREE_TEAM_MEMBER_LIMIT_REACHED;
    }

    public static MemberAddV2Result freeTeamMemberLimitReached(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndFreeTeamMemberLimitReached(Tag.FREE_TEAM_MEMBER_LIMIT_REACHED, value);
    }

    public String getFreeTeamMemberLimitReachedValue() {
        if (this._tag != Tag.FREE_TEAM_MEMBER_LIMIT_REACHED) {
            throw new IllegalStateException("Invalid tag: required Tag.FREE_TEAM_MEMBER_LIMIT_REACHED, but was Tag." + this._tag.name());
        }
        return this.freeTeamMemberLimitReachedValue;
    }

    public boolean isUserAlreadyOnTeam() {
        return this._tag == Tag.USER_ALREADY_ON_TEAM;
    }

    public static MemberAddV2Result userAlreadyOnTeam(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndUserAlreadyOnTeam(Tag.USER_ALREADY_ON_TEAM, value);
    }

    public String getUserAlreadyOnTeamValue() {
        if (this._tag != Tag.USER_ALREADY_ON_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ALREADY_ON_TEAM, but was Tag." + this._tag.name());
        }
        return this.userAlreadyOnTeamValue;
    }

    public boolean isUserOnAnotherTeam() {
        return this._tag == Tag.USER_ON_ANOTHER_TEAM;
    }

    public static MemberAddV2Result userOnAnotherTeam(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndUserOnAnotherTeam(Tag.USER_ON_ANOTHER_TEAM, value);
    }

    public String getUserOnAnotherTeamValue() {
        if (this._tag != Tag.USER_ON_ANOTHER_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ON_ANOTHER_TEAM, but was Tag." + this._tag.name());
        }
        return this.userOnAnotherTeamValue;
    }

    public boolean isUserAlreadyPaired() {
        return this._tag == Tag.USER_ALREADY_PAIRED;
    }

    public static MemberAddV2Result userAlreadyPaired(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndUserAlreadyPaired(Tag.USER_ALREADY_PAIRED, value);
    }

    public String getUserAlreadyPairedValue() {
        if (this._tag != Tag.USER_ALREADY_PAIRED) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ALREADY_PAIRED, but was Tag." + this._tag.name());
        }
        return this.userAlreadyPairedValue;
    }

    public boolean isUserMigrationFailed() {
        return this._tag == Tag.USER_MIGRATION_FAILED;
    }

    public static MemberAddV2Result userMigrationFailed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndUserMigrationFailed(Tag.USER_MIGRATION_FAILED, value);
    }

    public String getUserMigrationFailedValue() {
        if (this._tag != Tag.USER_MIGRATION_FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_MIGRATION_FAILED, but was Tag." + this._tag.name());
        }
        return this.userMigrationFailedValue;
    }

    public boolean isDuplicateExternalMemberId() {
        return this._tag == Tag.DUPLICATE_EXTERNAL_MEMBER_ID;
    }

    public static MemberAddV2Result duplicateExternalMemberId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndDuplicateExternalMemberId(Tag.DUPLICATE_EXTERNAL_MEMBER_ID, value);
    }

    public String getDuplicateExternalMemberIdValue() {
        if (this._tag != Tag.DUPLICATE_EXTERNAL_MEMBER_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.DUPLICATE_EXTERNAL_MEMBER_ID, but was Tag." + this._tag.name());
        }
        return this.duplicateExternalMemberIdValue;
    }

    public boolean isDuplicateMemberPersistentId() {
        return this._tag == Tag.DUPLICATE_MEMBER_PERSISTENT_ID;
    }

    public static MemberAddV2Result duplicateMemberPersistentId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndDuplicateMemberPersistentId(Tag.DUPLICATE_MEMBER_PERSISTENT_ID, value);
    }

    public String getDuplicateMemberPersistentIdValue() {
        if (this._tag != Tag.DUPLICATE_MEMBER_PERSISTENT_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.DUPLICATE_MEMBER_PERSISTENT_ID, but was Tag." + this._tag.name());
        }
        return this.duplicateMemberPersistentIdValue;
    }

    public boolean isPersistentIdDisabled() {
        return this._tag == Tag.PERSISTENT_ID_DISABLED;
    }

    public static MemberAddV2Result persistentIdDisabled(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndPersistentIdDisabled(Tag.PERSISTENT_ID_DISABLED, value);
    }

    public String getPersistentIdDisabledValue() {
        if (this._tag != Tag.PERSISTENT_ID_DISABLED) {
            throw new IllegalStateException("Invalid tag: required Tag.PERSISTENT_ID_DISABLED, but was Tag." + this._tag.name());
        }
        return this.persistentIdDisabledValue;
    }

    public boolean isUserCreationFailed() {
        return this._tag == Tag.USER_CREATION_FAILED;
    }

    public static MemberAddV2Result userCreationFailed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddV2Result().withTagAndUserCreationFailed(Tag.USER_CREATION_FAILED, value);
    }

    public String getUserCreationFailedValue() {
        if (this._tag != Tag.USER_CREATION_FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_CREATION_FAILED, but was Tag." + this._tag.name());
        }
        return this.userCreationFailedValue;
    }

    public boolean isSuccess() {
        return this._tag == Tag.SUCCESS;
    }

    public static MemberAddV2Result success(TeamMemberInfoV2 value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MemberAddV2Result().withTagAndSuccess(Tag.SUCCESS, value);
    }

    public TeamMemberInfoV2 getSuccessValue() {
        if (this._tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this._tag.name());
        }
        return this.successValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.teamLicenseLimitValue, this.freeTeamMemberLimitReachedValue, this.userAlreadyOnTeamValue, this.userOnAnotherTeamValue, this.userAlreadyPairedValue, this.userMigrationFailedValue, this.duplicateExternalMemberIdValue, this.duplicateMemberPersistentIdValue, this.persistentIdDisabledValue, this.userCreationFailedValue, this.successValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MemberAddV2Result) {
            MemberAddV2Result other = (MemberAddV2Result)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEAM_LICENSE_LIMIT: {
                    return this.teamLicenseLimitValue == other.teamLicenseLimitValue || this.teamLicenseLimitValue.equals(other.teamLicenseLimitValue);
                }
                case FREE_TEAM_MEMBER_LIMIT_REACHED: {
                    return this.freeTeamMemberLimitReachedValue == other.freeTeamMemberLimitReachedValue || this.freeTeamMemberLimitReachedValue.equals(other.freeTeamMemberLimitReachedValue);
                }
                case USER_ALREADY_ON_TEAM: {
                    return this.userAlreadyOnTeamValue == other.userAlreadyOnTeamValue || this.userAlreadyOnTeamValue.equals(other.userAlreadyOnTeamValue);
                }
                case USER_ON_ANOTHER_TEAM: {
                    return this.userOnAnotherTeamValue == other.userOnAnotherTeamValue || this.userOnAnotherTeamValue.equals(other.userOnAnotherTeamValue);
                }
                case USER_ALREADY_PAIRED: {
                    return this.userAlreadyPairedValue == other.userAlreadyPairedValue || this.userAlreadyPairedValue.equals(other.userAlreadyPairedValue);
                }
                case USER_MIGRATION_FAILED: {
                    return this.userMigrationFailedValue == other.userMigrationFailedValue || this.userMigrationFailedValue.equals(other.userMigrationFailedValue);
                }
                case DUPLICATE_EXTERNAL_MEMBER_ID: {
                    return this.duplicateExternalMemberIdValue == other.duplicateExternalMemberIdValue || this.duplicateExternalMemberIdValue.equals(other.duplicateExternalMemberIdValue);
                }
                case DUPLICATE_MEMBER_PERSISTENT_ID: {
                    return this.duplicateMemberPersistentIdValue == other.duplicateMemberPersistentIdValue || this.duplicateMemberPersistentIdValue.equals(other.duplicateMemberPersistentIdValue);
                }
                case PERSISTENT_ID_DISABLED: {
                    return this.persistentIdDisabledValue == other.persistentIdDisabledValue || this.persistentIdDisabledValue.equals(other.persistentIdDisabledValue);
                }
                case USER_CREATION_FAILED: {
                    return this.userCreationFailedValue == other.userCreationFailedValue || this.userCreationFailedValue.equals(other.userCreationFailedValue);
                }
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MemberAddV2Result> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberAddV2Result value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEAM_LICENSE_LIMIT: {
                    g.writeStartObject();
                    this.writeTag("team_license_limit", g);
                    g.writeFieldName("team_license_limit");
                    StoneSerializers.string().serialize(value.teamLicenseLimitValue, g);
                    g.writeEndObject();
                    break;
                }
                case FREE_TEAM_MEMBER_LIMIT_REACHED: {
                    g.writeStartObject();
                    this.writeTag("free_team_member_limit_reached", g);
                    g.writeFieldName("free_team_member_limit_reached");
                    StoneSerializers.string().serialize(value.freeTeamMemberLimitReachedValue, g);
                    g.writeEndObject();
                    break;
                }
                case USER_ALREADY_ON_TEAM: {
                    g.writeStartObject();
                    this.writeTag("user_already_on_team", g);
                    g.writeFieldName("user_already_on_team");
                    StoneSerializers.string().serialize(value.userAlreadyOnTeamValue, g);
                    g.writeEndObject();
                    break;
                }
                case USER_ON_ANOTHER_TEAM: {
                    g.writeStartObject();
                    this.writeTag("user_on_another_team", g);
                    g.writeFieldName("user_on_another_team");
                    StoneSerializers.string().serialize(value.userOnAnotherTeamValue, g);
                    g.writeEndObject();
                    break;
                }
                case USER_ALREADY_PAIRED: {
                    g.writeStartObject();
                    this.writeTag("user_already_paired", g);
                    g.writeFieldName("user_already_paired");
                    StoneSerializers.string().serialize(value.userAlreadyPairedValue, g);
                    g.writeEndObject();
                    break;
                }
                case USER_MIGRATION_FAILED: {
                    g.writeStartObject();
                    this.writeTag("user_migration_failed", g);
                    g.writeFieldName("user_migration_failed");
                    StoneSerializers.string().serialize(value.userMigrationFailedValue, g);
                    g.writeEndObject();
                    break;
                }
                case DUPLICATE_EXTERNAL_MEMBER_ID: {
                    g.writeStartObject();
                    this.writeTag("duplicate_external_member_id", g);
                    g.writeFieldName("duplicate_external_member_id");
                    StoneSerializers.string().serialize(value.duplicateExternalMemberIdValue, g);
                    g.writeEndObject();
                    break;
                }
                case DUPLICATE_MEMBER_PERSISTENT_ID: {
                    g.writeStartObject();
                    this.writeTag("duplicate_member_persistent_id", g);
                    g.writeFieldName("duplicate_member_persistent_id");
                    StoneSerializers.string().serialize(value.duplicateMemberPersistentIdValue, g);
                    g.writeEndObject();
                    break;
                }
                case PERSISTENT_ID_DISABLED: {
                    g.writeStartObject();
                    this.writeTag("persistent_id_disabled", g);
                    g.writeFieldName("persistent_id_disabled");
                    StoneSerializers.string().serialize(value.persistentIdDisabledValue, g);
                    g.writeEndObject();
                    break;
                }
                case USER_CREATION_FAILED: {
                    g.writeStartObject();
                    this.writeTag("user_creation_failed", g);
                    g.writeFieldName("user_creation_failed");
                    StoneSerializers.string().serialize(value.userCreationFailedValue, g);
                    g.writeEndObject();
                    break;
                }
                case SUCCESS: {
                    g.writeStartObject();
                    this.writeTag("success", g);
                    TeamMemberInfoV2.Serializer.INSTANCE.serialize(value.successValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MemberAddV2Result deserialize(JsonParser p) throws IOException, JsonParseException {
            MemberAddV2Result value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("team_license_limit".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("team_license_limit", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.teamLicenseLimit(fieldValue);
            } else if ("free_team_member_limit_reached".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("free_team_member_limit_reached", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.freeTeamMemberLimitReached(fieldValue);
            } else if ("user_already_on_team".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("user_already_on_team", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.userAlreadyOnTeam(fieldValue);
            } else if ("user_on_another_team".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("user_on_another_team", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.userOnAnotherTeam(fieldValue);
            } else if ("user_already_paired".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("user_already_paired", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.userAlreadyPaired(fieldValue);
            } else if ("user_migration_failed".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("user_migration_failed", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.userMigrationFailed(fieldValue);
            } else if ("duplicate_external_member_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("duplicate_external_member_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.duplicateExternalMemberId(fieldValue);
            } else if ("duplicate_member_persistent_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("duplicate_member_persistent_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.duplicateMemberPersistentId(fieldValue);
            } else if ("persistent_id_disabled".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("persistent_id_disabled", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.persistentIdDisabled(fieldValue);
            } else if ("user_creation_failed".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("user_creation_failed", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberAddV2Result.userCreationFailed(fieldValue);
            } else if ("success".equals(tag)) {
                TeamMemberInfoV2 fieldValue = null;
                fieldValue = TeamMemberInfoV2.Serializer.INSTANCE.deserialize(p, true);
                value = MemberAddV2Result.success(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEAM_LICENSE_LIMIT,
        FREE_TEAM_MEMBER_LIMIT_REACHED,
        USER_ALREADY_ON_TEAM,
        USER_ON_ANOTHER_TEAM,
        USER_ALREADY_PAIRED,
        USER_MIGRATION_FAILED,
        DUPLICATE_EXTERNAL_MEMBER_ID,
        DUPLICATE_MEMBER_PERSISTENT_ID,
        PERSISTENT_ID_DISABLED,
        USER_CREATION_FAILED,
        SUCCESS,
        OTHER;

    }
}

