/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hosted.kafka.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.BasicOAuthBearerToken;

public class GcpLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final String JWT_SUBJECT_CLAIM = "sub";
    private static final String JWT_ISSUED_AT_CLAIM = "iat";
    private static final String JWT_SCOPE_CLAIM = "scope";
    private static final String JWT_EXP_CLAIM = "exp";
    private static final String GOOGLE_CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final String TARGET_AUDIENCE = "https://www.googleapis.com/oauth2/v4/token";
    private static final String HEADER = new Gson().toJson((Object)ImmutableMap.of((Object)"typ", (Object)"JWT", (Object)"alg", (Object)"GOOG_OAUTH2_TOKEN"));
    private boolean configured = false;
    private final GoogleCredentials credentials;

    public GcpLoginCallbackHandler() {
        try {
            this.credentials = GoogleCredentials.getApplicationDefault().createScoped(new String[]{GOOGLE_CLOUD_PLATFORM_SCOPE});
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create Google credentials", e);
        }
    }

    @VisibleForTesting
    GcpLoginCallbackHandler(GoogleCredentials credentials) {
        this.credentials = credentials;
    }

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!Objects.equals(saslMechanism, "OAUTHBEARER")) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        this.configured = true;
    }

    private boolean isConfigured() {
        return this.configured;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (!(callback instanceof OAuthBearerTokenCallback)) {
                throw new UnsupportedCallbackException(callback);
            }
            this.handleTokenCallback((OAuthBearerTokenCallback)callback);
        }
    }

    private void handleTokenCallback(OAuthBearerTokenCallback callback) throws IOException {
        String subject = "";
        if (this.credentials instanceof ComputeEngineCredentials) {
            subject = ((ComputeEngineCredentials)this.credentials).getAccount();
        } else if (this.credentials instanceof ServiceAccountCredentials) {
            subject = ((ServiceAccountCredentials)this.credentials).getClientEmail();
        } else if (this.credentials instanceof ExternalAccountCredentials) {
            subject = ((ExternalAccountCredentials)this.credentials).getServiceAccountEmail();
        } else if (this.credentials instanceof ImpersonatedCredentials) {
            subject = ((ImpersonatedCredentials)this.credentials).getAccount();
        } else if (this.credentials instanceof StubGoogleCredentials) {
            subject = ((StubGoogleCredentials)this.credentials).getAccount();
        } else if (this.credentials instanceof IdTokenProvider) {
            subject = GcpLoginCallbackHandler.parseGoogleIdToken((IdTokenProvider)this.credentials).getEmail();
        } else {
            throw new IOException("Unknown credentials type: " + this.credentials.getClass().getName());
        }
        this.credentials.refreshIfExpired();
        AccessToken googleAccessToken = this.credentials.getAccessToken();
        String kafkaToken = GcpLoginCallbackHandler.getKafkaAccessToken(googleAccessToken, subject);
        Instant now = Instant.now();
        BasicOAuthBearerToken token = new BasicOAuthBearerToken(kafkaToken, (Set)ImmutableSet.of((Object)"kafka"), googleAccessToken.getExpirationTime().toInstant().toEpochMilli(), subject, Long.valueOf(now.toEpochMilli()));
        callback.token((OAuthBearerToken)token);
    }

    private static GoogleIdToken.Payload parseGoogleIdToken(IdTokenProvider credentials) throws IOException {
        return GoogleIdToken.parse((JsonFactory)JSON_FACTORY, (String)IdTokenCredentials.newBuilder().setTargetAudience(TARGET_AUDIENCE).setOptions(Arrays.asList(IdTokenProvider.Option.FORMAT_FULL, IdTokenProvider.Option.INCLUDE_EMAIL)).setIdTokenProvider(credentials).build().refreshAccessToken().getTokenValue()).getPayload();
    }

    private static String b64Encode(String data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data.getBytes(StandardCharsets.UTF_8));
    }

    private static String getJwt(AccessToken token, String subject) {
        return new Gson().toJson((Object)ImmutableMap.of((Object)JWT_EXP_CLAIM, (Object)token.getExpirationTime().toInstant().getEpochSecond(), (Object)JWT_ISSUED_AT_CLAIM, (Object)Instant.now().getEpochSecond(), (Object)JWT_SCOPE_CLAIM, (Object)"kafka", (Object)JWT_SUBJECT_CLAIM, (Object)subject));
    }

    private static String getKafkaAccessToken(AccessToken token, String subject) {
        return String.join((CharSequence)".", GcpLoginCallbackHandler.b64Encode(HEADER), GcpLoginCallbackHandler.b64Encode(GcpLoginCallbackHandler.getJwt(token, subject)), GcpLoginCallbackHandler.b64Encode(token.getTokenValue()));
    }

    public void close() {
    }

    static abstract class StubGoogleCredentials
    extends GoogleCredentials {
        StubGoogleCredentials() {
        }

        abstract String getAccount();
    }
}

