/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingRunner;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.util.construction.resources.PipelineResources;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface SparkCommonPipelineOptions
extends PipelineOptions,
StreamingOptions,
ApplicationNameOptions,
FileStagingOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_MASTER_URL = "local[4]";

    @Description(value="The url of the spark master to connect to, (e.g. spark://host:port, local[4]).")
    @Default.String(value="local[4]")
    public @UnknownKeyFor @NonNull @Initialized String getSparkMaster();

    public void setSparkMaster(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="A checkpoint directory for streaming resilience, ignored in batch. For durability, a reliable filesystem such as HDFS/S3/GS is necessary.")
    @Default.InstanceFactory(value=TmpCheckpointDirFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getCheckpointDir();

    public void setCheckpointDir(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Batch default storage level")
    @Default.InstanceFactory(value=StorageLevelFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getStorageLevel();

    public void setStorageLevel(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Enable/disable sending aggregator values to Spark's metric sinks")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableSparkMetricSinks();

    public void setEnableSparkMetricSinks(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="When set to true, runner will try to prefer GroupByKey translation which can handle huge values and does not require them to fit into memory. This will most likely have performance impact for pipelines which does not work with huge values, hence it is disabled by default.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getPreferGroupByKeyToHandleHugeValues();

    public void setPreferGroupByKeyToHandleHugeValues(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Internal
    public static void prepareFilesToStage(@UnknownKeyFor @NonNull @Initialized SparkCommonPipelineOptions options) {
        if (!options.getSparkMaster().matches("local\\[?\\d*]?")) {
            PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
        }
    }

    public static class StorageLevelFactory
    implements DefaultValueFactory<String> {
        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return SparkStructuredStreamingRunner.class.equals((Object)options.getRunner()) ? "MEMORY_AND_DISK" : "MEMORY_ONLY";
        }
    }

    public static class TmpCheckpointDirFactory
    implements DefaultValueFactory<String> {
        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return "/tmp/" + options.getJobName();
        }
    }
}

