/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinput;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnectionUtils;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInput;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputData;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputDialog;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputField;
import org.eclipse.swt.widgets.Shell;

@Transform(id="SalesforceInput", name="i18n::SalesforceInput.TypeLongDesc.SalesforceInput", description="i18n::SalesforceInput.TypeTooltipDesc.SalesforceInput", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", image="SFI.svg", keywords={"i18n::SalesforceInputMeta.keyword"}, documentationUrl="/pipeline/transforms/salesforceinput.html")
public class SalesforceInputMeta
extends SalesforceTransformMeta<SalesforceInput, SalesforceInputData> {
    public static final String CONST_FIELDS = "fields";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Class<?> PKG = SalesforceInputMeta.class;
    @HopMetadataProperty(key="include_sql", injectionKey="INCLUDE_SQL_IN_OUTPUT", injectionKeyDescription="SalesforceInputMeta.Injection.INCLUDE_SQL_IN_OUTPUT")
    private boolean includeSQL;
    @HopMetadataProperty(key="sql_field", injectionKey="SQL_FIELDNAME", injectionKeyDescription="SalesforceInputMeta.Injection.SQL_FIELDNAME")
    private String sqlField;
    @HopMetadataProperty(key="include_Timestamp", injectionKey="INCLUDE_TIMESTAMP_IN_OUTPUT", injectionKeyDescription="SalesforceInputMeta.Injection.INCLUDE_TIMESTAMP_IN_OUTPUT")
    private boolean includeTimestamp;
    @HopMetadataProperty(key="timstamp_field", injectionKey="TIMESTAMP_FIELDNAME", injectionKeyDescription="SalesforceInputMeta.Injection.TIMESTAMP_FIELDNAME")
    private String timestampField;
    @HopMetadataProperty(key="include_targeturl", injectionKey="INCLUDE_URL_IN_OUTPUT", injectionKeyDescription="SalesforceInputMeta.Injection.INCLUDE_URL_IN_OUTPUT")
    private boolean includeTargetURL;
    @HopMetadataProperty(key="targeturl_field", injectionKey="URL_FIELDNAME", injectionKeyDescription="SalesforceInputMeta.Injection.URL_FIELDNAME")
    private String targetURLField;
    @HopMetadataProperty(key="include_module", injectionKey="INCLUDE_MODULE_IN_OUTPUT", injectionKeyDescription="SalesforceInputMeta.Injection.INCLUDE_MODULE_IN_OUTPUT")
    private boolean includeModule;
    @HopMetadataProperty(key="module_field", injectionKey="MODULE_FIELDNAME", injectionKeyDescription="SalesforceInputMeta.Injection.MODULE_FIELDNAME")
    private String moduleField;
    @HopMetadataProperty(key="include_deletion_date", injectionKey="INCLUDE_DELETION_DATE_IN_OUTPUT", injectionKeyDescription="SalesforceInputMeta.Injection.INCLUDE_DELETION_DATE_IN_OUTPUT")
    private boolean includeDeletionDate;
    @HopMetadataProperty(key="deletion_date_field", injectionKey="DELETION_DATE_FIELDNAME", injectionKeyDescription="SalesforceInputMeta.Injection.DELETION_DATE_FIELDNAME")
    private String deletionDateField;
    @HopMetadataProperty(key="include_rownum", injectionKey="INCLUDE_ROWNUM_IN_OUTPUT", injectionKeyDescription="SalesforceInputMeta.Injection.INCLUDE_ROWNUM_IN_OUTPUT")
    private boolean includeRowNumber;
    @HopMetadataProperty(key="rownum_field", injectionKey="ROWNUM_FIELDNAME", injectionKeyDescription="SalesforceInputMeta.Injection.ROWNUM_FIELDNAME")
    private String rowNumberField;
    @HopMetadataProperty(key="condition", injectionKey="QUERY_CONDITION", injectionKeyDescription="SalesforceInputMeta.Injection.QUERY_CONDITION")
    private String condition;
    @HopMetadataProperty(key="limit", injectionKey="LIMIT", injectionKeyDescription="SalesforceInputMeta.Injection.LIMIT")
    private String rowLimit;
    @HopMetadataProperty(key="field", groupKey="fields", injectionKey="FIELD", injectionKeyDescription="SalesforceInputMeta.Injection.FIELD", injectionGroupKey="FIELDS", injectionGroupDescription="SalesforceInputMeta.Injection.FIELDS")
    private List<SalesforceInputField> fields;
    @HopMetadataProperty(key="specifyQuery", injectionKey="USE_SPECIFIED_QUERY", injectionKeyDescription="SalesforceInputMeta.Injection.USE_SPECIFIED_QUERY")
    private boolean specifyQuery;
    @HopMetadataProperty(key="query", injectionKey="SPECIFY_QUERY", injectionKeyDescription="SalesforceInputMeta.Injection.SPECIFY_QUERY")
    private String query;
    private int nrFields;
    @HopMetadataProperty(key="read_to", injectionKey="END_DATE", injectionKeyDescription="SalesforceInputMeta.Injection.END_DATE")
    private String readTo;
    @HopMetadataProperty(key="read_from", injectionKey="START_DATE", injectionKeyDescription="SalesforceInputMeta.Injection.START_DATE")
    private String readFrom;
    private int recordsFilterCode;
    @HopMetadataProperty(key="records_filter")
    private String recordsFilter;
    @HopMetadataProperty(key="use_field_api_names", injectionKey="USE_FIELD_API_NAMES", injectionKeyDescription="SalesforceInputMeta.Injection.USE_FIELD_API_NAMES")
    private boolean useFieldApiNames;
    @HopMetadataProperty(key="queryAll", injectionKey="QUERY_ALL", injectionKeyDescription="SalesforceInputMeta.Injection.QUERY_ALL")
    private boolean queryAll;

    @Injection(name="RETRIEVE")
    public void setRecordsFilterDesc(String recordsFilterDesc) {
        this.recordsFilterCode = SalesforceConnectionUtils.getRecordsFilterByDesc(recordsFilterDesc);
    }

    public boolean includeTargetURL() {
        return this.includeTargetURL;
    }

    public boolean includeTimestamp() {
        return this.includeTimestamp;
    }

    public boolean includeModule() {
        return this.includeModule;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean includeDeletionDate() {
        return this.includeDeletionDate;
    }

    @Override
    public Object clone() {
        SalesforceInputMeta retval = (SalesforceInputMeta)((Object)super.clone());
        retval.fields = new ArrayList<SalesforceInputField>();
        int nrFields = this.fields.size();
        for (int i = 0; i < nrFields; ++i) {
            if (this.fields.get(i) == null) continue;
            retval.fields.add((SalesforceInputField)this.fields.get(i).clone());
        }
        return retval;
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setFields(new ArrayList<SalesforceInputField>());
        this.setIncludeDeletionDate(false);
        this.setQueryAll(false);
        this.setReadFrom("");
        this.setReadTo("");
        this.nrFields = 0;
        this.setSpecifyQuery(false);
        this.setQuery("");
        this.setCondition("");
        this.setIncludeTargetURL(false);
        this.setTargetURLField("");
        this.setIncludeModule(false);
        this.setModuleField("");
        this.setIncludeRowNumber(false);
        this.setRowNumberField("");
        this.setDeletionDateField("");
        this.setIncludeSQL(false);
        this.setSqlField("");
        this.setIncludeTimestamp(false);
        this.setTimestampField("");
        this.setRowLimit("0");
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        for (int i = 0; i < this.fields.size(); ++i) {
            SalesforceInputField field = this.fields.get(i);
            int type = field.getTypeCode();
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v2 = ValueMetaFactory.createValueMeta((String)variables.resolve(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.includeTargetURL && !Utils.isEmpty((CharSequence)this.targetURLField)) {
            v = new ValueMetaString(variables.resolve(this.targetURLField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeModule && !Utils.isEmpty((CharSequence)this.moduleField)) {
            v = new ValueMetaString(variables.resolve(this.moduleField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeSQL && !Utils.isEmpty((CharSequence)this.sqlField)) {
            v = new ValueMetaString(variables.resolve(this.sqlField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeTimestamp && !Utils.isEmpty((CharSequence)this.timestampField)) {
            v = new ValueMetaDate(variables.resolve(this.timestampField));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber && !Utils.isEmpty((CharSequence)this.rowNumberField)) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeDeletionDate && !Utils.isEmpty((CharSequence)this.deletionDateField)) {
            v = new ValueMetaDate(variables.resolve(this.deletionDateField));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.getFields().size() == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.FieldsOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (this.includeTargetURL() && Utils.isEmpty((CharSequence)this.getTargetURLField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTargetURLField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isIncludeSQL() && Utils.isEmpty((CharSequence)this.getSqlField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoSQLField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeModule() && Utils.isEmpty((CharSequence)this.moduleField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoModuleField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeTimestamp() && Utils.isEmpty((CharSequence)this.getTimestampField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTimestampField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeRowNumber() && Utils.isEmpty((CharSequence)this.getRowNumberField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoRowNumberField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeDeletionDate() && Utils.isEmpty((CharSequence)this.getDeletionDateField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoDeletionDateField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SalesforceInputDialog getDialog(Shell shell, IVariables variables, ITransformMeta transformMeta, PipelineMeta pipelineMeta, String transformName) {
        return new SalesforceInputDialog(shell, variables, (SalesforceInputMeta)transformMeta, pipelineMeta);
    }

    @Generated
    public boolean isIncludeSQL() {
        return this.includeSQL;
    }

    @Generated
    public String getSqlField() {
        return this.sqlField;
    }

    @Generated
    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    @Generated
    public String getTimestampField() {
        return this.timestampField;
    }

    @Generated
    public boolean isIncludeTargetURL() {
        return this.includeTargetURL;
    }

    @Generated
    public String getTargetURLField() {
        return this.targetURLField;
    }

    @Generated
    public boolean isIncludeModule() {
        return this.includeModule;
    }

    @Generated
    public String getModuleField() {
        return this.moduleField;
    }

    @Generated
    public boolean isIncludeDeletionDate() {
        return this.includeDeletionDate;
    }

    @Generated
    public String getDeletionDateField() {
        return this.deletionDateField;
    }

    @Generated
    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    @Generated
    public String getRowNumberField() {
        return this.rowNumberField;
    }

    @Generated
    public String getCondition() {
        return this.condition;
    }

    @Generated
    public String getRowLimit() {
        return this.rowLimit;
    }

    @Generated
    public List<SalesforceInputField> getFields() {
        return this.fields;
    }

    @Generated
    public boolean isSpecifyQuery() {
        return this.specifyQuery;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public int getNrFields() {
        return this.nrFields;
    }

    @Generated
    public String getReadTo() {
        return this.readTo;
    }

    @Generated
    public String getReadFrom() {
        return this.readFrom;
    }

    @Generated
    public int getRecordsFilterCode() {
        return this.recordsFilterCode;
    }

    @Generated
    public String getRecordsFilter() {
        return this.recordsFilter;
    }

    @Generated
    public boolean isUseFieldApiNames() {
        return this.useFieldApiNames;
    }

    @Generated
    public boolean isQueryAll() {
        return this.queryAll;
    }

    @Generated
    public void setIncludeSQL(boolean includeSQL) {
        this.includeSQL = includeSQL;
    }

    @Generated
    public void setSqlField(String sqlField) {
        this.sqlField = sqlField;
    }

    @Generated
    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    @Generated
    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    @Generated
    public void setIncludeTargetURL(boolean includeTargetURL) {
        this.includeTargetURL = includeTargetURL;
    }

    @Generated
    public void setTargetURLField(String targetURLField) {
        this.targetURLField = targetURLField;
    }

    @Generated
    public void setIncludeModule(boolean includeModule) {
        this.includeModule = includeModule;
    }

    @Generated
    public void setModuleField(String moduleField) {
        this.moduleField = moduleField;
    }

    @Generated
    public void setIncludeDeletionDate(boolean includeDeletionDate) {
        this.includeDeletionDate = includeDeletionDate;
    }

    @Generated
    public void setDeletionDateField(String deletionDateField) {
        this.deletionDateField = deletionDateField;
    }

    @Generated
    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    @Generated
    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Generated
    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Generated
    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Generated
    public void setFields(List<SalesforceInputField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setSpecifyQuery(boolean specifyQuery) {
        this.specifyQuery = specifyQuery;
    }

    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public void setNrFields(int nrFields) {
        this.nrFields = nrFields;
    }

    @Generated
    public void setReadTo(String readTo) {
        this.readTo = readTo;
    }

    @Generated
    public void setReadFrom(String readFrom) {
        this.readFrom = readFrom;
    }

    @Generated
    public void setRecordsFilterCode(int recordsFilterCode) {
        this.recordsFilterCode = recordsFilterCode;
    }

    @Generated
    public void setRecordsFilter(String recordsFilter) {
        this.recordsFilter = recordsFilter;
    }

    @Generated
    public void setUseFieldApiNames(boolean useFieldApiNames) {
        this.useFieldApiNames = useFieldApiNames;
    }

    @Generated
    public void setQueryAll(boolean queryAll) {
        this.queryAll = queryAll;
    }
}

