/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts;

import java.io.IOException;
import javax.net.ssl.SSLException;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.GoogleCredentials;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.grpc.CallCredentials;
import net.snowflake.client.jdbc.internal.grpc.ChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.CompositeChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.alts.FailingCallCredentials;
import net.snowflake.client.jdbc.internal.grpc.alts.HandshakerServiceChannel;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.AltsProtocolNegotiator;
import net.snowflake.client.jdbc.internal.grpc.auth.MoreCallCredentials;
import net.snowflake.client.jdbc.internal.grpc.internal.SharedResourcePool;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContext;

public final class GoogleDefaultChannelCredentials {
    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        return GoogleDefaultChannelCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CallCredentials callCredentials;

        private Builder() {
        }

        public Builder callCredentials(CallCredentials callCreds) {
            this.callCredentials = callCreds;
            return this;
        }

        public ChannelCredentials build() {
            CallCredentials callCreds;
            ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(Builder.createClientFactory());
            if (this.callCredentials != null) {
                return CompositeChannelCredentials.create(nettyCredentials, this.callCredentials);
            }
            try {
                callCreds = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
            }
            catch (IOException e) {
                callCreds = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e));
            }
            return CompositeChannelCredentials.create(nettyCredentials, callCreds);
        }

        private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
            SslContext sslContext;
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
        }
    }
}

