/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.util.Arrays;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base16;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;

public class SFBinary {
    public static final SFBinary EMPTY;
    public static final SFBinary MAXIMUM;
    private static final String MAXIMUM_HEX = "Z";
    private static final byte[] HEX_TABLE;
    private static final byte INVALID = 0;
    private static final byte HEX_DIGIT = 1;
    private static final byte WHITESPACE = 2;
    private final byte[] bytes;

    public SFBinary(byte[] bytes) {
        this.bytes = bytes;
    }

    public static boolean validHex(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            byte type;
            char c = str.charAt(i);
            byte by = type = c < HEX_TABLE.length ? HEX_TABLE[c] : (byte)0;
            if (type == 0) {
                return false;
            }
            if (type != 1) continue;
            ++count;
        }
        return count % 2 == 0;
    }

    public static SFBinary fromHex(String str) {
        if (str.equals(MAXIMUM_HEX)) {
            return MAXIMUM;
        }
        if (!SFBinary.validHex(str)) {
            throw new IllegalArgumentException("Invalid hex in '" + str + "'");
        }
        return new SFBinary(Base16.decode(str));
    }

    public static SFBinary fromBase64(String str) {
        return new SFBinary(Base64.decode(str));
    }

    public byte[] getBytes() {
        assert (!this.equals(MAXIMUM));
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public String toHex() {
        if (this.equals(MAXIMUM)) {
            return MAXIMUM_HEX;
        }
        return Base16.encodeAsString(this.bytes);
    }

    public String toBase64() {
        assert (!this.equals(MAXIMUM));
        return Base64.encodeAsString(this.bytes);
    }

    public SFBinary substring(int start, int end) {
        if (start == end) {
            return EMPTY;
        }
        return new SFBinary(Arrays.copyOfRange(this.bytes, start, end));
    }

    public SFBinary concat(SFBinary other) {
        assert (!this.equals(MAXIMUM));
        assert (!Objects.equals(other, MAXIMUM));
        byte[] result = Arrays.copyOf(this.bytes, this.bytes.length + other.bytes.length);
        System.arraycopy(other.bytes, 0, result, this.bytes.length, other.bytes.length);
        return new SFBinary(result);
    }

    public int compareTo(SFBinary other) {
        if (this.equals(MAXIMUM) && Objects.equals(other, MAXIMUM)) {
            return 0;
        }
        if (this.equals(MAXIMUM)) {
            return 1;
        }
        if (Objects.equals(other, MAXIMUM)) {
            return -1;
        }
        for (int i = 0; i < this.bytes.length && i < other.bytes.length; ++i) {
            int a = this.bytes[i] & 0xFF;
            int b = other.bytes[i] & 0xFF;
            if (a > b) {
                return 1;
            }
            if (a >= b) continue;
            return -1;
        }
        return this.bytes.length - other.bytes.length;
    }

    public int hashCode() {
        if (this.equals(MAXIMUM)) {
            return 0;
        }
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object other) {
        if (this == MAXIMUM || other == MAXIMUM) {
            return this == MAXIMUM && other == MAXIMUM;
        }
        return other instanceof SFBinary && Arrays.equals(this.bytes, ((SFBinary)other).bytes);
    }

    public String toString() {
        return "SFBinary(hex=" + this.toHex() + ")";
    }

    static {
        int c;
        EMPTY = new SFBinary(new byte[0]);
        MAXIMUM = new SFBinary(null);
        byte[] temp = new byte[103];
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            temp[c] = 1;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            temp[c] = 1;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            temp[c] = 1;
        }
        temp[32] = 2;
        temp[10] = 2;
        temp[13] = 2;
        HEX_TABLE = temp;
    }
}

