/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.bigtable.BeamBigtableInputDialog;
import org.apache.hop.beam.transforms.bigtable.BigtableRowToHopRowFn;
import org.apache.hop.beam.transforms.bigtable.BigtableSourceColumn;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.Dummy;
import org.apache.hop.pipeline.transforms.dummy.DummyData;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Transform(id="BeamBigtableInput", name="i18n::BeamBigtableInput.Name", description="i18n::BeamBigtableInput.Description", image="beam-gcp-bigtable-input.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamBigtableInputMeta.keyword"}, documentationUrl="/pipeline/transforms/beambigtableinput.html")
public class BeamBigtableInputMeta
extends BaseTransformMeta<Dummy, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="project_id")
    private String projectId;
    @HopMetadataProperty(key="instance_id")
    private String instanceId;
    @HopMetadataProperty(key="table_id")
    private String tableId;
    @HopMetadataProperty(key="key_field")
    private String keyField = "key";
    @HopMetadataProperty(groupKey="columns", key="column")
    private List<BigtableSourceColumn> sourceColumns = new ArrayList<BigtableSourceColumn>();

    public String getDialogClassName() {
        return BeamBigtableInputDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String keyFieldName = variables.resolve(this.keyField);
        if (StringUtils.isNotEmpty((String)keyFieldName)) {
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString(variables.resolve(this.keyField)));
        }
        for (BigtableSourceColumn sourceColumn : this.sourceColumns) {
            try {
                inputRowMeta.addValueMeta(sourceColumn.getValueMeta());
            }
            catch (Exception e) {
                throw new HopTransformException("Error creating value metadata for Bigtable source column " + sourceColumn.getQualifier(), (Throwable)e);
            }
        }
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        JSONArray j = new JSONArray();
        for (BigtableSourceColumn column : this.sourceColumns) {
            JSONObject jc = new JSONObject();
            jc.put((Object)"qualifier", (Object)variables.resolve(column.getQualifier()));
            jc.put((Object)"target_type", (Object)variables.resolve(column.getTargetType()));
            jc.put((Object)"target_field_name", (Object)variables.resolve(column.getTargetFieldName()));
            j.add((Object)jc);
        }
        PCollection rowPCollection = (PCollection)pipeline.begin().apply(transformMeta.getName(), (PTransform)BigtableIO.read().withProjectId(variables.resolve(this.projectId)).withInstanceId(variables.resolve(this.instanceId)).withTableId(variables.resolve(this.tableId)));
        BigtableRowToHopRowFn fn = new BigtableRowToHopRowFn(transformMeta.getName(), JsonRowMeta.toJson((IRowMeta)rowMeta), variables.resolve(this.keyField), j.toJSONString());
        PCollection output = (PCollection)rowPCollection.apply((PTransform)ParDo.of((DoFn)fn));
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)output);
        log.logBasic("Handled transform (Bigtable INPUT) : " + transformMeta.getName());
    }

    public boolean isInput() {
        return true;
    }

    public boolean isOutput() {
        return false;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public List<BigtableSourceColumn> getSourceColumns() {
        return this.sourceColumns;
    }

    public void setSourceColumns(List<BigtableSourceColumn> sourceColumns) {
        this.sourceColumns = sourceColumns;
    }
}

