/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class TxMetaSerializer
extends VersionedSerializer<TxMeta> {
    public static final TxMetaSerializer INSTANCE = new TxMetaSerializer();

    protected void writeExternalData(TxMeta meta, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)meta.txState().ordinal());
        out.writeVarInt((long)meta.enlistedPartitions().size());
        for (TablePartitionId partitionId : meta.enlistedPartitions()) {
            out.writeVarInt((long)partitionId.tableId());
            out.writeVarInt((long)partitionId.partitionId());
        }
        HybridTimestamp.write((HybridTimestamp)meta.commitTimestamp(), (IgniteDataOutput)out);
    }

    protected TxMeta readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        TxState state = TxState.fromOrdinal(in.readVarIntAsInt());
        List<TablePartitionId> enlistedPartitions = TxMetaSerializer.readEnlistedPartitions(in);
        HybridTimestamp commitTimestamp = HybridTimestamp.readNullableFrom((IgniteDataInput)in);
        return new TxMeta(state, enlistedPartitions, commitTimestamp);
    }

    private static List<TablePartitionId> readEnlistedPartitions(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        ArrayList<TablePartitionId> enlistedPartitions = new ArrayList<TablePartitionId>(length);
        for (int i = 0; i < length; ++i) {
            int tableId = in.readVarIntAsInt();
            int partitionId = in.readVarIntAsInt();
            enlistedPartitions.add(new TablePartitionId(tableId, partitionId));
        }
        return enlistedPartitions;
    }
}

