/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.x509;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.token.TokenAuthenticationFetcher;
import io.micronaut.security.x509.X509Authentication;
import io.micronaut.security.x509.X509Configuration;
import jakarta.inject.Singleton;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Singleton
public class X509AuthenticationFetcher
implements AuthenticationFetcher {
    public static final int ORDER = TokenAuthenticationFetcher.ORDER - 200;
    private final Pattern subjectDnPattern;

    public X509AuthenticationFetcher(X509Configuration x509Configuration) {
        this.subjectDnPattern = Pattern.compile(x509Configuration.getSubjectDnRegex(), 2);
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        return Mono.create(emitter -> {
            Optional<Authentication> authentication = this.createAuthentication(request);
            if (authentication.isPresent()) {
                emitter.success((Object)authentication.get());
            } else {
                emitter.success();
            }
        });
    }

    @NonNull
    protected Optional<Authentication> createAuthentication(HttpRequest<?> request) {
        Certificate certificate;
        Optional optionalCertificate = request.getCertificate();
        if (optionalCertificate.isPresent() && (certificate = (Certificate)optionalCertificate.get()) instanceof X509Certificate) {
            return this.createX509Authentication((X509Certificate)certificate);
        }
        return Optional.empty();
    }

    @NonNull
    protected Optional<Authentication> createX509Authentication(@NonNull X509Certificate certificate) {
        return this.extractName(certificate).map(name -> new X509Authentication((String)name, certificate));
    }

    @NonNull
    protected Optional<String> extractName(@NonNull X509Certificate certificate) {
        String subjectDN = certificate.getSubjectX500Principal().getName();
        Matcher matcher = this.subjectDnPattern.matcher(subjectDN);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (matcher.groupCount() != 1) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(1));
    }
}

