/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util.concurrent;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.raft.jraft.util.concurrent.DefaultExecutorChooserFactory;
import org.apache.ignite3.raft.jraft.util.concurrent.DefaultSingleThreadExecutor;
import org.apache.ignite3.raft.jraft.util.concurrent.ExecutorChooserFactory;
import org.apache.ignite3.raft.jraft.util.concurrent.FixedThreadsExecutorGroup;
import org.apache.ignite3.raft.jraft.util.concurrent.SingleThreadExecutor;

public final class DefaultFixedThreadsExecutorGroup
implements FixedThreadsExecutorGroup {
    private final SingleThreadExecutor[] children;
    private final Set<SingleThreadExecutor> readonlyChildren;
    private final ExecutorChooserFactory.ExecutorChooser chooser;

    public DefaultFixedThreadsExecutorGroup(SingleThreadExecutor[] children) {
        this(children, DefaultExecutorChooserFactory.INSTANCE.newChooser(children));
    }

    public DefaultFixedThreadsExecutorGroup(SingleThreadExecutor[] children, ExecutorChooserFactory.ExecutorChooser chooser) {
        this.children = children;
        this.readonlyChildren = DefaultFixedThreadsExecutorGroup.toUnmodifiableSet(this.children);
        this.chooser = chooser;
    }

    public DefaultFixedThreadsExecutorGroup(ExecutorService[] executors) {
        this.children = DefaultFixedThreadsExecutorGroup.toSingleThreadExecutors(executors);
        this.readonlyChildren = DefaultFixedThreadsExecutorGroup.toUnmodifiableSet(this.children);
        this.chooser = DefaultExecutorChooserFactory.INSTANCE.newChooser(this.children);
    }

    public DefaultFixedThreadsExecutorGroup(ExecutorService[] executors, ExecutorChooserFactory.ExecutorChooser chooser) {
        this.children = DefaultFixedThreadsExecutorGroup.toSingleThreadExecutors(executors);
        this.readonlyChildren = DefaultFixedThreadsExecutorGroup.toUnmodifiableSet(this.children);
        this.chooser = chooser;
    }

    @Override
    public SingleThreadExecutor next() {
        return this.chooser.next();
    }

    @Override
    public void execute(int index, Runnable task) {
        this.chooser.select(index).execute(task);
    }

    @Override
    public SingleThreadExecutor select(int index) {
        return this.chooser.select(index);
    }

    @Override
    public boolean shutdownGracefully() {
        boolean success = true;
        for (SingleThreadExecutor c : this.children) {
            success = success && c.shutdownGracefully();
        }
        return success;
    }

    @Override
    public boolean shutdownGracefully(long timeout, TimeUnit unit) {
        boolean success = true;
        long timeoutNanos = unit.toNanos(timeout);
        long start = System.nanoTime();
        for (SingleThreadExecutor c : this.children) {
            boolean bl = success = success && c.shutdownGracefully(timeout, unit);
            if (System.nanoTime() - start <= timeoutNanos) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public Iterator<SingleThreadExecutor> iterator() {
        return this.readonlyChildren.iterator();
    }

    private static SingleThreadExecutor[] toSingleThreadExecutors(ExecutorService[] executors) {
        SingleThreadExecutor[] array = new SingleThreadExecutor[executors.length];
        for (int i = 0; i < executors.length; ++i) {
            array[i] = executors[i] instanceof SingleThreadExecutor ? (SingleThreadExecutor)((Object)executors[i]) : new DefaultSingleThreadExecutor(executors[i]);
        }
        return array;
    }

    private static Set<SingleThreadExecutor> toUnmodifiableSet(SingleThreadExecutor[] children) {
        LinkedHashSet tmp = new LinkedHashSet();
        Collections.addAll(tmp, children);
        return Collections.unmodifiableSet(tmp);
    }
}

