/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.managers.communication.TransmissionReceiver;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

class ChunkReceiver
extends TransmissionReceiver {
    private final Consumer<ByteBuffer> hnd;
    private ByteBuffer buf;

    public ChunkReceiver(TransmissionMeta meta, int chunkSize, BooleanSupplier stopChecker, Consumer<ByteBuffer> hnd, IgniteLogger log) {
        super(meta, stopChecker, log, chunkSize);
        A.notNull(hnd, "ChunkHandler must be provided by transmission handler");
        this.hnd = hnd;
        this.buf = ByteBuffer.allocate(chunkSize);
        this.buf.order(ByteOrder.nativeOrder());
    }

    @Override
    protected void readChunk(ReadableByteChannel ch) throws IOException {
        int res;
        assert (this.buf != null) : "Buffer cannot be null since it is used to receive the data from channel: " + this;
        this.buf.rewind();
        int read = 0;
        do {
            if ((res = ch.read(this.buf)) >= 0) continue;
            if (this.transferred + (long)read == this.meta.count()) break;
            throw new IOException("Input data channel reached its end, but file has not fully loaded [transferred=" + this.transferred + ", read=" + read + ", total=" + this.meta.count() + "]");
        } while ((read += res) != this.buf.capacity() && this.buf.position() != this.buf.capacity());
        if (read == 0) {
            return;
        }
        this.transferred += (long)read;
        this.buf.flip();
        this.hnd.accept(this.buf);
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return S.toString(ChunkReceiver.class, this, "super", (Object)super.toString());
    }
}

