/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.exception.CRDTCloseException;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.DotStore;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotStore;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.proto.Replacement;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.proto.StateLattice;
import org.apache.bifromq.basecrdt.util.Formatter;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

abstract class CausalCRDTInflater<D extends IDotStore, O extends ICRDTOperation, C extends ICausalCRDT<O>>
implements ICausalCRDTInflater<O, C> {
    private final Logger log;
    private final AtomicBoolean inflationScheduled = new AtomicBoolean(false);
    private final AtomicBoolean compactionScheduled = new AtomicBoolean(false);
    private final AtomicBoolean taskExecuting = new AtomicBoolean(false);
    private final AtomicReference<CompletableFuture<Void>> stopSignal = new AtomicReference();
    private final Replica replica;
    private final IReplicaStateLattice replicaStateLattice;
    private final ScheduledExecutorService executor;
    private final Duration inflationInterval;
    private final D dotStore;
    private final C crdt;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final MetricManager metricManager;
    private volatile ScheduledFuture<?> compactionTask;
    private volatile OperationExecTask currentOp = null;
    private volatile JoinTask currentJoin = null;

    CausalCRDTInflater(String storeId, Replica replica, IReplicaStateLattice stateLattice, ScheduledExecutorService executor, Duration inflationInterval, String ... tags) {
        this.replica = replica;
        this.log = MDCLogger.getLogger(CausalCRDTInflater.class, (String[])new String[]{"store", storeId, "replica", Formatter.print(replica)});
        this.replicaStateLattice = stateLattice;
        this.executor = executor;
        this.inflationInterval = inflationInterval;
        this.metricManager = new MetricManager(Tags.of((String[])tags).and("replica.uri", replica.getUri()).and("replica.id", Base64.getEncoder().encodeToString(replica.getId().toByteArray())));
        try {
            this.dotStore = (IDotStore)this.dotStoreType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.crdt = this.newCRDT(replica, this.dotStore, this::execute);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unknown dot store implementation", e);
        }
        stateLattice.lattices().forEachRemaining(causalState -> ((DotStore)this.dotStore).add((StateLattice)causalState));
    }

    @Override
    public abstract CausalCRDTType type();

    @Override
    public final C getCRDT() {
        return this.crdt;
    }

    @Override
    public final Replica id() {
        return this.replica;
    }

    @Override
    public final CompletableFuture<Void> stop() {
        CompletableFuture<Void> onStop = this.stopSignal.updateAndGet(current -> {
            if (current == null) {
                return new CompletableFuture();
            }
            return current;
        });
        this.scheduleInflation();
        this.metricManager.close();
        return onStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompletableFuture<Void> join(Iterable<Replacement> delta) {
        CompletableFuture<Void> ret;
        if (this.stopSignal.get() != null) {
            return CompletableFuture.completedFuture(null);
        }
        CausalCRDTInflater causalCRDTInflater = this;
        synchronized (causalCRDTInflater) {
            if (this.currentJoin == null) {
                this.currentJoin = new JoinTask(delta, new CompletableFuture<Void>());
            } else {
                this.currentJoin.add(delta);
            }
            ret = this.currentJoin.onDone;
        }
        this.scheduleInflation();
        return ret;
    }

    @Override
    public final CompletableFuture<Optional<Iterable<Replacement>>> delta(Map<ByteString, NavigableMap<Long, Long>> coveredLatticeEvents, Map<ByteString, NavigableMap<Long, Long>> coveredHistoryEvents, int maxEvents) {
        CompletableFuture<Optional<Iterable<Replacement>>> onDone = new CompletableFuture<Optional<Iterable<Replacement>>>();
        this.submitTask(() -> {
            Timer.Sample sample = Timer.start();
            onDone.complete(this.replicaStateLattice.delta(coveredLatticeEvents, coveredHistoryEvents, maxEvents));
            sample.stop(this.metricManager.deltaTimer);
        });
        return onDone;
    }

    @Override
    public final Map<ByteString, NavigableMap<Long, Long>> latticeEvents() {
        return this.replicaStateLattice.latticeIndex();
    }

    @Override
    public final Map<ByteString, NavigableMap<Long, Long>> historyEvents() {
        return this.replicaStateLattice.historyIndex();
    }

    abstract C newCRDT(Replica var1, D var2, CausalCRDT.CRDTOperationExecutor<O> var3);

    abstract ICoalesceOperation<D, O> startCoalescing(O var1);

    abstract Class<? extends D> dotStoreType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> execute(O op) {
        CompletableFuture<Void> ret;
        if (this.stopSignal.get() != null) {
            return CompletableFuture.failedFuture(new CRDTCloseException());
        }
        CausalCRDTInflater causalCRDTInflater = this;
        synchronized (causalCRDTInflater) {
            if (this.currentOp == null) {
                this.currentOp = new OperationExecTask(this, op, new CompletableFuture());
            } else {
                this.currentOp.coalesce(op);
            }
            ret = this.currentOp.onDone;
        }
        this.scheduleInflation();
        return ret;
    }

    private void submitTask(Runnable task) {
        this.taskQueue.add(task);
        this.startExecutor();
    }

    private void startExecutor() {
        if (this.taskExecuting.compareAndSet(false, true)) {
            this.executor.execute(() -> {
                try {
                    while (!this.taskQueue.isEmpty()) {
                        Runnable task = this.taskQueue.poll();
                        task.run();
                        Thread.yield();
                    }
                }
                catch (Throwable e) {
                    this.log.error("Failed to execute inflater[{}] task", Formatter.toPrintable(this.replica), (Object)e);
                }
                this.taskExecuting.set(false);
                if (!this.taskQueue.isEmpty()) {
                    this.startExecutor();
                }
            });
        }
    }

    private void scheduleInflation() {
        if (this.inflationScheduled.compareAndSet(false, true)) {
            Runnable task = () -> this.submitTask(() -> {
                try {
                    this.inflate();
                    this.scheduleCompaction();
                }
                catch (Throwable e) {
                    this.log.error("Inflation[{}] error", Formatter.toPrintable(this.replica), (Object)e);
                }
                finally {
                    this.inflationScheduled.set(false);
                }
                if (this.currentOp != null || this.currentJoin != null) {
                    this.scheduleInflation();
                } else if (this.stopSignal.get() != null) {
                    if (this.compactionTask != null) {
                        this.compactionTask.cancel(true);
                    }
                    this.stopSignal.get().complete(null);
                }
            });
            this.executor.schedule(task, this.inflationInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void scheduleCompaction() {
        if (this.compactionScheduled.compareAndSet(false, true)) {
            this.compactionTask = this.executor.schedule(() -> this.submitTask(() -> {
                Timer.Sample sample = Timer.start();
                if (this.replicaStateLattice.compact() && this.stopSignal.get() == null) {
                    this.compactionScheduled.set(false);
                    this.scheduleCompaction();
                } else {
                    this.compactionScheduled.set(false);
                }
                sample.stop(this.metricManager.compactionTimer);
            }), this.replicaStateLattice.historyDuration().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflate() {
        JoinTask joinTask;
        Timer.Sample sample = Timer.start();
        List<Replacement> deltas = null;
        Optional<JoinTask> opTask = this.buildOpTask();
        if (opTask.isPresent()) {
            deltas = opTask.get().deltas;
        }
        CausalCRDTInflater causalCRDTInflater = this;
        synchronized (causalCRDTInflater) {
            joinTask = this.currentJoin;
            this.currentJoin = null;
        }
        if (joinTask != null) {
            if (deltas == null) {
                deltas = joinTask.deltas;
            } else {
                deltas.addAll(joinTask.deltas);
            }
        }
        if (deltas != null) {
            IReplicaStateLattice.JoinDiff joinDiff = this.replicaStateLattice.join(deltas);
            ArrayList adds = Lists.newArrayList();
            ArrayList rems = Lists.newArrayList();
            for (StateLattice lattice : joinDiff.adds()) {
                if (!((DotStore)this.dotStore).add(lattice)) continue;
                adds.add(lattice);
            }
            for (StateLattice lattice : joinDiff.removes()) {
                if (!((DotStore)this.dotStore).remove(lattice)) continue;
                rems.add(lattice);
            }
            if (!adds.isEmpty() || !rems.isEmpty()) {
                ((CausalCRDT)this.crdt).afterInflation(adds, rems);
            }
        }
        sample.stop(this.metricManager.inflationTimer);
        if (opTask.isPresent()) {
            opTask.get().onDone.complete(null);
        }
        if (joinTask != null) {
            joinTask.onDone.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<JoinTask> buildOpTask() {
        OperationExecTask task;
        CausalCRDTInflater causalCRDTInflater = this;
        synchronized (causalCRDTInflater) {
            task = this.currentOp;
            this.currentOp = null;
        }
        if (task != null) {
            JoinTask joinTask = new JoinTask(task.op.delta(this.dotStore, this.replicaStateLattice::nextEvent), new CompletableFuture<Void>());
            joinTask.onDone.whenComplete((v, e) -> task.onDone.complete(null));
            return Optional.of(joinTask);
        }
        return Optional.empty();
    }

    private static class OperationExecTask {
        private final CompletableFuture<Void> onDone;
        private final ICoalesceOperation<D, O> op;
        final /* synthetic */ CausalCRDTInflater this$0;

        OperationExecTask(O op, CompletableFuture<Void> onDone) {
            this.this$0 = var1_1;
            this.op = var1_1.startCoalescing(op);
            this.onDone = onDone;
        }

        public void coalesce(O next) {
            this.op.coalesce(next);
        }
    }

    private static class JoinTask {
        public final List<Replacement> deltas = Lists.newLinkedList();
        public final CompletableFuture<Void> onDone;

        JoinTask(Iterable<Replacement> delta, CompletableFuture<Void> onDone) {
            delta.forEach(this.deltas::add);
            this.onDone = onDone;
        }

        public void add(Iterable<Replacement> next) {
            next.forEach(this.deltas::add);
        }
    }

    private class MetricManager {
        public final Timer inflationTimer;
        public final Timer deltaTimer;
        public final Timer compactionTimer;
        public final Gauge eventSizeGauge;

        MetricManager(Tags tags) {
            this.inflationTimer = Metrics.timer((String)"basecrdt.inflation.time", (Iterable)tags);
            this.deltaTimer = Metrics.timer((String)"basecrdt.delta.time", (Iterable)tags);
            this.compactionTimer = Metrics.timer((String)"basecrdt.compact.time", (Iterable)tags);
            this.eventSizeGauge = Gauge.builder((String)"basecrdt.event.size", CausalCRDTInflater.this.replicaStateLattice::size).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        void close() {
            Metrics.globalRegistry.remove(this.inflationTimer.getId());
            Metrics.globalRegistry.remove(this.deltaTimer.getId());
            Metrics.globalRegistry.remove(this.compactionTimer.getId());
            Metrics.globalRegistry.remove((Meter)this.eventSizeGauge);
        }
    }
}

