/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.server;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.sessiondict.rpc.proto.ServerRedirection;
import org.apache.bifromq.sessiondict.server.ISessionRegister;
import org.apache.bifromq.sessiondict.server.ISessionRegistry;
import org.apache.bifromq.sessiondict.server.MqttClientKey;
import org.apache.bifromq.type.ClientInfo;

class SessionRegistry
implements ISessionRegistry {
    private static final ServerRedirection NO_MOVE = ServerRedirection.newBuilder().setType(ServerRedirection.Type.NO_MOVE).build();
    static Comparator<MqttClientKey> ClientKeyComparator = (key1, key2) -> Comparator.comparing(MqttClientKey::userId).thenComparing(MqttClientKey::clientId).compare((MqttClientKey)key1, (MqttClientKey)key2);
    private static final NavigableMap<MqttClientKey, ClientInfo> EMPTY_MAP = new TreeMap<MqttClientKey, ClientInfo>(ClientKeyComparator);
    private final Map<String, NavigableMap<MqttClientKey, ClientInfo>> tenantSessions = Maps.newConcurrentMap();
    private final Map<String, SessionCounter> sessionCounters = Maps.newConcurrentMap();
    private final Map<ClientInfo, ISessionRegister> clientRegisterMap = Maps.newConcurrentMap();

    SessionRegistry() {
    }

    @Override
    public void add(ClientInfo sessionOwner, ISessionRegister register) {
        String tenantId = sessionOwner.getTenantId();
        MqttClientKey clientKey = MqttClientKey.from(sessionOwner);
        this.tenantSessions.compute(tenantId, (k, v) -> {
            ClientInfo prevSessionOwner;
            if (v == null) {
                v = new ConcurrentSkipListMap<MqttClientKey, ClientInfo>(ClientKeyComparator);
                SessionCounter sessionCounter = new SessionCounter();
                this.sessionCounters.put(tenantId, sessionCounter);
                ITenantMeter.gauging((String)tenantId, (TenantMetric)TenantMetric.MqttConnectionGauge, sessionCounter.total::get, (String[])new String[0]);
                ITenantMeter.gauging((String)tenantId, (TenantMetric)TenantMetric.MqttLivePersistentSessionGauge, sessionCounter.persistent::get, (String[])new String[0]);
            }
            if ((prevSessionOwner = v.put(clientKey, sessionOwner)) != null) {
                if (!prevSessionOwner.equals((Object)sessionOwner)) {
                    ISessionRegister prevSessionRegister = this.clientRegisterMap.remove(prevSessionOwner);
                    this.clientRegisterMap.put(sessionOwner, register);
                    assert (prevSessionRegister != null);
                    prevSessionRegister.kick(tenantId, prevSessionOwner, sessionOwner, NO_MOVE);
                    if (this.isPersistent(sessionOwner) && !this.isPersistent(prevSessionOwner)) {
                        SessionCounter sessionCounter = this.sessionCounters.get(tenantId);
                        sessionCounter.persistent.incrementAndGet();
                    } else if (!this.isPersistent(sessionOwner) && this.isPersistent(prevSessionOwner)) {
                        SessionCounter sessionCounter = this.sessionCounters.get(tenantId);
                        sessionCounter.persistent.decrementAndGet();
                    }
                } else {
                    ISessionRegister prevSessionRegister = this.clientRegisterMap.put(sessionOwner, register);
                    if (prevSessionRegister != null && prevSessionRegister != register) {
                        prevSessionRegister.kick(tenantId, prevSessionOwner, sessionOwner, NO_MOVE);
                    }
                }
            } else {
                this.clientRegisterMap.put(sessionOwner, register);
                SessionCounter sessionCounter = this.sessionCounters.get(tenantId);
                sessionCounter.total.incrementAndGet();
                if (this.isPersistent(sessionOwner)) {
                    sessionCounter.persistent.incrementAndGet();
                }
            }
            return v;
        });
    }

    @Override
    public void remove(ClientInfo sessionOwner, ISessionRegister register) {
        String tenantId = sessionOwner.getTenantId();
        MqttClientKey clientKey = MqttClientKey.from(sessionOwner);
        this.tenantSessions.computeIfPresent(tenantId, (k, v) -> {
            boolean s1 = v.remove(clientKey, sessionOwner);
            boolean s2 = this.clientRegisterMap.remove(sessionOwner, register);
            if (s1) {
                SessionCounter sessionCounter = this.sessionCounters.get(tenantId);
                sessionCounter.total.decrementAndGet();
                if (this.isPersistent(sessionOwner)) {
                    sessionCounter.persistent.decrementAndGet();
                }
            }
            if (v.isEmpty()) {
                this.sessionCounters.remove(k);
                ITenantMeter.stopGauging((String)tenantId, (TenantMetric)TenantMetric.MqttConnectionGauge, (String[])new String[0]);
                ITenantMeter.stopGauging((String)tenantId, (TenantMetric)TenantMetric.MqttLivePersistentSessionGauge, (String[])new String[0]);
                return null;
            }
            return v;
        });
    }

    @Override
    public Optional<ClientInfo> get(String tenantId, String userId, String mqttClientId) {
        return Optional.ofNullable((ClientInfo)this.tenantSessions.getOrDefault(tenantId, EMPTY_MAP).get(new MqttClientKey(userId, mqttClientId)));
    }

    @Override
    public Optional<ISessionRegistry.SessionRegistration> findRegistration(String tenantId, String userId, String mqttClientId) {
        ISessionRegister sessionRegister;
        Optional<ClientInfo> sessionOwner = this.get(tenantId, userId, mqttClientId);
        if (sessionOwner.isPresent() && (sessionRegister = this.clientRegisterMap.get(sessionOwner.get())) != null) {
            return Optional.of(new ISessionRegistry.SessionRegistration(sessionOwner.get(), this.clientRegisterMap.get(sessionOwner.get())));
        }
        return Optional.empty();
    }

    @Override
    public Iterable<ISessionRegistry.SessionRegistration> findRegistrations(final String tenantId, final String userId) {
        return () -> new AbstractIterator<ISessionRegistry.SessionRegistration>(){
            private final MqttClientKey fromKey;
            private final MqttClientKey toKey;
            private final Iterator<ClientInfo> sessionOwners;
            {
                this.fromKey = new MqttClientKey(userId, "");
                this.toKey = new MqttClientKey(userId + "\u0000", "");
                this.sessionOwners = SessionRegistry.this.tenantSessions.getOrDefault(tenantId, EMPTY_MAP).subMap(this.fromKey, true, this.toKey, false).values().iterator();
            }

            protected ISessionRegistry.SessionRegistration computeNext() {
                if (this.sessionOwners.hasNext()) {
                    ClientInfo sessionOwner = this.sessionOwners.next();
                    ISessionRegister sessionRegister = SessionRegistry.this.clientRegisterMap.get(sessionOwner);
                    if (sessionRegister != null) {
                        return new ISessionRegistry.SessionRegistration(sessionOwner, sessionRegister);
                    }
                    return this.computeNext();
                }
                return (ISessionRegistry.SessionRegistration)this.endOfData();
            }
        };
    }

    @Override
    public Iterable<ISessionRegistry.SessionRegistration> findRegistrations(final String tenantId) {
        return () -> new AbstractIterator<ISessionRegistry.SessionRegistration>(){
            private final Iterator<ClientInfo> sessionOwners;
            {
                this.sessionOwners = SessionRegistry.this.tenantSessions.getOrDefault(tenantId, EMPTY_MAP).values().iterator();
            }

            protected ISessionRegistry.SessionRegistration computeNext() {
                if (this.sessionOwners.hasNext()) {
                    ClientInfo sessionOwner = this.sessionOwners.next();
                    ISessionRegister sessionRegister = SessionRegistry.this.clientRegisterMap.get(sessionOwner);
                    if (sessionRegister != null) {
                        return new ISessionRegistry.SessionRegistration(sessionOwner, sessionRegister);
                    }
                    return this.computeNext();
                }
                return (ISessionRegistry.SessionRegistration)this.endOfData();
            }
        };
    }

    @Override
    public void close() {
        for (String tenantId : this.tenantSessions.keySet()) {
            ITenantMeter.stopGauging((String)tenantId, (TenantMetric)TenantMetric.MqttConnectionGauge, (String[])new String[0]);
            ITenantMeter.stopGauging((String)tenantId, (TenantMetric)TenantMetric.MqttLivePersistentSessionGauge, (String[])new String[0]);
        }
    }

    private boolean isPersistent(ClientInfo sessionOwner) {
        return sessionOwner.getMetadataOrDefault("sessionType", "t").equals("p");
    }

    private static class SessionCounter {
        private final AtomicInteger total = new AtomicInteger();
        private final AtomicInteger persistent = new AtomicInteger();

        private SessionCounter() {
        }
    }
}

