/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.BranchTable;
import org.apache.bifromq.util.index.EmptyBranchTable;
import org.apache.bifromq.util.index.INode;
import org.apache.bifromq.util.index.MainNode;
import org.apache.bifromq.util.index.PMapBranchTable;
import org.apache.bifromq.util.index.ShardedBranchTable;
import org.apache.bifromq.util.index.ValueStrategy;
import org.pcollections.PMap;

public class CNode<V> {
    private static final int SHARDING_THRESHOLD = 8192;
    private static final int DEFAULT_SEG_BITS = 3;
    private static final int DEFAULT_SHARD_BITS = 8;
    private final ValueStrategy<V> strategy;
    BranchTable<V> table;

    CNode(ValueStrategy<V> strategy) {
        this.table = EmptyBranchTable.empty();
        this.strategy = strategy;
    }

    CNode(BranchTable<V> table, ValueStrategy<V> strategy) {
        this.table = table;
        this.strategy = strategy;
    }

    CNode(List<String> topicLevels, V value, ValueStrategy<V> strategy) {
        this(strategy);
        if (topicLevels.size() == 1) {
            this.table = this.table.plus(topicLevels.get(0), new Branch<V>(value, strategy));
        } else {
            INode<V> nin = new INode<V>(new MainNode<V>(new CNode<V>(topicLevels.subList(1, topicLevels.size()), value, strategy)));
            this.table = this.table.plus(topicLevels.get(0), new Branch<INode<V>>(nin, strategy));
        }
        this.table = this.maybeShard(this.table);
    }

    CNode<V> inserted(List<String> topicLevels, V value) {
        BranchTable<Object> newTable = this.table;
        if (topicLevels.size() == 1) {
            newTable = newTable.plus(topicLevels.get(0), new Branch<V>(value, this.strategy));
        } else {
            INode<V> nin = new INode<V>(new MainNode<V>(new CNode<V>(topicLevels.subList(1, topicLevels.size()), value, this.strategy)));
            newTable = newTable.plus(topicLevels.get(0), new Branch<INode<V>>(nin, this.strategy));
        }
        return new CNode<V>(this.maybeShard(newTable), this.strategy);
    }

    CNode<V> updatedBranch(String topicLevel, INode<V> iNode, Branch<V> br) {
        BranchTable<INode<V>> newTable = this.table.plus(topicLevel, br.updated(iNode));
        return new CNode<INode<V>>(this.maybeShard(newTable), this.strategy);
    }

    CNode<V> updated(String topicLevel, V value) {
        BranchTable<V> newTable = this.table;
        Branch<V> br = newTable.get(topicLevel);
        newTable = br != null ? newTable.plus(topicLevel, br.updated(value)) : newTable.plus(topicLevel, new Branch<V>(value, this.strategy));
        return new CNode<V>(this.maybeShard(newTable), this.strategy);
    }

    CNode<V> removed(String topicLevel, V value) {
        BranchTable<V> newTable = this.table;
        Branch<V> br = newTable.get(topicLevel);
        if (br != null) {
            Branch<V> updatedBranch = br.removed(value);
            newTable = updatedBranch.values.isEmpty() && updatedBranch.iNode == null ? newTable.minus(topicLevel) : newTable.plus(topicLevel, updatedBranch);
        }
        return new CNode<V>(newTable, this.strategy);
    }

    Map<String, Branch<V>> branches() {
        return this.table.asMapView();
    }

    int branchCount() {
        return this.table.size();
    }

    private BranchTable<V> maybeShard(BranchTable<V> t) {
        if (t instanceof PMapBranchTable) {
            PMapBranchTable pm = (PMapBranchTable)t;
            if (t.size() > 8192) {
                return ShardedBranchTable.from((PMap)pm.asMapView(), 8, 3);
            }
        }
        return t;
    }

    @Generated
    public String toString() {
        return "CNode(strategy=" + String.valueOf(this.strategy) + ", table=" + String.valueOf(this.table) + ")";
    }
}

