/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.trafficgovernor;

import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;

public class NameUtil {
    private static final String PREFIX_RPC = "RPC:";

    static String toLandscapeURI(String serviceUniqueName) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)(PREFIX_RPC + serviceUniqueName));
    }

    static boolean isLandscapeURI(String crdtURI) {
        if (!CRDTURI.isValidURI((String)crdtURI)) {
            return false;
        }
        CausalCRDTType type = CRDTURI.parseType((String)crdtURI);
        String name = CRDTURI.parseName((String)crdtURI);
        return type == CausalCRDTType.ormap && name.startsWith(PREFIX_RPC);
    }

    static String parseServiceUniqueName(String landscapeURI) {
        assert (NameUtil.isLandscapeURI(landscapeURI));
        return CRDTURI.parseName((String)landscapeURI).substring(PREFIX_RPC.length());
    }
}

