/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.api.IKVWriter;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.record.InboxInstance;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.storage.proto.BatchAttachReply;
import org.apache.bifromq.inbox.storage.proto.BatchAttachRequest;
import org.apache.bifromq.inbox.storage.proto.BatchCheckSubReply;
import org.apache.bifromq.inbox.storage.proto.BatchCheckSubRequest;
import org.apache.bifromq.inbox.storage.proto.BatchCommitReply;
import org.apache.bifromq.inbox.storage.proto.BatchCommitRequest;
import org.apache.bifromq.inbox.storage.proto.BatchDeleteReply;
import org.apache.bifromq.inbox.storage.proto.BatchDeleteRequest;
import org.apache.bifromq.inbox.storage.proto.BatchDetachReply;
import org.apache.bifromq.inbox.storage.proto.BatchDetachRequest;
import org.apache.bifromq.inbox.storage.proto.BatchExistReply;
import org.apache.bifromq.inbox.storage.proto.BatchExistRequest;
import org.apache.bifromq.inbox.storage.proto.BatchFetchInboxStateReply;
import org.apache.bifromq.inbox.storage.proto.BatchFetchInboxStateRequest;
import org.apache.bifromq.inbox.storage.proto.BatchFetchReply;
import org.apache.bifromq.inbox.storage.proto.BatchFetchRequest;
import org.apache.bifromq.inbox.storage.proto.BatchInsertReply;
import org.apache.bifromq.inbox.storage.proto.BatchInsertRequest;
import org.apache.bifromq.inbox.storage.proto.BatchSendLWTReply;
import org.apache.bifromq.inbox.storage.proto.BatchSendLWTRequest;
import org.apache.bifromq.inbox.storage.proto.BatchSubReply;
import org.apache.bifromq.inbox.storage.proto.BatchSubRequest;
import org.apache.bifromq.inbox.storage.proto.BatchUnsubReply;
import org.apache.bifromq.inbox.storage.proto.BatchUnsubRequest;
import org.apache.bifromq.inbox.storage.proto.ExpireTenantReply;
import org.apache.bifromq.inbox.storage.proto.ExpireTenantRequest;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.apache.bifromq.inbox.storage.proto.GCReply;
import org.apache.bifromq.inbox.storage.proto.GCRequest;
import org.apache.bifromq.inbox.storage.proto.InboxMessage;
import org.apache.bifromq.inbox.storage.proto.InboxMessageList;
import org.apache.bifromq.inbox.storage.proto.InboxMetadata;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcOutput;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcOutput;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.InsertRequest;
import org.apache.bifromq.inbox.storage.proto.InsertResult;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.inbox.storage.proto.MatchedRoute;
import org.apache.bifromq.inbox.storage.proto.SubMessagePack;
import org.apache.bifromq.inbox.store.IInboxMetaCache;
import org.apache.bifromq.inbox.store.ITenantStats;
import org.apache.bifromq.inbox.store.InboxMetaCache;
import org.apache.bifromq.inbox.store.TenantsStats;
import org.apache.bifromq.inbox.store.canon.TenantIdCanon;
import org.apache.bifromq.inbox.store.delay.DelayTaskRunner;
import org.apache.bifromq.inbox.store.delay.ExpireInboxTask;
import org.apache.bifromq.inbox.store.delay.IDelayTaskRunner;
import org.apache.bifromq.inbox.store.delay.SendLWTTask;
import org.apache.bifromq.inbox.store.schema.KVSchemaUtil;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.inboxservice.Overflowed;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.WillDistError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.WillDisted;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.DropReason;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS0Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS1Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.MsgRetained;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.MsgRetainedError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.retainhandling.RetainMsgCleared;
import org.apache.bifromq.plugin.eventcollector.session.MQTTSessionStart;
import org.apache.bifromq.plugin.eventcollector.session.MQTTSessionStop;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.retain.rpc.proto.RetainReply;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckRequest;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckResult;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.InboxState;
import org.apache.bifromq.type.LastWillInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.TopicFilterOption;
import org.apache.bifromq.type.TopicMessage;
import org.apache.bifromq.type.TopicMessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InboxStoreCoProc
implements IKVRangeCoProc {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxStoreCoProc.class);
    private static final int UINT_MAX = -1;
    private final IDistClient distClient;
    private final IRetainClient retainClient;
    private final IInboxClient inboxClient;
    private final ISessionDictClient sessionDictClient;
    private final ISettingProvider settingProvider;
    private final IEventCollector eventCollector;
    private final IResourceThrottler resourceThrottler;
    private final IInboxMetaCache inboxMetaCache;
    private final ITenantStats tenantStats;
    private final IDelayTaskRunner<TenantInboxInstance> delayTaskRunner;
    private final Duration detachTimeout;

    InboxStoreCoProc(String clusterId, String storeId, KVRangeId id, IDistClient distClient, IInboxClient inboxClient, IRetainClient retainClient, ISessionDictClient sessionDictClient, ISettingProvider settingProvider, IEventCollector eventCollector, IResourceThrottler resourceThrottler, Supplier<IKVRangeRefreshableReader> rangeReaderProvider, Duration detachTimeout, Duration metaCacheExpireTime, int expireRateLimit) {
        this.distClient = distClient;
        this.retainClient = retainClient;
        this.inboxClient = inboxClient;
        this.sessionDictClient = sessionDictClient;
        this.settingProvider = settingProvider;
        this.eventCollector = eventCollector;
        this.resourceThrottler = resourceThrottler;
        this.inboxMetaCache = new InboxMetaCache(metaCacheExpireTime);
        this.tenantStats = new TenantsStats(rangeReaderProvider, "clusterId", clusterId, "storeId", storeId, "rangeId", KVRangeIdUtil.toString((KVRangeId)id));
        this.delayTaskRunner = new DelayTaskRunner<TenantInboxInstance>(TenantInboxInstance::compareTo, () -> ((HLC)HLC.INST).getPhysical(), expireRateLimit);
        this.detachTimeout = detachTimeout;
    }

    private static int getExpireSeconds(Duration expireTime, InboxMetadata latestInboxMetadata) {
        int newExpireSeconds = (int)expireTime.toSeconds();
        int expireSeconds = Integer.compareUnsigned(latestInboxMetadata.getExpirySeconds(), -1) == 0 ? (newExpireSeconds > 0 ? newExpireSeconds : -1) : (newExpireSeconds > 0 ? (Integer.compareUnsigned(latestInboxMetadata.getExpirySeconds(), newExpireSeconds) < 0 ? latestInboxMetadata.getExpirySeconds() : newExpireSeconds) : latestInboxMetadata.getExpirySeconds());
        return expireSeconds;
    }

    public CompletableFuture<ROCoProcOutput> query(ROCoProcInput input, IKVRangeReader reader) {
        try {
            InboxServiceROCoProcInput coProcInput = input.getInboxService();
            InboxServiceROCoProcOutput.Builder outputBuilder = InboxServiceROCoProcOutput.newBuilder().setReqId(coProcInput.getReqId());
            return ((CompletableFuture)(switch (coProcInput.getInputCase()) {
                case InboxServiceROCoProcInput.InputCase.BATCHEXIST -> this.batchExist(coProcInput.getBatchExist(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setBatchExist(arg_0));
                case InboxServiceROCoProcInput.InputCase.BATCHFETCH -> this.batchFetch(coProcInput.getBatchFetch(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setBatchFetch(arg_0));
                case InboxServiceROCoProcInput.InputCase.BATCHCHECKSUB -> this.batchCheckSub(coProcInput.getBatchCheckSub(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setBatchCheckSub(arg_0));
                case InboxServiceROCoProcInput.InputCase.GC -> this.gc(coProcInput.getGc(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setGc(arg_0));
                case InboxServiceROCoProcInput.InputCase.EXPIRETENANT -> this.expireTenant(coProcInput.getExpireTenant(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setExpireTenant(arg_0));
                case InboxServiceROCoProcInput.InputCase.FETCHINBOXSTATE -> this.batchFetchInboxState(coProcInput.getFetchInboxState(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setFetchInboxState(arg_0));
                default -> this.batchSendLWT(coProcInput.getBatchSendLWT(), reader).thenApply(arg_0 -> ((InboxServiceROCoProcOutput.Builder)outputBuilder).setBatchSendLWT(arg_0));
            })).thenApply(o -> ROCoProcOutput.newBuilder().setInboxService(o.build()).build());
        }
        catch (Throwable e) {
            log.error("Query co-proc failed", e);
            return CompletableFuture.failedFuture(new IllegalStateException("Query co-proc failed", e));
        }
    }

    public Supplier<IKVRangeCoProc.MutationResult> mutate(RWCoProcInput input, IKVRangeReader reader, IKVWriter writer, boolean isLeader) {
        InboxServiceRWCoProcInput coProcInput = input.getInboxService();
        InboxServiceRWCoProcOutput.Builder outputBuilder = InboxServiceRWCoProcOutput.newBuilder().setReqId(coProcInput.getReqId());
        AtomicReference<Runnable> afterMutate = new AtomicReference<Runnable>();
        switch (coProcInput.getTypeCase()) {
            case BATCHATTACH: {
                BatchAttachReply.Builder replyBuilder = BatchAttachReply.newBuilder();
                afterMutate.set(this.batchAttach(coProcInput.getBatchAttach(), replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchAttach(replyBuilder);
                break;
            }
            case BATCHDETACH: {
                BatchAttachReply.Builder replyBuilder = BatchDetachReply.newBuilder();
                afterMutate.set(this.batchDetach(coProcInput.getBatchDetach(), (BatchDetachReply.Builder)replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchDetach((BatchDetachReply.Builder)replyBuilder);
                break;
            }
            case BATCHDELETE: {
                BatchAttachReply.Builder replyBuilder = BatchDeleteReply.newBuilder();
                afterMutate.set(this.batchDelete(coProcInput.getBatchDelete(), (BatchDeleteReply.Builder)replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchDelete(replyBuilder.build());
                break;
            }
            case BATCHSUB: {
                BatchAttachReply.Builder replyBuilder = BatchSubReply.newBuilder();
                afterMutate.set(this.batchSub(coProcInput.getBatchSub(), (BatchSubReply.Builder)replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchSub((BatchSubReply.Builder)replyBuilder);
                break;
            }
            case BATCHUNSUB: {
                BatchAttachReply.Builder replyBuilder = BatchUnsubReply.newBuilder();
                afterMutate.set(this.batchUnsub(coProcInput.getBatchUnsub(), (BatchUnsubReply.Builder)replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchUnsub((BatchUnsubReply.Builder)replyBuilder);
                break;
            }
            case BATCHINSERT: {
                BatchAttachReply.Builder replyBuilder = BatchInsertReply.newBuilder();
                afterMutate.set(this.batchInsert(coProcInput.getBatchInsert(), (BatchInsertReply.Builder)replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchInsert((BatchInsertReply.Builder)replyBuilder);
                break;
            }
            case BATCHCOMMIT: {
                BatchAttachReply.Builder replyBuilder = BatchCommitReply.newBuilder();
                afterMutate.set(this.batchCommit(coProcInput.getBatchCommit(), (BatchCommitReply.Builder)replyBuilder, isLeader, reader, writer));
                outputBuilder.setBatchCommit((BatchCommitReply.Builder)replyBuilder);
                break;
            }
        }
        RWCoProcOutput output = RWCoProcOutput.newBuilder().setInboxService(outputBuilder.build()).build();
        return () -> {
            ((Runnable)afterMutate.get()).run();
            return new IKVRangeCoProc.MutationResult(output, Optional.empty());
        };
    }

    public Any reset(Boundary boundary) {
        this.inboxMetaCache.reset(boundary);
        this.tenantStats.reset(boundary);
        return Any.getDefaultInstance();
    }

    public void onLeader(boolean isLeader) {
        this.tenantStats.toggleMetering(isLeader);
    }

    public void close() {
        this.inboxMetaCache.close();
        this.tenantStats.close();
        this.delayTaskRunner.shutdown();
    }

    private CompletableFuture<BatchExistReply> batchExist(BatchExistRequest request, IKVRangeReader reader) {
        BatchExistReply.Builder replyBuilder = BatchExistReply.newBuilder();
        for (BatchExistRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> latest = this.getLatestInboxVersion(params.getTenantId(), params.getInboxId(), reader);
            replyBuilder.addExist(latest.isPresent() && !this.hasExpired(latest.get(), params.getNow()));
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    private CompletableFuture<BatchCheckSubReply> batchCheckSub(BatchCheckSubRequest request, IKVRangeReader reader) {
        BatchCheckSubReply.Builder replyBuilder = BatchCheckSubReply.newBuilder();
        for (BatchCheckSubRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addCode(BatchCheckSubReply.Code.NO_INBOX);
                continue;
            }
            if (this.hasExpired(metadataOpt.get(), request.getNow())) {
                replyBuilder.addCode(BatchCheckSubReply.Code.NO_INBOX);
                continue;
            }
            InboxMetadata metadata = metadataOpt.get();
            if (metadata.containsTopicFilters(params.getTopicFilter())) {
                replyBuilder.addCode(BatchCheckSubReply.Code.OK);
                continue;
            }
            replyBuilder.addCode(BatchCheckSubReply.Code.NO_MATCH);
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    private CompletableFuture<BatchFetchReply> batchFetch(BatchFetchRequest request, IKVRangeReader reader) {
        BatchFetchReply.Builder replyBuilder = BatchFetchReply.newBuilder();
        for (BatchFetchRequest.Params params : request.getParamsList()) {
            replyBuilder.addResult(this.fetch(params, reader));
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    private Fetched fetch(BatchFetchRequest.Params params, IKVRangeReader reader) {
        Fetched.Builder replyBuilder = Fetched.newBuilder();
        Optional<InboxMetadata> inboxMetadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getIncarnation(), this.inboxMetadataProvider(reader));
        if (inboxMetadataOpt.isEmpty()) {
            replyBuilder.setResult(Fetched.Result.NO_INBOX);
            return replyBuilder.build();
        }
        InboxMetadata metadata = inboxMetadataOpt.get();
        ByteString inboxInstStartKey = KVSchemaUtil.inboxInstanceStartKey((String)params.getTenantId(), (String)params.getInboxId(), (long)params.getIncarnation());
        long startFetchFromSeq = !params.hasQos0StartAfter() ? metadata.getQos0StartSeq() : Math.max(params.getQos0StartAfter() + 1L, metadata.getQos0StartSeq());
        this.fetchFromInbox(inboxInstStartKey, Integer.MAX_VALUE, metadata.getQos0StartSeq(), startFetchFromSeq, metadata.getQos0NextSeq(), KVSchemaUtil::qos0MsgKey, Fetched.Builder::addQos0Msg, reader, replyBuilder);
        startFetchFromSeq = !params.hasSendBufferStartAfter() ? metadata.getSendBufferStartSeq() : Math.max(params.getSendBufferStartAfter() + 1L, metadata.getSendBufferStartSeq());
        this.fetchFromInbox(inboxInstStartKey, params.getMaxFetch(), metadata.getSendBufferStartSeq(), startFetchFromSeq, metadata.getSendBufferNextSeq(), KVSchemaUtil::bufferedMsgKey, Fetched.Builder::addSendBufferMsg, reader, replyBuilder);
        return replyBuilder.setResult(Fetched.Result.OK).build();
    }

    private void fetchFromInbox(ByteString inboxInstStartKey, int fetchCount, long startSeq, long startFetchFromSeq, long nextSeq, BiFunction<ByteString, Long, ByteString> keyGenerator, BiConsumer<Fetched.Builder, InboxMessage> messageConsumer, IKVRangeReader reader, Fetched.Builder replyBuilder) {
        if (startFetchFromSeq < nextSeq) {
            Optional pointed;
            long currSeq = startSeq;
            Optional currData = Optional.empty();
            if (startFetchFromSeq > startSeq && (pointed = reader.get(keyGenerator.apply(inboxInstStartKey, startFetchFromSeq))).isPresent()) {
                currSeq = startFetchFromSeq;
                currData = pointed;
            }
            if (currData.isEmpty()) {
                currData = reader.get(keyGenerator.apply(inboxInstStartKey, currSeq));
                while (currData.isEmpty() && currSeq < nextSeq) {
                    currData = reader.get(keyGenerator.apply(inboxInstStartKey, ++currSeq));
                }
                if (currData.isEmpty()) {
                    return;
                }
            }
            while (currData.isPresent() && fetchCount > 0) {
                List messageList = ((InboxMessageList)ZeroCopyParser.parse((ByteString)((ByteString)currData.get()), (Parser)InboxMessageList.parser())).getMessageList();
                long lastSeq = ((InboxMessage)messageList.get(messageList.size() - 1)).getSeq();
                if (lastSeq >= startFetchFromSeq) {
                    for (InboxMessage inboxMsg : messageList) {
                        if (inboxMsg.getSeq() < startFetchFromSeq) continue;
                        messageConsumer.accept(replyBuilder, inboxMsg);
                        --fetchCount;
                    }
                }
                currSeq = lastSeq + 1L;
                currData = reader.get(keyGenerator.apply(inboxInstStartKey, currSeq));
            }
        }
    }

    private CompletableFuture<BatchFetchInboxStateReply> batchFetchInboxState(BatchFetchInboxStateRequest request, IKVRangeReader reader) {
        BatchFetchInboxStateReply.Builder replyBuilder = BatchFetchInboxStateReply.newBuilder();
        for (BatchFetchInboxStateRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> latest = this.getLatestInboxVersion(params.getTenantId(), params.getInboxId(), reader);
            if (latest.isEmpty()) {
                replyBuilder.addResult(BatchFetchInboxStateReply.Result.newBuilder().setCode(BatchFetchInboxStateReply.Result.Code.NO_INBOX).build());
                continue;
            }
            if (this.hasExpired(latest.get(), params.getNow())) {
                replyBuilder.addResult(BatchFetchInboxStateReply.Result.newBuilder().setCode(BatchFetchInboxStateReply.Result.Code.EXPIRED).build());
                continue;
            }
            replyBuilder.addResult(BatchFetchInboxStateReply.Result.newBuilder().setCode(BatchFetchInboxStateReply.Result.Code.OK).setState(this.toInboxState(latest.get())).build());
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    private InboxState toInboxState(InboxMetadata metadata) {
        InboxState.Builder stateBuilder = InboxState.newBuilder().setCreatedAt(metadata.getCreatedAt()).setExpirySeconds(metadata.getExpirySeconds()).setLimit(metadata.getLimit()).putAllTopicFilters(metadata.getTopicFiltersMap()).setUndeliveredMsgCount(metadata.getSendBufferNextSeq() - metadata.getSendBufferStartSeq()).setLastActiveAt(metadata.getLastActiveTime());
        if (metadata.getDropOldest()) {
            stateBuilder.setDropOldest(true);
        }
        if (metadata.getQos0NextSeq() - metadata.getQos0StartSeq() > 0L) {
            stateBuilder.setUnfetchedQoS0MsgCount(metadata.getQos0NextSeq() - metadata.getQos0StartSeq());
        }
        if (metadata.hasDetachedAt()) {
            stateBuilder.setDetachedAt(metadata.getDetachedAt());
        }
        if (metadata.hasLwt()) {
            LWT lwt = metadata.getLwt();
            stateBuilder.setWill(LastWillInfo.newBuilder().setTopic(lwt.getTopic()).setQos(lwt.getMessage().getPubQoS()).setIsRetain(lwt.getMessage().getIsRetain()).setDelaySeconds(lwt.getDelaySeconds()).build());
        }
        return stateBuilder.build();
    }

    private CompletableFuture<BatchSendLWTReply> batchSendLWT(BatchSendLWTRequest request, IKVRangeReader reader) {
        ArrayList<CompletableFuture<BatchSendLWTReply.Code>> sendLWTFutures = new ArrayList<CompletableFuture<BatchSendLWTReply.Code>>(request.getParamsCount());
        for (BatchSendLWTRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getVersion().getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                sendLWTFutures.add(CompletableFuture.completedFuture(BatchSendLWTReply.Code.NO_INBOX));
                continue;
            }
            if (metadataOpt.get().getMod() != params.getVersion().getMod()) {
                sendLWTFutures.add(CompletableFuture.completedFuture(BatchSendLWTReply.Code.CONFLICT));
                continue;
            }
            if (!metadataOpt.get().hasDetachedAt()) {
                log.error("Illegal state: inbox has not detached");
                sendLWTFutures.add(CompletableFuture.completedFuture(BatchSendLWTReply.Code.ERROR));
                continue;
            }
            if (!metadataOpt.get().hasLwt()) {
                log.error("Illegal state: inbox has no lwt");
                sendLWTFutures.add(CompletableFuture.completedFuture(BatchSendLWTReply.Code.ERROR));
                continue;
            }
            sendLWTFutures.add(this.sendLWTAndExpireInbox(params.getTenantId(), metadataOpt.get(), params.getNow()));
        }
        return CompletableFuture.allOf((CompletableFuture[])sendLWTFutures.toArray(CompletableFuture[]::new)).thenApply(v -> {
            BatchSendLWTReply.Builder replyBuilder = BatchSendLWTReply.newBuilder();
            for (CompletableFuture future : sendLWTFutures) {
                replyBuilder.addCode((BatchSendLWTReply.Code)future.join());
            }
            return replyBuilder.build();
        });
    }

    private CompletableFuture<BatchSendLWTReply.Code> sendLWTAndExpireInbox(String tenantId, InboxMetadata metadata, long now) {
        return this.sendLWT(tenantId, metadata, now).thenApply(v -> {
            if (v == BatchSendLWTReply.Code.OK) {
                if (Integer.compareUnsigned(metadata.getExpirySeconds(), -1) == 0) {
                    return v;
                }
                TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), new InboxInstance(metadata.getInboxId(), metadata.getIncarnation()));
                long detachAtMillis = metadata.getDetachedAt();
                long expireAtMillis = detachAtMillis + Duration.ofSeconds(metadata.getExpirySeconds()).toMillis();
                Duration delay = Duration.ofMillis(Math.max(0L, expireAtMillis - now)).plusMillis(ThreadLocalRandom.current().nextLong(0L, 1000L));
                this.delayTaskRunner.schedule(inboxInstance, new ExpireInboxTask(delay, metadata.getMod(), this.inboxClient));
            }
            return v;
        });
    }

    private CompletableFuture<BatchSendLWTReply.Code> sendLWT(String tenantId, InboxMetadata metadata, long now) {
        CompletionStage<Object> retainLWTFuture;
        long reqId = System.nanoTime();
        LWT lwt = metadata.getLwt();
        ClientInfo clientInfo = metadata.getClient();
        CompletableFuture distLWTFuture = this.distClient.pub(reqId, lwt.getTopic(), lwt.getMessage().toBuilder().setTimestamp(now).build(), metadata.getClient());
        boolean willRetain = lwt.getMessage().getIsRetain();
        boolean retainEnabled = (Boolean)this.settingProvider.provide(Setting.RetainEnabled, tenantId);
        if (willRetain) {
            if (!retainEnabled) {
                this.eventCollector.report((Event)((MsgRetainedError)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).reqId(reqId)).topic(lwt.getTopic()).qos(lwt.getMessage().getPubQoS()).payload(lwt.getMessage().getPayload().asReadOnlyByteBuffer()).size(lwt.getMessage().getPayload().size()).reason("Retain Disabled").clientInfo(clientInfo));
                retainLWTFuture = CompletableFuture.completedFuture(RetainReply.Result.ERROR);
            } else {
                retainLWTFuture = this.retain(reqId, lwt, clientInfo).thenApply(v -> {
                    switch (v) {
                        case RETAINED: {
                            this.eventCollector.report((Event)((MsgRetained)ThreadLocalEventPool.getLocal(MsgRetained.class)).topic(lwt.getTopic()).qos(lwt.getMessage().getPubQoS()).isLastWill(true).size(lwt.getMessage().getPayload().size()).clientInfo(clientInfo));
                            break;
                        }
                        case CLEARED: {
                            this.eventCollector.report((Event)((RetainMsgCleared)ThreadLocalEventPool.getLocal(RetainMsgCleared.class)).topic(lwt.getTopic()).isLastWill(true).clientInfo(clientInfo));
                            break;
                        }
                        case BACK_PRESSURE_REJECTED: {
                            this.eventCollector.report((Event)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).topic(lwt.getTopic()).qos(lwt.getMessage().getPubQoS()).isLastWill(true).payload(lwt.getMessage().getPayload().asReadOnlyByteBuffer()).size(lwt.getMessage().getPayload().size()).reason("Server Busy").clientInfo(clientInfo));
                            break;
                        }
                        case EXCEED_LIMIT: {
                            this.eventCollector.report((Event)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).topic(lwt.getTopic()).qos(lwt.getMessage().getPubQoS()).isLastWill(true).payload(lwt.getMessage().getPayload().asReadOnlyByteBuffer()).size(lwt.getMessage().getPayload().size()).reason("Exceed Limit").clientInfo(clientInfo));
                            break;
                        }
                        case ERROR: {
                            this.eventCollector.report((Event)((MsgRetainedError)ThreadLocalEventPool.getLocal(MsgRetainedError.class)).topic(lwt.getTopic()).qos(lwt.getMessage().getPubQoS()).isLastWill(true).payload(lwt.getMessage().getPayload().asReadOnlyByteBuffer()).size(lwt.getMessage().getPayload().size()).reason("Internal Error").clientInfo(clientInfo));
                            break;
                        }
                    }
                    return v;
                });
            }
        } else {
            retainLWTFuture = CompletableFuture.completedFuture(RetainReply.Result.RETAINED);
        }
        return CompletableFuture.allOf(new CompletableFuture[]{distLWTFuture, retainLWTFuture}).thenApply(v -> {
            boolean retry;
            PubResult distResult = (PubResult)distLWTFuture.join();
            boolean bl = retry = distResult == PubResult.TRY_LATER;
            if (!retry && willRetain && retainEnabled) {
                boolean bl2 = retry = retainLWTFuture.join() == RetainReply.Result.TRY_LATER;
            }
            if (retry) {
                return BatchSendLWTReply.Code.TRY_LATER;
            }
            switch (distResult) {
                case OK: 
                case NO_MATCH: {
                    this.eventCollector.report((Event)((WillDisted)((WillDisted)((WillDisted)((WillDisted)ThreadLocalEventPool.getLocal(WillDisted.class)).reqId(reqId)).topic(lwt.getTopic())).qos(lwt.getMessage().getPubQoS()).size(lwt.getMessage().getPayload().size())).clientInfo(clientInfo));
                    return BatchSendLWTReply.Code.OK;
                }
                case BACK_PRESSURE_REJECTED: {
                    this.eventCollector.report((Event)((WillDistError)((WillDistError)((WillDistError)((WillDistError)ThreadLocalEventPool.getLocal(WillDistError.class)).reqId(reqId)).topic(lwt.getTopic())).qos(lwt.getMessage().getPubQoS()).size(lwt.getMessage().getPayload().size())).reason("Server Busy").clientInfo(clientInfo));
                    return BatchSendLWTReply.Code.OK;
                }
            }
            this.eventCollector.report((Event)((WillDistError)((WillDistError)((WillDistError)((WillDistError)ThreadLocalEventPool.getLocal(WillDistError.class)).reqId(reqId)).topic(lwt.getTopic())).qos(lwt.getMessage().getPubQoS()).size(lwt.getMessage().getPayload().size())).reason("Internal Error").clientInfo(clientInfo));
            return BatchSendLWTReply.Code.ERROR;
        });
    }

    private CompletableFuture<RetainReply.Result> retain(long reqId, LWT lwt, ClientInfo publisher) {
        if (!this.resourceThrottler.hasResource(publisher.getTenantId(), TenantResourceType.TotalRetainTopics)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainTopics.name()).clientInfo(publisher));
            return CompletableFuture.completedFuture(RetainReply.Result.EXCEED_LIMIT);
        }
        if (!this.resourceThrottler.hasResource(publisher.getTenantId(), TenantResourceType.TotalRetainMessageSpaceBytes)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalRetainMessageSpaceBytes.name()).clientInfo(publisher));
            return CompletableFuture.completedFuture(RetainReply.Result.EXCEED_LIMIT);
        }
        return this.retainClient.retain(reqId, lwt.getTopic(), lwt.getMessage().getPubQoS(), lwt.getMessage().getPayload(), lwt.getMessage().getExpiryInterval(), publisher).thenApply(RetainReply::getResult);
    }

    private Runnable batchAttach(BatchAttachRequest request, BatchAttachReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeTracked = new HashMap<String, Map>();
        HashSet<TenantInboxInstance> toBeCanceled = new HashSet<TenantInboxInstance>();
        HashMap<String, Set> toBeEnsured = new HashMap<String, Set>();
        for (BatchAttachRequest.Params params : request.getParamsList()) {
            InboxMetadata metadata;
            InboxMetadata.Builder metadataBuilder;
            String tenantId = params.getClient().getTenantId();
            String inboxId = params.getInboxId();
            long now = params.getNow();
            SortedMap<Long, InboxMetadata> inboxInstances = this.getAllInboxVersions(tenantId, inboxId, reader);
            if (inboxInstances.isEmpty() || this.hasExpired((InboxMetadata)inboxInstances.get(inboxInstances.lastKey()), now)) {
                long incarnation = params.getIncarnation();
                ByteString metadataKey = KVSchemaUtil.inboxInstanceStartKey((String)tenantId, (String)inboxId, (long)incarnation);
                if (params.getExpirySeconds() == 0) {
                    replyBuilder.addVersion(InboxVersion.newBuilder().setMod(0L).setIncarnation(0L).build());
                } else {
                    metadataBuilder = InboxMetadata.newBuilder().setInboxId(params.getInboxId()).setIncarnation(incarnation).setMod(0L).setExpirySeconds(params.getExpirySeconds()).setLimit(params.getLimit()).setDropOldest(params.getDropOldest()).setClient(params.getClient()).setLastActiveTime(params.getNow()).setCreatedAt(params.getNow());
                    if (params.hasLwt()) {
                        metadataBuilder.setLwt(params.getLwt());
                    }
                    metadata = metadataBuilder.build();
                    writer.put(metadataKey, metadata.toByteString());
                    toBeTracked.computeIfAbsent(tenantId, k -> new HashMap()).put(metadata, true);
                    replyBuilder.addVersion(InboxVersion.newBuilder().setMod(0L).setIncarnation(incarnation).build());
                }
                if (inboxInstances.isEmpty() || !isLeader) continue;
                for (InboxMetadata oldInboxMetadata : inboxInstances.values()) {
                    toBeEnsured.computeIfAbsent(tenantId, k -> new HashSet()).add(oldInboxMetadata);
                }
                continue;
            }
            InboxMetadata existingMetadata = (InboxMetadata)inboxInstances.get(inboxInstances.lastKey());
            long incarnation = existingMetadata.getIncarnation();
            metadataBuilder = existingMetadata.toBuilder().setMod(existingMetadata.getMod() + 1L).setExpirySeconds(params.getExpirySeconds()).setLastActiveTime(params.getNow()).setClient(params.getClient()).clearDetachedAt();
            if (params.hasLwt()) {
                metadataBuilder.setLwt(params.getLwt());
            } else {
                metadataBuilder.clearLwt();
            }
            metadata = metadataBuilder.build();
            ByteString metadataKey = KVSchemaUtil.inboxInstanceStartKey((String)tenantId, (String)inboxId, (long)incarnation);
            writer.put(metadataKey, metadata.toByteString());
            replyBuilder.addVersion(InboxVersion.newBuilder().setMod(metadata.getMod()).setIncarnation(incarnation).build());
            toBeTracked.computeIfAbsent(tenantId, k -> new HashMap()).put(metadata, false);
            if (!isLeader) continue;
            TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), new InboxInstance(inboxId, incarnation));
            toBeCanceled.add(inboxInstance);
        }
        return () -> {
            this.updateTenantStates(toBeTracked, isLeader);
            this.delayTaskRunner.cancelAll(toBeCanceled);
            toBeEnsured.forEach((tenantId, inboxSet) -> inboxSet.forEach(metadata -> {
                TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern(tenantId), new InboxInstance(metadata.getInboxId(), metadata.getIncarnation()));
                if (metadata.hasLwt()) {
                    this.delayTaskRunner.scheduleIfAbsent(inboxInstance, new SendLWTTask(Duration.ZERO, metadata.getMod(), this.inboxClient));
                } else {
                    this.delayTaskRunner.scheduleIfAbsent(inboxInstance, new ExpireInboxTask(Duration.ZERO, metadata.getMod(), this.inboxClient));
                }
            }));
        };
    }

    private Runnable batchDetach(BatchDetachRequest request, BatchDetachReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeUpdated = new HashMap<String, Map>();
        HashMap<String, Set> toBeEnsured = new HashMap<String, Set>();
        HashMap<String, Set> toBeScheduled = new HashMap<String, Set>();
        for (BatchDetachRequest.Params params : request.getParamsList()) {
            InboxMetadata metadata;
            SortedMap<Long, InboxMetadata> inboxVersions = this.getAllInboxVersions(params.getTenantId(), params.getInboxId(), reader);
            if (inboxVersions.isEmpty()) {
                replyBuilder.addCode(BatchDetachReply.Code.NO_INBOX);
                continue;
            }
            if (params.hasVersion()) {
                metadata = (InboxMetadata)inboxVersions.get(params.getVersion().getIncarnation());
                if (metadata == null) {
                    replyBuilder.addCode(BatchDetachReply.Code.NO_INBOX);
                    continue;
                }
                if (metadata.getMod() != params.getVersion().getMod()) {
                    replyBuilder.addCode(BatchDetachReply.Code.CONFLICT);
                    continue;
                }
            } else {
                metadata = (InboxMetadata)inboxVersions.get(inboxVersions.lastKey());
            }
            InboxMetadata.Builder metadataBuilder = metadata.toBuilder().setMod(params.getVersion().getMod() + 1L).setExpirySeconds(params.getExpirySeconds()).setDetachedAt(params.getNow());
            if (params.getDiscardLWT()) {
                metadataBuilder.clearLwt();
            }
            metadata = metadataBuilder.build();
            ByteString metadataKey = KVSchemaUtil.inboxInstanceStartKey((String)params.getTenantId(), (String)params.getInboxId(), (long)metadata.getIncarnation());
            writer.put(metadataKey, metadata.toByteString());
            toBeUpdated.computeIfAbsent(params.getTenantId(), k -> new HashMap()).put(metadata, false);
            if (isLeader) {
                toBeScheduled.computeIfAbsent(params.getTenantId(), k -> new HashSet()).add(metadata);
                for (InboxMetadata oldInboxMetadata : inboxVersions.headMap(inboxVersions.lastKey()).values()) {
                    toBeEnsured.computeIfAbsent(params.getTenantId(), k -> new HashSet()).add(oldInboxMetadata);
                }
            }
            replyBuilder.addCode(BatchDetachReply.Code.OK);
        }
        return () -> {
            this.updateTenantStates(toBeUpdated, isLeader);
            toBeScheduled.forEach((tenantId, inboxSet) -> inboxSet.forEach(metadata -> {
                TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern(tenantId), new InboxInstance(metadata.getInboxId(), metadata.getIncarnation()));
                if (metadata.hasLwt()) {
                    Duration delay = Duration.ofSeconds(Integer.compareUnsigned(metadata.getLwt().getDelaySeconds(), metadata.getExpirySeconds()) < 0 ? (long)metadata.getLwt().getDelaySeconds() : (long)metadata.getExpirySeconds()).plusMillis(ThreadLocalRandom.current().nextLong(0L, 1000L));
                    this.delayTaskRunner.schedule(inboxInstance, new SendLWTTask(delay, metadata.getMod(), this.inboxClient));
                } else if (Integer.compareUnsigned(metadata.getExpirySeconds(), -1) < 0) {
                    Duration delay = Duration.ofSeconds(metadata.getExpirySeconds());
                    this.delayTaskRunner.schedule(inboxInstance, new ExpireInboxTask(delay, metadata.getMod(), this.inboxClient));
                }
            }));
            toBeEnsured.forEach((tenantId, inboxSet) -> inboxSet.forEach(metadata -> {
                TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern(tenantId), new InboxInstance(metadata.getInboxId(), metadata.getIncarnation()));
                if (metadata.hasLwt()) {
                    this.delayTaskRunner.scheduleIfAbsent(inboxInstance, new SendLWTTask(Duration.ZERO, metadata.getMod(), this.inboxClient));
                } else {
                    this.delayTaskRunner.scheduleIfAbsent(inboxInstance, new ExpireInboxTask(Duration.ZERO, metadata.getMod(), this.inboxClient));
                }
            }));
        };
    }

    private Runnable batchDelete(BatchDeleteRequest request, BatchDeleteReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeRemoved = new HashMap<String, Map>();
        HashMap<InboxMetadata, List> dropedQoS0Msgs = new HashMap<InboxMetadata, List>();
        HashMap<InboxMetadata, List> dropedBufferedMsg = new HashMap<InboxMetadata, List>();
        for (BatchDeleteRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getVersion().getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addResult(BatchDeleteReply.Result.newBuilder().setCode(BatchDeleteReply.Code.NO_INBOX).build());
                continue;
            }
            if (metadataOpt.get().getMod() != params.getVersion().getMod()) {
                replyBuilder.addResult(BatchDeleteReply.Result.newBuilder().setCode(BatchDeleteReply.Code.CONFLICT).build());
                continue;
            }
            InboxMetadata metadata = metadataOpt.get();
            Optional<InboxMetadata> latestMetadata = this.getLatestInboxVersion(params.getTenantId(), params.getInboxId(), reader);
            if (latestMetadata.isEmpty()) {
                log.warn("Inconsistent state: inbox instance disappeared during deletion");
            }
            this.clearInboxInstance(metadata, reader, writer, isLeader, dropedQoS0Msgs.computeIfAbsent(metadata, k -> new LinkedList()), dropedBufferedMsg.computeIfAbsent(metadata, k -> new LinkedList()));
            toBeRemoved.computeIfAbsent(params.getTenantId(), k -> new HashMap()).put(metadata, metadata.equals((Object)latestMetadata.get()));
            replyBuilder.addResult(BatchDeleteReply.Result.newBuilder().setCode(BatchDeleteReply.Code.OK).putAllTopicFilters(metadata.getTopicFiltersMap()).build());
        }
        return () -> {
            if (isLeader) {
                TopicFilterOption option;
                Message msg;
                TopicMessage topicMsg;
                for (InboxMetadata inboxMetadata : dropedQoS0Msgs.keySet()) {
                    List dropedQoS0MsgList = (List)dropedQoS0Msgs.get(inboxMetadata);
                    for (InboxMessage inboxMsg : dropedQoS0MsgList) {
                        topicMsg = inboxMsg.getMsg();
                        msg = topicMsg.getMessage();
                        for (String topicFilter : inboxMsg.getMatchedTopicFilterMap().keySet()) {
                            option = (TopicFilterOption)inboxMsg.getMatchedTopicFilterMap().get(topicFilter);
                            boolean isRetain = topicMsg.getMessage().getIsRetained() || option.getRetainAsPublished() && msg.getIsRetain();
                            this.eventCollector.report((Event)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)((QoS0Dropped)ThreadLocalEventPool.getLocal(QoS0Dropped.class)).reason(DropReason.SessionClosed).reqId(msg.getMessageId())).isRetain(isRetain)).sender(topicMsg.getPublisher())).topic(topicMsg.getTopic())).matchedFilter(topicFilter)).size(msg.getPayload().size())).clientInfo(inboxMetadata.getClient()));
                        }
                    }
                }
                for (InboxMetadata inboxMetadata : dropedBufferedMsg.keySet()) {
                    List dropedBufferedMsgList = (List)dropedBufferedMsg.get(inboxMetadata);
                    for (InboxMessage inboxMsg : dropedBufferedMsgList) {
                        topicMsg = inboxMsg.getMsg();
                        msg = topicMsg.getMessage();
                        for (String topicFilter : inboxMsg.getMatchedTopicFilterMap().keySet()) {
                            boolean isRetain;
                            option = (TopicFilterOption)inboxMsg.getMatchedTopicFilterMap().get(topicFilter);
                            QoS finalQos = QoS.forNumber((int)Math.min(topicMsg.getMessage().getPubQoS().getNumber(), option.getQos().getNumber()));
                            boolean bl = isRetain = topicMsg.getMessage().getIsRetained() || option.getRetainAsPublished() && msg.getIsRetain();
                            if (finalQos == QoS.AT_LEAST_ONCE) {
                                this.eventCollector.report((Event)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)ThreadLocalEventPool.getLocal(QoS1Dropped.class)).reason(DropReason.SessionClosed).reqId(msg.getMessageId())).isRetain(isRetain)).sender(topicMsg.getPublisher())).topic(topicMsg.getTopic())).matchedFilter(topicFilter)).size(msg.getPayload().size())).clientInfo(inboxMetadata.getClient()));
                                continue;
                            }
                            if (finalQos != QoS.EXACTLY_ONCE) continue;
                            this.eventCollector.report((Event)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)ThreadLocalEventPool.getLocal(QoS2Dropped.class)).reason(DropReason.SessionClosed).reqId(msg.getMessageId())).isRetain(isRetain)).sender(topicMsg.getPublisher())).topic(topicMsg.getTopic())).matchedFilter(topicFilter)).size(msg.getPayload().size())).clientInfo(inboxMetadata.getClient()));
                        }
                    }
                }
            }
            this.removeTenantStates(toBeRemoved, isLeader);
        };
    }

    private Runnable batchSub(BatchSubRequest request, BatchSubReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeCached = new HashMap<String, Map>();
        HashMap<String, Integer> addedSubCounts = new HashMap<String, Integer>();
        for (BatchSubRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getVersion().getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addCode(BatchSubReply.Code.NO_INBOX);
                continue;
            }
            if (metadataOpt.get().getMod() != params.getVersion().getMod()) {
                replyBuilder.addCode(BatchSubReply.Code.CONFLICT);
                continue;
            }
            int maxTopicFilters = params.getMaxTopicFilters();
            InboxMetadata metadata = metadataOpt.get();
            InboxMetadata.Builder metadataBuilder = metadataOpt.get().toBuilder();
            if (metadata.getTopicFiltersCount() < maxTopicFilters) {
                TopicFilterOption option = (TopicFilterOption)metadataBuilder.getTopicFiltersMap().get(params.getTopicFilter());
                if (option != null && option.equals((Object)params.getOption())) {
                    replyBuilder.addCode(BatchSubReply.Code.EXISTS);
                } else {
                    metadataBuilder.putTopicFilters(params.getTopicFilter(), params.getOption());
                    replyBuilder.addCode(BatchSubReply.Code.OK);
                    if (option == null) {
                        addedSubCounts.merge(params.getTenantId(), 1, Integer::sum);
                    }
                }
            } else {
                replyBuilder.addCode(BatchSubReply.Code.EXCEED_LIMIT);
            }
            metadata = metadataBuilder.setLastActiveTime(params.getNow()).build();
            ByteString inboxInstStartKey = KVSchemaUtil.inboxInstanceStartKey((String)params.getTenantId(), (String)params.getInboxId(), (long)params.getVersion().getIncarnation());
            writer.put(inboxInstStartKey, metadata.toByteString());
            toBeCached.computeIfAbsent(params.getTenantId(), k -> new HashMap()).put(metadata, false);
        }
        return () -> {
            this.updateTenantStates(toBeCached, isLeader);
            addedSubCounts.forEach(this.tenantStats::addSubCount);
            this.tenantStats.toggleMetering(isLeader);
        };
    }

    private Runnable batchUnsub(BatchUnsubRequest request, BatchUnsubReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter write) {
        HashMap<String, Map> toBeCached = new HashMap<String, Map>();
        HashMap<String, Integer> removedSubCounts = new HashMap<String, Integer>();
        for (BatchUnsubRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getVersion().getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addResult(BatchUnsubReply.Result.newBuilder().setCode(BatchUnsubReply.Code.NO_INBOX).build());
                continue;
            }
            if (metadataOpt.get().getMod() != params.getVersion().getMod()) {
                replyBuilder.addResult(BatchUnsubReply.Result.newBuilder().setCode(BatchUnsubReply.Code.CONFLICT).build());
                continue;
            }
            InboxMetadata metadata = metadataOpt.get();
            InboxMetadata.Builder metadataBuilder = metadata.toBuilder();
            if (metadataBuilder.containsTopicFilters(params.getTopicFilter())) {
                metadataBuilder.removeTopicFilters(params.getTopicFilter());
                replyBuilder.addResult(BatchUnsubReply.Result.newBuilder().setCode(BatchUnsubReply.Code.OK).setOption((TopicFilterOption)metadata.getTopicFiltersMap().get(params.getTopicFilter())).build());
                removedSubCounts.merge(params.getTenantId(), 1, Integer::sum);
            } else {
                replyBuilder.addResult(BatchUnsubReply.Result.newBuilder().setCode(BatchUnsubReply.Code.NO_SUB).build());
            }
            metadata = metadataBuilder.setLastActiveTime(params.getNow()).build();
            ByteString inboxInstStartKey = KVSchemaUtil.inboxInstanceStartKey((String)params.getTenantId(), (String)params.getInboxId(), (long)params.getVersion().getIncarnation());
            write.put(inboxInstStartKey, metadata.toByteString());
            toBeCached.computeIfAbsent(params.getTenantId(), k -> new HashMap()).put(metadata, false);
        }
        return () -> {
            this.updateTenantStates(toBeCached, isLeader);
            removedSubCounts.forEach((tenantId, subCount) -> this.tenantStats.addSubCount((String)tenantId, -subCount.intValue()));
            this.tenantStats.toggleMetering(isLeader);
        };
    }

    private void clearInboxInstance(InboxMetadata metadata, IKVRangeReader reader, IKVWriter writer, boolean isLeader, List<InboxMessage> dropedQoS0MsgList, List<InboxMessage> dropedBufferedMsgList) {
        IKVIterator it;
        ByteString startKey = KVSchemaUtil.inboxInstanceStartKey((String)metadata.getClient().getTenantId(), (String)metadata.getInboxId(), (long)metadata.getIncarnation());
        if (metadata.getQos0NextSeq() > 0L) {
            ByteString qos0Prefix = KVSchemaUtil.qos0QueuePrefix((ByteString)startKey);
            Boundary qos0MsgBound = Boundary.newBuilder().setStartKey(qos0Prefix).setEndKey(BoundaryUtil.upperBound((ByteString)qos0Prefix)).build();
            if (isLeader) {
                it = reader.iterator(qos0MsgBound);
                try {
                    it.seek(qos0Prefix);
                    while (it.isValid() && it.key().startsWith(qos0Prefix)) {
                        dropedQoS0MsgList.addAll(this.parseInboxMessageList(it.value()).getMessageList());
                        it.next();
                    }
                }
                finally {
                    if (it != null) {
                        it.close();
                    }
                }
            }
            writer.clear(Boundary.newBuilder().setStartKey(qos0Prefix).setEndKey(BoundaryUtil.upperBound((ByteString)qos0Prefix)).build());
        }
        if (metadata.getSendBufferNextSeq() > 0L) {
            ByteString bufPrefix = KVSchemaUtil.sendBufferPrefix((ByteString)startKey);
            Boundary bufferedMsgBound = Boundary.newBuilder().setStartKey(bufPrefix).setEndKey(BoundaryUtil.upperBound((ByteString)bufPrefix)).build();
            if (isLeader) {
                it = reader.iterator(bufferedMsgBound);
                try {
                    it.seek(bufPrefix);
                    while (it.isValid() && it.key().startsWith(bufPrefix)) {
                        dropedBufferedMsgList.addAll(this.parseInboxMessageList(it.value()).getMessageList());
                        it.next();
                    }
                }
                finally {
                    if (it != null) {
                        it.close();
                    }
                }
            }
            writer.clear(bufferedMsgBound);
        }
        writer.delete(startKey);
    }

    private InboxMessageList parseInboxMessageList(ByteString value) {
        try {
            return (InboxMessageList)ZeroCopyParser.parse((ByteString)value, (Parser)InboxMessageList.parser());
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Failed to parse InboxMessageList", (Throwable)e);
            return InboxMessageList.getDefaultInstance();
        }
    }

    private CompletableFuture<GCReply> gc(GCRequest request, IKVRangeReader reader) {
        int scanQuota = request.getScanQuota();
        AtomicInteger inspectedAcc = new AtomicInteger();
        AtomicBoolean wrapped = new AtomicBoolean(false);
        AtomicReference<Object> nextStartKeyRef = new AtomicReference<Object>(null);
        LinkedList<CompletionStage> inboxFutures = new LinkedList<CompletionStage>();
        int probe = 0;
        try (IKVIterator itr = reader.iterator();){
            ByteString inboxPrefix;
            if (request.hasStartKey()) {
                ByteString start = request.getStartKey();
                if (KVSchemaUtil.isInboxInstanceKey((ByteString)start)) {
                    itr.seek(KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)start));
                } else {
                    itr.seek(start);
                }
                if (!itr.isValid()) {
                    wrapped.set(true);
                    itr.seekToFirst();
                }
            } else {
                itr.seekToFirst();
            }
            while (itr.isValid() && inspectedAcc.get() < scanQuota) {
                InboxMetadata metadata;
                ByteString key = itr.key();
                if (!KVSchemaUtil.isInboxInstanceStartKey((ByteString)key)) {
                    if (KVSchemaUtil.isInboxInstanceKey((ByteString)key)) {
                        inboxPrefix = KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)key);
                        itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxStartKeyPrefix((ByteString)inboxPrefix)));
                        probe = 0;
                        continue;
                    }
                    if (probe < 20) {
                        itr.next();
                        ++probe;
                        continue;
                    }
                    String tenantId = KVSchemaUtil.parseTenantId((ByteString)key);
                    itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.tenantBeginKeyPrefix((String)tenantId)));
                    probe = 0;
                    continue;
                }
                try {
                    metadata = InboxMetadata.parseFrom((ByteString)itr.value());
                }
                catch (InvalidProtocolBufferException e) {
                    ByteString inboxPrefix2 = KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)key);
                    itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxStartKeyPrefix((ByteString)inboxPrefix2)));
                    probe = 0;
                    continue;
                }
                String tenantId = KVSchemaUtil.parseTenantId((ByteString)key);
                String inboxId = metadata.getInboxId();
                SortedMap<Long, InboxMetadata> inboxVersions = this.getAllInboxVersions(tenantId, inboxId, reader);
                if (inboxVersions.isEmpty()) {
                    ByteString inboxPrefix3 = KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)key);
                    itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxStartKeyPrefix((ByteString)inboxPrefix3)));
                    probe = 0;
                    continue;
                }
                inspectedAcc.addAndGet(inboxVersions.size());
                LinkedList<CompletableFuture<ExpireCheckResult>> checks = new LinkedList<CompletableFuture<ExpireCheckResult>>();
                this.checkInboxOnline(tenantId, Duration.ZERO, request.getNow(), inboxVersions, checks);
                CompletionStage inboxDone = CompletableFuture.allOf((CompletableFuture[])checks.toArray(CompletableFuture[]::new)).thenApply(v -> {
                    int expiredCount = 0;
                    for (CompletableFuture f : checks) {
                        ExpireCheckResult r = (ExpireCheckResult)f.join();
                        if (!r.expired) continue;
                        TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), new InboxInstance(r.metadata.getInboxId(), r.metadata.getIncarnation()));
                        this.delayTaskRunner.schedule(inboxInstance, new ExpireInboxTask(Duration.ofMillis(0L), r.metadata.getMod(), this.inboxClient));
                        ++expiredCount;
                    }
                    return expiredCount;
                });
                inboxFutures.add(inboxDone);
                ByteString inboxPrefix4 = KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)key);
                itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxStartKeyPrefix((ByteString)inboxPrefix4)));
                probe = 0;
            }
            if (itr.isValid()) {
                ByteString k = itr.key();
                if (KVSchemaUtil.isInboxInstanceKey((ByteString)k)) {
                    inboxPrefix = KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)k);
                    nextStartKeyRef.set(KVSchemaUtil.parseInboxStartKeyPrefix((ByteString)inboxPrefix));
                } else {
                    nextStartKeyRef.set(k);
                }
            } else {
                wrapped.set(true);
            }
        }
        AtomicInteger removedAcc = new AtomicInteger();
        CompletableFuture[] waits = (CompletableFuture[])inboxFutures.stream().map(f -> f.thenAccept(removedAcc::addAndGet)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(waits).thenApply(v -> {
            int removed = removedAcc.get();
            GCReply.Builder reply = GCReply.newBuilder().setInspectedCount(inspectedAcc.get()).setRemoveSuccess(removed).setWrapped(wrapped.get());
            ByteString ns = (ByteString)nextStartKeyRef.get();
            if (ns != null) {
                reply.setNextStartKey(ns);
            }
            return reply.build();
        });
    }

    private Runnable batchInsert(BatchInsertRequest request, BatchInsertReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        if (request.getInsertRefCount() > 0) {
            return this.batchInsertCompactLayout(request, replyBuilder, isLeader, reader, writer);
        }
        return this.batchInsertLegacy(request, replyBuilder, isLeader, reader, writer);
    }

    private Runnable batchInsertCompactLayout(BatchInsertRequest request, BatchInsertReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeCached = new HashMap<String, Map>();
        HashMap<ClientInfo, Map> dropCountMap = new HashMap<ClientInfo, Map>();
        HashMap<ClientInfo, Boolean> dropOldestMap = new HashMap<ClientInfo, Boolean>();
        List pool = request.getTopicMessagePackList();
        for (BatchInsertRequest.InsertRef ref : request.getInsertRefList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(ref.getTenantId(), ref.getInboxId(), ref.getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addResult(InsertResult.newBuilder().setCode(InsertResult.Code.NO_INBOX).build());
                continue;
            }
            InboxMetadata metadata = metadataOpt.get();
            ArrayList<SubMessage> qos0MsgList = new ArrayList<SubMessage>();
            ArrayList<SubMessage> bufferMsgList = new ArrayList<SubMessage>();
            HashSet<InsertResult.SubStatus> insertResults = new HashSet<InsertResult.SubStatus>();
            for (BatchInsertRequest.SubRef subRef : ref.getSubRefList()) {
                int index = subRef.getMessagePackIndex();
                if (index < 0 || index >= pool.size()) {
                    log.warn("Invalid messagePackIndex: {} for tenantId={}, inboxId={}, inc={}", new Object[]{index, ref.getTenantId(), ref.getInboxId(), ref.getIncarnation()});
                    continue;
                }
                TopicMessagePack topicMsgPack = (TopicMessagePack)pool.get(index);
                HashMap<String, TopicFilterOption> qos0TopicFilters = new HashMap<String, TopicFilterOption>();
                HashMap<String, TopicFilterOption> qos1TopicFilters = new HashMap<String, TopicFilterOption>();
                HashMap<String, TopicFilterOption> qos2TopicFilters = new HashMap<String, TopicFilterOption>();
                for (MatchedRoute matchedRoute : subRef.getMatchedRouteList()) {
                    long matchedIncarnation = matchedRoute.getIncarnation();
                    TopicFilterOption tfOption = (TopicFilterOption)metadata.getTopicFiltersMap().get(matchedRoute.getTopicFilter());
                    if (tfOption == null) {
                        insertResults.add(InsertResult.SubStatus.newBuilder().setMatchedRoute(matchedRoute).setRejected(true).build());
                        continue;
                    }
                    if (tfOption.getIncarnation() > matchedIncarnation) {
                        log.debug("Receive message from previous subscription: topicFilter={}, inc={}, prevInc={}", new Object[]{matchedRoute, tfOption.getIncarnation(), matchedIncarnation});
                        insertResults.add(InsertResult.SubStatus.newBuilder().setMatchedRoute(matchedRoute).setRejected(true).build());
                    } else {
                        insertResults.add(InsertResult.SubStatus.newBuilder().setMatchedRoute(matchedRoute).setRejected(false).build());
                    }
                    switch (tfOption.getQos()) {
                        case AT_MOST_ONCE: {
                            qos0TopicFilters.put(matchedRoute.getTopicFilter(), tfOption);
                            break;
                        }
                        case AT_LEAST_ONCE: {
                            qos1TopicFilters.put(matchedRoute.getTopicFilter(), tfOption);
                            break;
                        }
                        case EXACTLY_ONCE: {
                            qos2TopicFilters.put(matchedRoute.getTopicFilter(), tfOption);
                            break;
                        }
                    }
                }
                if (qos0TopicFilters.isEmpty() && qos1TopicFilters.isEmpty() && qos2TopicFilters.isEmpty()) continue;
                String topic = topicMsgPack.getTopic();
                for (TopicMessagePack.PublisherPack publisherPack : topicMsgPack.getMessageList()) {
                    for (Message message : publisherPack.getMessageList()) {
                        ClientInfo publisher = publisherPack.getPublisher();
                        switch (message.getPubQoS()) {
                            case AT_MOST_ONCE: {
                                HashMap<String, TopicFilterOption> topicFilters = new HashMap<String, TopicFilterOption>();
                                topicFilters.putAll(qos0TopicFilters);
                                topicFilters.putAll(qos1TopicFilters);
                                topicFilters.putAll(qos2TopicFilters);
                                qos0MsgList.add(new SubMessage(topic, publisher, message, topicFilters));
                                break;
                            }
                            case AT_LEAST_ONCE: 
                            case EXACTLY_ONCE: {
                                if (!qos0TopicFilters.isEmpty()) {
                                    qos0MsgList.add(new SubMessage(topic, publisher, message, qos0TopicFilters));
                                }
                                if (qos1TopicFilters.isEmpty() && qos2TopicFilters.isEmpty()) break;
                                HashMap<String, TopicFilterOption> topicFilters = new HashMap();
                                topicFilters.putAll(qos1TopicFilters);
                                topicFilters.putAll(qos2TopicFilters);
                                bufferMsgList.add(new SubMessage(topic, publisher, message, topicFilters));
                                break;
                            }
                        }
                    }
                }
            }
            InboxMetadata.Builder metadataBuilder = metadata.toBuilder();
            dropOldestMap.put(metadata.getClient(), metadata.getDropOldest());
            ByteString inboxInstStartKey = KVSchemaUtil.inboxInstanceStartKey((String)ref.getTenantId(), (String)ref.getInboxId(), (long)ref.getIncarnation());
            Map<QoS, Integer> dropCounts = this.insertInbox(inboxInstStartKey, qos0MsgList, bufferMsgList, metadataBuilder, reader, writer);
            metadata = metadataBuilder.build();
            Map aggregated = dropCountMap.computeIfAbsent(metadata.getClient(), k -> new HashMap());
            dropCounts.forEach((qos, count) -> aggregated.compute(qos, (k, v) -> v == null ? count : v + count));
            replyBuilder.addResult(InsertResult.newBuilder().setCode(InsertResult.Code.OK).addAllResult(insertResults).build());
            writer.put(inboxInstStartKey, metadata.toByteString());
            toBeCached.computeIfAbsent(ref.getTenantId(), k -> new HashMap()).put(metadata, false);
        }
        return () -> {
            this.updateTenantStates(toBeCached, isLeader);
            dropCountMap.forEach((client, dropCounts) -> dropCounts.forEach((qos, count) -> {
                if (count > 0) {
                    this.eventCollector.report((Event)((Overflowed)((Overflowed)ThreadLocalEventPool.getLocal(Overflowed.class)).oldest(((Boolean)dropOldestMap.get(client)).booleanValue()).isQoS0(qos == QoS.AT_MOST_ONCE).clientInfo(client)).dropCount(count.intValue()));
                }
            }));
        };
    }

    private Runnable batchInsertLegacy(BatchInsertRequest request, BatchInsertReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeCached = new HashMap<String, Map>();
        HashMap<ClientInfo, Map> dropCountMap = new HashMap<ClientInfo, Map>();
        HashMap<ClientInfo, Boolean> dropOldestMap = new HashMap<ClientInfo, Boolean>();
        for (InsertRequest params : request.getRequestList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addResult(InsertResult.newBuilder().setCode(InsertResult.Code.NO_INBOX).build());
                continue;
            }
            InboxMetadata metadata = metadataOpt.get();
            ArrayList<SubMessage> qos0MsgList = new ArrayList<SubMessage>();
            ArrayList<SubMessage> bufferMsgList = new ArrayList<SubMessage>();
            HashSet<InsertResult.SubStatus> insertResults = new HashSet<InsertResult.SubStatus>();
            for (SubMessagePack messagePack : params.getMessagePackList()) {
                HashMap<String, TopicFilterOption> qos0TopicFilters = new HashMap<String, TopicFilterOption>();
                HashMap<String, TopicFilterOption> qos1TopicFilters = new HashMap<String, TopicFilterOption>();
                HashMap<String, TopicFilterOption> qos2TopicFilters = new HashMap<String, TopicFilterOption>();
                TopicMessagePack topicMsgPack = messagePack.getMessages();
                for (MatchedRoute matchedRoute : messagePack.getMatchedRouteList()) {
                    long matchedIncarnation = matchedRoute.getIncarnation();
                    TopicFilterOption tfOption = (TopicFilterOption)metadata.getTopicFiltersMap().get(matchedRoute.getTopicFilter());
                    if (tfOption == null) {
                        insertResults.add(InsertResult.SubStatus.newBuilder().setMatchedRoute(matchedRoute).setRejected(true).build());
                        continue;
                    }
                    if (tfOption.getIncarnation() > matchedIncarnation) {
                        log.debug("Receive message from previous subscription: topicFilter={}, inc={}, prevInc={}", new Object[]{matchedRoute, tfOption.getIncarnation(), matchedIncarnation});
                        insertResults.add(InsertResult.SubStatus.newBuilder().setMatchedRoute(matchedRoute).setRejected(true).build());
                    } else {
                        insertResults.add(InsertResult.SubStatus.newBuilder().setMatchedRoute(matchedRoute).setRejected(false).build());
                    }
                    switch (tfOption.getQos()) {
                        case AT_MOST_ONCE: {
                            qos0TopicFilters.put(matchedRoute.getTopicFilter(), tfOption);
                            break;
                        }
                        case AT_LEAST_ONCE: {
                            qos1TopicFilters.put(matchedRoute.getTopicFilter(), tfOption);
                            break;
                        }
                        case EXACTLY_ONCE: {
                            qos2TopicFilters.put(matchedRoute.getTopicFilter(), tfOption);
                            break;
                        }
                    }
                }
                if (qos0TopicFilters.isEmpty() && qos1TopicFilters.isEmpty() && qos2TopicFilters.isEmpty()) continue;
                String topic = topicMsgPack.getTopic();
                for (TopicMessagePack.PublisherPack publisherPack : topicMsgPack.getMessageList()) {
                    for (Message message : publisherPack.getMessageList()) {
                        ClientInfo publisher = publisherPack.getPublisher();
                        switch (message.getPubQoS()) {
                            case AT_MOST_ONCE: {
                                HashMap<String, TopicFilterOption> topicFilters = new HashMap<String, TopicFilterOption>();
                                topicFilters.putAll(qos0TopicFilters);
                                topicFilters.putAll(qos1TopicFilters);
                                topicFilters.putAll(qos2TopicFilters);
                                qos0MsgList.add(new SubMessage(topic, publisher, message, topicFilters));
                                break;
                            }
                            case AT_LEAST_ONCE: 
                            case EXACTLY_ONCE: {
                                if (!qos0TopicFilters.isEmpty()) {
                                    qos0MsgList.add(new SubMessage(topic, publisher, message, qos0TopicFilters));
                                }
                                if (qos1TopicFilters.isEmpty() && qos2TopicFilters.isEmpty()) break;
                                HashMap<String, TopicFilterOption> topicFilters = new HashMap();
                                topicFilters.putAll(qos1TopicFilters);
                                topicFilters.putAll(qos2TopicFilters);
                                bufferMsgList.add(new SubMessage(topic, publisher, message, topicFilters));
                                break;
                            }
                        }
                    }
                }
            }
            InboxMetadata.Builder metadataBuilder = metadata.toBuilder();
            dropOldestMap.put(metadata.getClient(), metadata.getDropOldest());
            ByteString inboxInstStartKey = KVSchemaUtil.inboxInstanceStartKey((String)params.getTenantId(), (String)params.getInboxId(), (long)params.getIncarnation());
            Map<QoS, Integer> dropCounts = this.insertInbox(inboxInstStartKey, qos0MsgList, bufferMsgList, metadataBuilder, reader, writer);
            metadata = metadataBuilder.build();
            Map aggregated = dropCountMap.computeIfAbsent(metadata.getClient(), k -> new HashMap());
            dropCounts.forEach((qos, count) -> aggregated.compute(qos, (k, v) -> {
                if (v == null) {
                    return count;
                }
                return v + count;
            }));
            replyBuilder.addResult(InsertResult.newBuilder().setCode(InsertResult.Code.OK).addAllResult(insertResults).build());
            writer.put(inboxInstStartKey, metadata.toByteString());
            toBeCached.computeIfAbsent(params.getTenantId(), k -> new HashMap()).put(metadata, false);
        }
        return () -> {
            this.updateTenantStates(toBeCached, isLeader);
            dropCountMap.forEach((client, dropCounts) -> dropCounts.forEach((qos, count) -> {
                if (count > 0) {
                    this.eventCollector.report((Event)((Overflowed)((Overflowed)ThreadLocalEventPool.getLocal(Overflowed.class)).oldest(((Boolean)dropOldestMap.get(client)).booleanValue()).isQoS0(qos == QoS.AT_MOST_ONCE).clientInfo(client)).dropCount(count.intValue()));
                }
            }));
        };
    }

    private Map<QoS, Integer> insertInbox(ByteString inboxKeyPrefix, List<SubMessage> qos0MsgList, List<SubMessage> bufferedMsgList, InboxMetadata.Builder metaBuilder, IKVRangeReader reader, IKVWriter writer) {
        int dropCount;
        long nextSeq;
        long startSeq;
        HashMap<QoS, Integer> dropCounts = new HashMap<QoS, Integer>();
        if (!qos0MsgList.isEmpty()) {
            startSeq = metaBuilder.getQos0StartSeq();
            nextSeq = metaBuilder.getQos0NextSeq();
            dropCount = this.insertToInbox(inboxKeyPrefix, startSeq, nextSeq, metaBuilder.getLimit(), metaBuilder.getDropOldest(), KVSchemaUtil::qos0MsgKey, arg_0 -> ((InboxMetadata.Builder)metaBuilder).setQos0StartSeq(arg_0), arg_0 -> ((InboxMetadata.Builder)metaBuilder).setQos0NextSeq(arg_0), qos0MsgList, reader, writer);
            if (dropCount > 0) {
                dropCounts.put(QoS.AT_MOST_ONCE, dropCount);
            }
        }
        if (!bufferedMsgList.isEmpty()) {
            startSeq = metaBuilder.getSendBufferStartSeq();
            nextSeq = metaBuilder.getSendBufferNextSeq();
            dropCount = this.insertToInbox(inboxKeyPrefix, startSeq, nextSeq, metaBuilder.getLimit(), false, KVSchemaUtil::bufferedMsgKey, arg_0 -> ((InboxMetadata.Builder)metaBuilder).setSendBufferStartSeq(arg_0), arg_0 -> ((InboxMetadata.Builder)metaBuilder).setSendBufferNextSeq(arg_0), bufferedMsgList, reader, writer);
            if (dropCount > 0) {
                dropCounts.put(QoS.AT_LEAST_ONCE, dropCount);
            }
        }
        return dropCounts;
    }

    private int insertToInbox(ByteString inboxKeyPrefix, long startSeq, long nextSeq, int limit, boolean dropOldest, BiFunction<ByteString, Long, ByteString> keyGenerator, Function<Long, InboxMetadata.Builder> startSeqSetter, Function<Long, InboxMetadata.Builder> nextSeqSetter, List<SubMessage> messages, IKVRangeReader reader, IKVWriter writer) {
        int newMsgCount = messages.size();
        int currCount = (int)(nextSeq - startSeq);
        int dropCount = currCount + newMsgCount - limit;
        if (dropOldest) {
            if (dropCount > 0) {
                if (dropCount >= currCount) {
                    writer.clear(Boundary.newBuilder().setStartKey(keyGenerator.apply(inboxKeyPrefix, startSeq)).setEndKey(keyGenerator.apply(inboxKeyPrefix, nextSeq)).build());
                    if (dropCount > currCount) {
                        messages = messages.subList(dropCount - currCount, newMsgCount);
                    }
                    writer.insert(keyGenerator.apply(inboxKeyPrefix, startSeq + (long)dropCount), this.buildInboxMessageList(startSeq + (long)dropCount, messages).toByteString());
                } else {
                    try (IKVIterator itr = reader.iterator(Boundary.newBuilder().setStartKey(inboxKeyPrefix).setEndKey(BoundaryUtil.upperBound((ByteString)inboxKeyPrefix)).build());){
                        itr.seekForPrev(keyGenerator.apply(inboxKeyPrefix, startSeq + (long)dropCount));
                        long beginSeq = KVSchemaUtil.parseSeq((ByteString)inboxKeyPrefix, (ByteString)itr.key());
                        List msgList = ((InboxMessageList)ZeroCopyParser.parse((ByteString)itr.value(), (Parser)InboxMessageList.parser())).getMessageList();
                        InboxMessageList.Builder msgListBuilder = InboxMessageList.newBuilder();
                        List subMsgList = msgList.subList((int)(startSeq + (long)dropCount - beginSeq), msgList.size());
                        if (!subMsgList.isEmpty()) {
                            msgListBuilder.addAllMessage(subMsgList).addAllMessage((Iterable)this.buildInboxMessageList(((InboxMessage)subMsgList.get(subMsgList.size() - 1)).getSeq() + 1L, messages).getMessageList());
                        } else {
                            msgListBuilder.addAllMessage((Iterable)this.buildInboxMessageList(startSeq + (long)dropCount, messages).getMessageList());
                        }
                        writer.clear(Boundary.newBuilder().setStartKey(keyGenerator.apply(inboxKeyPrefix, startSeq)).setEndKey(keyGenerator.apply(inboxKeyPrefix, startSeq + (long)dropCount)).build());
                        if (beginSeq == startSeq + (long)dropCount) {
                            writer.put(keyGenerator.apply(inboxKeyPrefix, startSeq + (long)dropCount), msgListBuilder.build().toByteString());
                        } else {
                            writer.insert(keyGenerator.apply(inboxKeyPrefix, startSeq + (long)dropCount), msgListBuilder.build().toByteString());
                        }
                    }
                }
                startSeq += (long)dropCount;
            } else {
                writer.insert(keyGenerator.apply(inboxKeyPrefix, nextSeq), this.buildInboxMessageList(nextSeq, messages).toByteString());
            }
            startSeqSetter.apply(startSeq);
            nextSeqSetter.apply(nextSeq += (long)newMsgCount);
        } else if (dropCount < newMsgCount) {
            List<SubMessage> subMessages = dropCount > 0 ? messages.subList(0, newMsgCount - dropCount) : messages;
            writer.insert(keyGenerator.apply(inboxKeyPrefix, nextSeq), this.buildInboxMessageList(nextSeq, subMessages).toByteString());
            nextSeq += (long)subMessages.size();
        }
        startSeqSetter.apply(startSeq);
        nextSeqSetter.apply(nextSeq);
        return Math.max(dropCount, 0);
    }

    private InboxMessageList buildInboxMessageList(long beginSeq, List<SubMessage> subMessages) {
        InboxMessageList.Builder listBuilder = InboxMessageList.newBuilder();
        for (SubMessage subMessage : subMessages) {
            listBuilder.addMessage(InboxMessage.newBuilder().setSeq(beginSeq).putAllMatchedTopicFilter(subMessage.matchedTopicFilters).setMsg(TopicMessage.newBuilder().setTopic(subMessage.topic).setPublisher(subMessage.publisher).setMessage(subMessage.message).build()).build());
            ++beginSeq;
        }
        return listBuilder.build();
    }

    private Runnable batchCommit(BatchCommitRequest request, BatchCommitReply.Builder replyBuilder, boolean isLeader, IKVRangeReader reader, IKVWriter writer) {
        HashMap<String, Map> toBeCached = new HashMap<String, Map>();
        for (BatchCommitRequest.Params params : request.getParamsList()) {
            Optional<InboxMetadata> metadataOpt = this.inboxMetaCache.get(params.getTenantId(), params.getInboxId(), params.getVersion().getIncarnation(), this.inboxMetadataProvider(reader));
            if (metadataOpt.isEmpty()) {
                replyBuilder.addCode(BatchCommitReply.Code.NO_INBOX);
                continue;
            }
            if (metadataOpt.get().getMod() != params.getVersion().getMod()) {
                replyBuilder.addCode(BatchCommitReply.Code.CONFLICT);
                continue;
            }
            ByteString inboxInstStartKey = KVSchemaUtil.inboxInstanceStartKey((String)params.getTenantId(), (String)params.getInboxId(), (long)params.getVersion().getIncarnation());
            InboxMetadata metadata = metadataOpt.get();
            InboxMetadata.Builder metaBuilder = metadata.toBuilder();
            this.commitInbox(inboxInstStartKey, params, metaBuilder, reader, writer);
            metadata = metaBuilder.setLastActiveTime(params.getNow()).build();
            writer.put(inboxInstStartKey, metadata.toByteString());
            replyBuilder.addCode(BatchCommitReply.Code.OK);
            toBeCached.computeIfAbsent(params.getTenantId(), k -> new HashMap()).put(metadata, false);
        }
        return () -> this.updateTenantStates(toBeCached, isLeader);
    }

    private void commitInbox(ByteString scopedInboxId, BatchCommitRequest.Params params, InboxMetadata.Builder metaBuilder, IKVRangeReader reader, IKVWriter writer) {
        long commitSeq;
        long nextSeq;
        long startSeq;
        if (params.hasQos0UpToSeq()) {
            startSeq = metaBuilder.getQos0StartSeq();
            nextSeq = metaBuilder.getQos0NextSeq();
            commitSeq = params.getQos0UpToSeq();
            this.commitToInbox(scopedInboxId, startSeq, nextSeq, commitSeq, KVSchemaUtil::qos0MsgKey, arg_0 -> ((InboxMetadata.Builder)metaBuilder).setQos0StartSeq(arg_0), reader, writer);
        }
        if (params.hasSendBufferUpToSeq()) {
            startSeq = metaBuilder.getSendBufferStartSeq();
            nextSeq = metaBuilder.getSendBufferNextSeq();
            commitSeq = params.getSendBufferUpToSeq();
            this.commitToInbox(scopedInboxId, startSeq, nextSeq, commitSeq, KVSchemaUtil::bufferedMsgKey, arg_0 -> ((InboxMetadata.Builder)metaBuilder).setSendBufferStartSeq(arg_0), reader, writer);
        }
    }

    private void commitToInbox(ByteString scopedInboxId, long startSeq, long nextSeq, long commitSeq, BiFunction<ByteString, Long, ByteString> keyGenerator, Function<Long, InboxMetadata.Builder> metadataSetter, IKVRangeReader reader, IKVWriter writer) {
        if (startSeq <= commitSeq && commitSeq < nextSeq) {
            ByteString msgKey;
            Optional msgListData;
            if (startSeq == commitSeq) {
                writer.delete(keyGenerator.apply(scopedInboxId, startSeq));
                metadataSetter.apply(startSeq + 1L);
                return;
            }
            Optional nextChunk = reader.get(keyGenerator.apply(scopedInboxId, commitSeq + 1L));
            if (nextChunk.isPresent()) {
                writer.clear(Boundary.newBuilder().setStartKey(keyGenerator.apply(scopedInboxId, startSeq)).setEndKey(keyGenerator.apply(scopedInboxId, commitSeq + 1L)).build());
                metadataSetter.apply(commitSeq + 1L);
                return;
            }
            while (startSeq <= commitSeq && !(msgListData = reader.get(msgKey = keyGenerator.apply(scopedInboxId, startSeq))).isEmpty()) {
                List msgList = ((InboxMessageList)ZeroCopyParser.parse((ByteString)((ByteString)msgListData.get()), (Parser)InboxMessageList.parser())).getMessageList();
                long lastSeq = ((InboxMessage)msgList.get(msgList.size() - 1)).getSeq();
                if (lastSeq <= commitSeq) {
                    writer.delete(msgKey);
                    startSeq = lastSeq + 1L;
                    continue;
                }
                writer.delete(msgKey);
                msgList = msgList.subList((int)(commitSeq - startSeq + 1L), msgList.size());
                writer.insert(keyGenerator.apply(scopedInboxId, commitSeq + 1L), InboxMessageList.newBuilder().addAllMessage(msgList).build().toByteString());
                startSeq = commitSeq + 1L;
                break;
            }
            metadataSetter.apply(startSeq);
        }
    }

    private CompletableFuture<ExpireTenantReply> expireTenant(ExpireTenantRequest request, IKVRangeReader reader) {
        return this.expireTenant(request.getTenantId(), Duration.ofSeconds(request.getExpirySeconds()), request.getNow(), reader).thenApply(v -> ExpireTenantReply.newBuilder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> expireTenant(String tenantId, Duration expireTime, long now, IKVRangeReader reader) {
        String inboxId = null;
        ByteString beginKeyPrefix = KVSchemaUtil.tenantBeginKeyPrefix((String)tenantId);
        TreeMap<Long, InboxMetadata> inboxVersions = new TreeMap<Long, InboxMetadata>();
        LinkedList<CompletableFuture<ExpireCheckResult>> onlineCheckFutures = new LinkedList<CompletableFuture<ExpireCheckResult>>();
        int probe = 0;
        try (IKVIterator itr = reader.iterator(Boundary.newBuilder().setStartKey(beginKeyPrefix).setEndKey(BoundaryUtil.upperBound((ByteString)beginKeyPrefix)).build());){
            itr.seek(beginKeyPrefix);
            while (itr.isValid() && itr.key().startsWith(beginKeyPrefix)) {
                if (KVSchemaUtil.isInboxInstanceStartKey((ByteString)itr.key())) {
                    try {
                        InboxMetadata inboxMetadata = InboxMetadata.parseFrom((ByteString)itr.value());
                        if (inboxId == null) {
                            inboxId = inboxMetadata.getInboxId();
                            inboxVersions.put(inboxMetadata.getIncarnation(), inboxMetadata);
                            continue;
                        }
                        if (inboxId.equals(inboxMetadata.getInboxId())) {
                            inboxVersions.put(inboxMetadata.getIncarnation(), inboxMetadata);
                            continue;
                        }
                        this.checkInboxOnline(tenantId, expireTime, now, inboxVersions, onlineCheckFutures);
                        inboxVersions.clear();
                        inboxId = inboxMetadata.getInboxId();
                        inboxVersions.put(inboxMetadata.getIncarnation(), inboxMetadata);
                        continue;
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.error("Unexpected error", (Throwable)e);
                        continue;
                    }
                    finally {
                        itr.next();
                        ++probe;
                        continue;
                    }
                }
                if (probe < 20) {
                    itr.next();
                    ++probe;
                    continue;
                }
                if (KVSchemaUtil.isInboxInstanceKey((ByteString)itr.key())) {
                    itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)itr.key())));
                    continue;
                }
                itr.next();
                ++probe;
            }
        }
        if (inboxId != null) {
            this.checkInboxOnline(tenantId, expireTime, now, inboxVersions, onlineCheckFutures);
        }
        return CompletableFuture.allOf((CompletableFuture[])onlineCheckFutures.toArray(CompletableFuture[]::new)).thenAccept(v -> {
            for (CompletableFuture future : onlineCheckFutures) {
                ExpireCheckResult result = (ExpireCheckResult)future.join();
                if (!result.expired) continue;
                TenantInboxInstance inboxInstance = new TenantInboxInstance((String)TenantIdCanon.TENANT_ID_INTERNER.intern((Object)tenantId), new InboxInstance(result.metadata.getInboxId(), result.metadata.getIncarnation()));
                this.delayTaskRunner.schedule(inboxInstance, new ExpireInboxTask(Duration.ofMillis(0L), result.metadata.getMod(), this.inboxClient));
            }
        });
    }

    private void checkInboxOnline(String tenantId, Duration expireTime, long now, SortedMap<Long, InboxMetadata> inboxVersions, List<CompletableFuture<ExpireCheckResult>> futuresHolder) {
        InboxMetadata latestInboxMetadata;
        if (inboxVersions.size() > 1) {
            long latestVersion = inboxVersions.lastKey();
            for (long olderVersion : inboxVersions.headMap(latestVersion).keySet()) {
                InboxMetadata metadata = (InboxMetadata)inboxVersions.get(olderVersion);
                futuresHolder.add(CompletableFuture.completedFuture(new ExpireCheckResult(metadata, true)));
            }
            latestInboxMetadata = (InboxMetadata)inboxVersions.get(latestVersion);
        } else {
            latestInboxMetadata = (InboxMetadata)inboxVersions.get(inboxVersions.firstKey());
        }
        if (latestInboxMetadata.hasDetachedAt()) {
            long detachedAtMillis = latestInboxMetadata.getDetachedAt();
            int expireSeconds = InboxStoreCoProc.getExpireSeconds(expireTime, latestInboxMetadata);
            if (Integer.compareUnsigned(expireSeconds, -1) == 0) {
                futuresHolder.add(CompletableFuture.completedFuture(new ExpireCheckResult(latestInboxMetadata, false)));
            } else {
                long expireMillis = Duration.ofSeconds(expireSeconds).toMillis();
                if (detachedAtMillis + expireMillis + 5000L > now) {
                    futuresHolder.add(CompletableFuture.completedFuture(new ExpireCheckResult(latestInboxMetadata, false)));
                } else {
                    futuresHolder.add(CompletableFuture.completedFuture(new ExpireCheckResult(latestInboxMetadata, true)));
                }
            }
        } else {
            int expireSeconds = latestInboxMetadata.getExpirySeconds();
            if (Integer.compareUnsigned(expireSeconds, -1) == 0) {
                futuresHolder.add(CompletableFuture.completedFuture(new ExpireCheckResult(latestInboxMetadata, false)));
            } else {
                long detachTimeoutMillis;
                long lastActiveTime = latestInboxMetadata.getLastActiveTime();
                if (lastActiveTime + (detachTimeoutMillis = this.detachTimeout.toMillis()) > now) {
                    futuresHolder.add(CompletableFuture.completedFuture(new ExpireCheckResult(latestInboxMetadata, false)));
                } else {
                    OnlineCheckRequest clientId = new OnlineCheckRequest(tenantId, (String)latestInboxMetadata.getClient().getMetadataMap().get("userId"), (String)latestInboxMetadata.getClient().getMetadataMap().get("clientId"));
                    futuresHolder.add((CompletableFuture<ExpireCheckResult>)((CompletableFuture)this.sessionDictClient.exist(clientId).exceptionally(e -> OnlineCheckResult.ERROR)).thenApply(v -> {
                        if (v == OnlineCheckResult.NOT_EXISTS) {
                            return new ExpireCheckResult(latestInboxMetadata, true);
                        }
                        return new ExpireCheckResult(latestInboxMetadata, false);
                    }));
                }
            }
        }
    }

    private void updateTenantStates(Map<String, Map<InboxMetadata, Boolean>> toBeUpdated, boolean isLeader) {
        toBeUpdated.forEach((tenantId, inboxes) -> inboxes.forEach((inboxMetadata, isNew) -> {
            this.inboxMetaCache.upsert((String)tenantId, (InboxMetadata)inboxMetadata);
            if (isNew.booleanValue()) {
                this.tenantStats.addSessionCount((String)tenantId, 1);
                if (isLeader) {
                    this.eventCollector.report((Event)((MQTTSessionStart)ThreadLocalEventPool.getLocal(MQTTSessionStart.class)).sessionId(inboxMetadata.getInboxId()).clientInfo(inboxMetadata.getClient()));
                }
            }
        }));
        this.tenantStats.toggleMetering(isLeader);
    }

    private void removeTenantStates(Map<String, Map<InboxMetadata, Boolean>> toBeRemoved, boolean isLeader) {
        toBeRemoved.forEach((tenantId, inboxSet) -> inboxSet.forEach((inboxMetadata, isCleared) -> {
            this.inboxMetaCache.remove((String)tenantId, inboxMetadata.getInboxId(), inboxMetadata.getIncarnation());
            if (isCleared.booleanValue()) {
                int topicFiltersCount = inboxMetadata.getTopicFiltersCount();
                if (topicFiltersCount > 0) {
                    this.tenantStats.addSubCount((String)tenantId, -topicFiltersCount);
                }
                this.tenantStats.addSessionCount((String)tenantId, -1);
                if (isLeader) {
                    this.eventCollector.report((Event)((MQTTSessionStop)ThreadLocalEventPool.getLocal(MQTTSessionStop.class)).sessionId(inboxMetadata.getInboxId()).clientInfo(inboxMetadata.getClient()));
                }
            }
        }));
    }

    private boolean hasExpired(InboxMetadata metadata, long nowTS) {
        if (!metadata.hasDetachedAt()) {
            return false;
        }
        return Duration.ofMillis(metadata.getDetachedAt()).plusSeconds(metadata.getExpirySeconds()).toMillis() < nowTS;
    }

    private Optional<InboxMetadata> getLatestInboxVersion(String tenantId, String inboxId, IKVRangeReader reader) {
        ByteString inboxStartKey = KVSchemaUtil.inboxStartKeyPrefix((String)tenantId, (String)inboxId);
        try (IKVIterator itr = reader.iterator(Boundary.newBuilder().setStartKey(inboxStartKey).setEndKey(BoundaryUtil.upperBound((ByteString)inboxStartKey)).build());){
            itr.seekToLast();
            if (!itr.isValid() || !itr.key().startsWith(inboxStartKey)) {
                Optional<InboxMetadata> optional = Optional.empty();
                return optional;
            }
            Optional inboxMetaBytes = reader.get(KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)itr.key()));
            if (inboxMetaBytes.isEmpty()) {
                log.warn("Inconsistent state: missing inbox meta: tenantId={}, inboxId={}", (Object)tenantId, (Object)inboxId);
                Optional<InboxMetadata> optional = Optional.empty();
                return optional;
            }
            Optional<InboxMetadata> optional = Optional.of(InboxMetadata.parseFrom((ByteString)((ByteString)inboxMetaBytes.get())));
            return optional;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<Long, InboxMetadata> getAllInboxVersions(String tenantId, String inboxId, IKVRangeReader reader) {
        int probe = 0;
        ConcurrentSkipListMap<Long, InboxMetadata> inboxInstances = new ConcurrentSkipListMap<Long, InboxMetadata>();
        ByteString inboxStartKey = KVSchemaUtil.inboxStartKeyPrefix((String)tenantId, (String)inboxId);
        try (IKVIterator itr = reader.iterator(Boundary.newBuilder().setStartKey(inboxStartKey).setEndKey(BoundaryUtil.upperBound((ByteString)inboxStartKey)).build());){
            itr.seek(inboxStartKey);
            while (itr.isValid() && itr.key().startsWith(inboxStartKey)) {
                if (KVSchemaUtil.isInboxInstanceStartKey((ByteString)itr.key())) {
                    probe = 0;
                    try {
                        InboxMetadata inboxMetadata = InboxMetadata.parseFrom((ByteString)itr.value());
                        inboxInstances.put(inboxMetadata.getIncarnation(), inboxMetadata);
                        continue;
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.error("Unexpected error", (Throwable)e);
                        continue;
                    }
                    finally {
                        itr.next();
                        ++probe;
                        continue;
                    }
                }
                if (probe < 20) {
                    itr.next();
                    ++probe;
                    continue;
                }
                if (KVSchemaUtil.isInboxInstanceKey((ByteString)itr.key())) {
                    itr.seek(BoundaryUtil.upperBound((ByteString)KVSchemaUtil.parseInboxInstanceStartKeyPrefix((ByteString)itr.key())));
                    continue;
                }
                itr.next();
                ++probe;
            }
        }
        return inboxInstances;
    }

    private IInboxMetaCache.InboxMetadataProvider inboxMetadataProvider(IKVRangeReader reader) {
        return (tenantId, inboxId, incarnation) -> this.getInboxVersion(tenantId, inboxId, incarnation, reader);
    }

    private InboxMetadata getInboxVersion(String tenantId, String inboxId, long incarnation, IKVRangeReader reader) {
        ByteString inboxInstanceMetaKey = KVSchemaUtil.inboxInstanceStartKey((String)tenantId, (String)inboxId, (long)incarnation);
        Optional metaBytes = reader.get(inboxInstanceMetaKey);
        if (metaBytes.isEmpty()) {
            return null;
        }
        try {
            return InboxMetadata.parseFrom((ByteString)((ByteString)metaBytes.get()));
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Unexpected error", (Throwable)e);
            return null;
        }
    }

    private record SubMessage(String topic, ClientInfo publisher, Message message, Map<String, TopicFilterOption> matchedTopicFilters) {
    }

    private record ExpireCheckResult(InboxMetadata metadata, boolean expired) {
    }
}

