/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.s7.readwrite.MemoryArea;
import org.apache.plc4x.java.s7.readwrite.S7Address;
import org.apache.plc4x.java.s7.readwrite.TransportSize;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class S7AddressAny
extends S7Address
implements Message {
    protected final TransportSize transportSize;
    protected final int numberOfElements;
    protected final int dbNumber;
    protected final MemoryArea area;
    protected final int byteAddress;
    protected final byte bitAddress;

    @Override
    public Short getAddressType() {
        return (short)16;
    }

    public S7AddressAny(TransportSize transportSize, int numberOfElements, int dbNumber, MemoryArea area, int byteAddress, byte bitAddress) {
        this.transportSize = transportSize;
        this.numberOfElements = numberOfElements;
        this.dbNumber = dbNumber;
        this.area = area;
        this.byteAddress = byteAddress;
        this.bitAddress = bitAddress;
    }

    public TransportSize getTransportSize() {
        return this.transportSize;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public int getDbNumber() {
        return this.dbNumber;
    }

    public MemoryArea getArea() {
        return this.area;
    }

    public int getByteAddress() {
        return this.byteAddress;
    }

    public byte getBitAddress() {
        return this.bitAddress;
    }

    @Override
    protected void serializeS7AddressChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("S7AddressAny", new WithWriterArgs[0]);
        FieldWriterFactory.writeEnumField((String)"transportSize", (String)"TransportSize", (Object)((Object)this.transportSize), (DataWriter)new DataWriterEnumDefault(TransportSize::getCode, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"numberOfElements", (Object)this.numberOfElements, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dbNumber", (Object)this.dbNumber, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"area", (String)"MemoryArea", (Object)((Object)this.area), (DataWriter)new DataWriterEnumDefault(MemoryArea::getValue, Enum::name, DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)5), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"byteAddress", (Object)this.byteAddress, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"bitAddress", (Object)this.bitAddress, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)3), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("S7AddressAny", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        S7AddressAny _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        lengthInBits += 5;
        lengthInBits += 16;
        return lengthInBits += 3;
    }

    public static S7Address.S7AddressBuilder staticParseS7AddressBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("S7AddressAny", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        TransportSize transportSize = (TransportSize)((Object)FieldReaderFactory.readEnumField((String)"transportSize", (String)"TransportSize", (DataReader)DataReaderFactory.readEnum(TransportSize::firstEnumForFieldCode, (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        int numberOfElements = (Integer)FieldReaderFactory.readSimpleField((String)"numberOfElements", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int dbNumber = (Integer)FieldReaderFactory.readSimpleField((String)"dbNumber", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        MemoryArea area = (MemoryArea)((Object)FieldReaderFactory.readEnumField((String)"area", (String)"MemoryArea", (DataReader)new DataReaderEnumDefault(MemoryArea::enumForValue, DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8)), (WithReaderArgs[])new WithReaderArgs[0]));
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)5), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        int byteAddress = (Integer)FieldReaderFactory.readSimpleField((String)"byteAddress", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        byte bitAddress = (Byte)FieldReaderFactory.readSimpleField((String)"bitAddress", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)3), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("S7AddressAny", new WithReaderArgs[0]);
        return new S7AddressAnyBuilderImpl(transportSize, numberOfElements, dbNumber, area, byteAddress, bitAddress);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S7AddressAny)) {
            return false;
        }
        S7AddressAny that = (S7AddressAny)o;
        return this.getTransportSize() == that.getTransportSize() && this.getNumberOfElements() == that.getNumberOfElements() && this.getDbNumber() == that.getDbNumber() && this.getArea() == that.getArea() && this.getByteAddress() == that.getByteAddress() && this.getBitAddress() == that.getBitAddress() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getTransportSize(), this.getNumberOfElements(), this.getDbNumber(), this.getArea(), this.getByteAddress(), this.getBitAddress()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class S7AddressAnyBuilderImpl
    implements S7Address.S7AddressBuilder {
        private final TransportSize transportSize;
        private final int numberOfElements;
        private final int dbNumber;
        private final MemoryArea area;
        private final int byteAddress;
        private final byte bitAddress;

        public S7AddressAnyBuilderImpl(TransportSize transportSize, int numberOfElements, int dbNumber, MemoryArea area, int byteAddress, byte bitAddress) {
            this.transportSize = transportSize;
            this.numberOfElements = numberOfElements;
            this.dbNumber = dbNumber;
            this.area = area;
            this.byteAddress = byteAddress;
            this.bitAddress = bitAddress;
        }

        @Override
        public S7AddressAny build() {
            S7AddressAny s7AddressAny = new S7AddressAny(this.transportSize, this.numberOfElements, this.dbNumber, this.area, this.byteAddress, this.bitAddress);
            return s7AddressAny;
        }
    }
}

