/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.uds.codes.msgpack;

import com.google.common.primitives.Chars;
import com.xiaomi.data.push.uds.codes.msgpack.Registry;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageUnpacker;

public class MsgpackUtils {
    public static Map<Class, Registry> registryMap = new HashMap<Class, Registry>();

    private static void pack(Object obj, MessageBufferPacker packer, ExRunnable runnable) {
        if (null == obj) {
            packer.packByte((byte)0);
        } else {
            packer.packByte((byte)1);
            runnable.run();
        }
    }

    public static void encode(Object obj, Class clazz, MessageBufferPacker packer) {
        if (registryMap.containsKey(clazz)) {
            Registry registry = registryMap.get(clazz);
            packer.packString("REGISTRY_" + clazz.getName());
            MsgpackUtils.pack(obj, packer, () -> {
                byte[] data = registry.encode(obj);
                packer.packInt(data.length);
                packer.addPayload(data);
            });
            return;
        }
        if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Integer.class)) {
            packer.packString("int");
            MsgpackUtils.pack(obj, packer, () -> packer.packInt(((Integer)obj).intValue()));
            return;
        }
        if (clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Float.class)) {
            packer.packString("float");
            MsgpackUtils.pack(obj, packer, () -> packer.packFloat(((Float)obj).floatValue()));
            return;
        }
        if (clazz.isAssignableFrom(Double.TYPE) || clazz.isAssignableFrom(Double.class)) {
            packer.packString("double");
            MsgpackUtils.pack(obj, packer, () -> packer.packDouble(((Double)obj).doubleValue()));
            return;
        }
        if (clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Byte.class)) {
            packer.packString("byte");
            MsgpackUtils.pack(obj, packer, () -> packer.packByte(((Byte)obj).byteValue()));
            return;
        }
        if (clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Short.class)) {
            packer.packString("short");
            MsgpackUtils.pack(obj, packer, () -> packer.packShort(((Short)obj).shortValue()));
            return;
        }
        if (clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Long.class)) {
            packer.packString("long");
            MsgpackUtils.pack(obj, packer, () -> packer.packLong(((Long)obj).longValue()));
            return;
        }
        if (clazz.isAssignableFrom(Character.TYPE) || clazz.isAssignableFrom(Character.class)) {
            packer.packString("char");
            byte[] data = Chars.toByteArray((char)((Character)obj).charValue());
            MsgpackUtils.pack(obj, packer, () -> {
                packer.packByte(data[0]);
                packer.packByte(data[1]);
            });
            return;
        }
        if (clazz.equals(String.class)) {
            packer.packString("String");
            MsgpackUtils.pack(obj, packer, () -> packer.packString(obj.toString()));
            return;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            String clazzName = null != obj ? obj.getClass().getName() : clazz.getName();
            packer.packString("COLLECTION_" + clazzName);
            MsgpackUtils.pack(obj, packer, () -> {
                Collection c = (Collection)obj;
                for (Object v : c) {
                    MsgpackUtils.encode(v, v.getClass(), packer);
                }
            });
            packer.packString("_COLLECTION");
            return;
        }
        if (clazz.isArray()) {
            String clazzName = null != obj ? obj.getClass().getComponentType().getName() : clazz.getComponentType().getName();
            packer.packString("ARRAY_" + clazzName);
            MsgpackUtils.pack(obj, packer, () -> {
                int len = Array.getLength(obj);
                packer.packInt(len);
                for (int i = 0; i < len; ++i) {
                    Object v = Array.get(obj, i);
                    MsgpackUtils.encode(v, v.getClass(), packer);
                }
            });
            packer.packString("_ARRAY");
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            String clazzName = null != obj ? obj.getClass().getName() : clazz.getName();
            packer.packString("MAP_" + clazzName);
            MsgpackUtils.pack(obj, packer, () -> {
                Map map = (Map)obj;
                map.entrySet().forEach(e -> {
                    Map.Entry en = (Map.Entry)e;
                    MsgpackUtils.encode(en.getKey(), en.getKey().getClass(), packer);
                    MsgpackUtils.encode(en.getValue(), en.getKey().getClass(), packer);
                });
            });
            packer.packString("_MAP" + clazz.getName());
            return;
        }
        if (clazz instanceof Object) {
            packer.packString("CLASS_" + obj.getClass().getName());
            MsgpackUtils.pack(obj, packer, () -> {
                Field[] fields = obj.getClass().getDeclaredFields();
                Arrays.stream(fields).forEach(it -> {
                    try {
                        it.setAccessible(true);
                        Object v = it.get(obj);
                        MsgpackUtils.encode(v, it.getType(), packer);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
            });
            packer.packString("_CLASS");
        }
    }

    private static Object unpack(MessageUnpacker unpacker, ExCallable callable) {
        byte b = unpacker.unpackByte();
        if (b == 0) {
            return null;
        }
        return callable.call();
    }

    public static Object decode(MessageUnpacker unpacker) {
        String str = unpacker.unpackString();
        if (str.startsWith("REGISTRY_")) {
            String[] ss = str.split("_");
            Class<?> clazz = Class.forName(ss[1]);
            Registry registry = registryMap.get(clazz);
            byte b = unpacker.unpackByte();
            if (0 == b) {
                return null;
            }
            int size = unpacker.unpackInt();
            byte[] data = new byte[size];
            unpacker.readPayload(data);
            return registry.decode(data);
        }
        if (str.equals("_CLASS")) {
            return null;
        }
        if (str.equals("_COLLECTION")) {
            return null;
        }
        if (str.equals("_MAP")) {
            return null;
        }
        if (str.startsWith("COLLECTION_")) {
            return MsgpackUtils.unpack(unpacker, () -> {
                Object v;
                String[] ss = str.split("_");
                Collection collection = (Collection)Class.forName(ss[1]).newInstance();
                while (null != (v = MsgpackUtils.decode(unpacker))) {
                    collection.add(v);
                }
                return collection;
            });
        }
        if (str.startsWith("ARRAY_")) {
            return MsgpackUtils.unpack(unpacker, () -> {
                Object v;
                String[] ss = str.split("_");
                String type = ss[1];
                int len = unpacker.unpackInt();
                Object array = Array.newInstance(MsgpackUtils.getClass(type), len);
                int i = 0;
                while (null != (v = MsgpackUtils.decode(unpacker))) {
                    Array.set(array, i, v);
                    ++i;
                }
                return array;
            });
        }
        if (str.startsWith("MAP_")) {
            return MsgpackUtils.unpack(unpacker, () -> {
                Object key;
                String[] ss = str.split("_");
                Map map = (Map)Class.forName(ss[1]).newInstance();
                while (null != (key = MsgpackUtils.decode(unpacker))) {
                    Object value = MsgpackUtils.decode(unpacker);
                    map.put(key, value);
                }
                return map;
            });
        }
        if (str.startsWith("CLASS_")) {
            return MsgpackUtils.unpack(unpacker, () -> {
                String[] ss = str.split("_");
                Object obj = Class.forName(ss[1]).newInstance();
                Field[] fields = obj.getClass().getDeclaredFields();
                Arrays.stream(fields).forEach(it -> {
                    try {
                        it.setAccessible(true);
                        it.set(obj, MsgpackUtils.decode(unpacker));
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                });
                unpacker.unpackString();
                return obj;
            });
        }
        if (str.equals("int")) {
            return MsgpackUtils.unpack(unpacker, () -> unpacker.unpackInt());
        }
        if (str.equals("String")) {
            return MsgpackUtils.unpack(unpacker, () -> unpacker.unpackString());
        }
        if (str.equals("long")) {
            return MsgpackUtils.unpack(unpacker, () -> unpacker.unpackLong());
        }
        if (str.equals("float")) {
            return MsgpackUtils.unpack(unpacker, () -> Float.valueOf(unpacker.unpackFloat()));
        }
        if (str.equals("double")) {
            return MsgpackUtils.unpack(unpacker, () -> unpacker.unpackDouble());
        }
        if (str.equals("byte")) {
            return MsgpackUtils.unpack(unpacker, () -> unpacker.unpackByte());
        }
        if (str.equals("short")) {
            return MsgpackUtils.unpack(unpacker, () -> unpacker.unpackShort());
        }
        if (str.equals("char")) {
            return MsgpackUtils.unpack(unpacker, () -> {
                byte b1 = unpacker.unpackByte();
                byte b2 = unpacker.unpackByte();
                return Character.valueOf(Chars.fromBytes((byte)b1, (byte)b2));
            });
        }
        return null;
    }

    private static Class getClass(String name) {
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        return Class.forName(name);
    }

    static interface ExRunnable {
        public void run() throws Exception;
    }

    static interface ExCallable {
        public Object call() throws Exception;
    }
}

