/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.model.pojo;

import java.io.Serializable;
import java.util.List;
import org.apache.ozhera.log.api.model.bo.MiLogResource;
import org.apache.ozhera.log.api.model.vo.ResourceInfo;
import org.apache.ozhera.log.manager.model.BaseCommon;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Table;

@Table(value="milog_middleware_config")
@Comment(value="Milog configures middleware configuration")
public class MilogMiddlewareConfig
extends BaseCommon
implements Serializable {
    @Id
    @Comment(value="Primary key Id")
    @ColDefine(customType="bigint")
    private Long id;
    @Column(value="type")
    @ColDefine(customType="smallint")
    @Comment(value="type  MiddlewareEnum.code")
    public Integer type;
    @Column(value="region_en")
    @ColDefine(type=ColType.VARCHAR, width=40)
    @Comment(value="type  MachineRegionEnum.en")
    private String regionEn;
    @Column(value="alias")
    @ColDefine(type=ColType.VARCHAR, width=128)
    @Comment(value="alias")
    public String alias;
    @Column(value="name_server")
    @ColDefine(type=ColType.VARCHAR, width=128)
    @Comment(value="nameServer address")
    private String nameServer;
    @Column(value="service_url")
    @ColDefine(type=ColType.VARCHAR, width=128)
    @Comment(value="nameServer address")
    private String serviceUrl;
    @Column(value="ak")
    @ColDefine(type=ColType.VARCHAR, width=200)
    @Comment(value="ak")
    private String ak;
    @Column(value="sk")
    @ColDefine(type=ColType.VARCHAR, width=200)
    @Comment(value="sk")
    private String sk;
    @Column(value="broker_name")
    @ColDefine(type=ColType.VARCHAR, width=200)
    @Comment(value="broker_name")
    private String brokerName;
    @Column(value="authorization")
    @ColDefine(type=ColType.VARCHAR, width=1024)
    @Comment(value="Authorization Information")
    private String authorization;
    @Column(value="org_id")
    @ColDefine(type=ColType.INT, width=20)
    @Comment(value="team Id")
    private String orgId;
    @Column(value="team_id")
    @ColDefine(type=ColType.INT, width=20)
    @Comment(value="user group ID")
    private String teamId;
    @Column(value="is_default")
    @ColDefine(type=ColType.INT, width=20)
    @Comment(value="Whether to default this configuration when mq is not selected (1.Yes 0.No)")
    private Integer isDefault;
    @Column(value="labels")
    @ColDefine(type=ColType.MYSQL_JSON)
    @Comment(value="A list of tags")
    private List<String> labels;
    @Column(value="token")
    @ColDefine(type=ColType.VARCHAR, width=255)
    @Comment(value="token")
    private String token;
    @Column(value="dt_catalog")
    @ColDefine(type=ColType.VARCHAR, width=255)
    @Comment(value="catalog")
    private String dtCatalog;
    @Column(value="dt_database")
    @ColDefine(type=ColType.VARCHAR, width=255)
    @Comment(value="database")
    private String dtDatabase;
    private String clusterName;
    private String storageType;

    public ResourceInfo configToResourceVO() {
        return ((ResourceInfo.ResourceInfoBuilder)((ResourceInfo.ResourceInfoBuilder)((ResourceInfo.ResourceInfoBuilder)((ResourceInfo.ResourceInfoBuilder)ResourceInfo.builder().id(this.id).alias(this.alias).regionEn(this.regionEn).regionCn(CommonExtensionServiceFactory.getCommonExtensionService().getMachineRoomName(this.regionEn)).clusterName(this.nameServer).serviceUrl(this.serviceUrl).brokerName(this.brokerName).storageType(this.storageType).ak(this.ak).sk(this.sk).orgId(this.orgId).teamId(this.teamId).labels(this.labels).mqType(this.type).ctime(this.getCtime())).utime(this.getUtime())).creator(this.getCreator())).updater(this.getUpdater())).build();
    }

    public static MilogMiddlewareConfig miLogMqResourceToConfig(MiLogResource resource) {
        MilogMiddlewareConfig milogMiddlewareConfig = new MilogMiddlewareConfig();
        milogMiddlewareConfig.setAlias(resource.getAlias());
        milogMiddlewareConfig.setType(null == resource.getMqType() ? resource.getResourceCode() : resource.getMqType());
        milogMiddlewareConfig.setRegionEn(resource.getRegionEn());
        milogMiddlewareConfig.setNameServer(resource.getClusterName());
        milogMiddlewareConfig.setServiceUrl(resource.getServiceUrl());
        milogMiddlewareConfig.setAk(resource.getAk());
        milogMiddlewareConfig.setSk(resource.getSk());
        milogMiddlewareConfig.setOrgId(resource.getOrgId());
        milogMiddlewareConfig.setTeamId(resource.getTeamId());
        milogMiddlewareConfig.setBrokerName(resource.getBrokerName());
        milogMiddlewareConfig.setLabels(resource.getLabels());
        milogMiddlewareConfig.setIsDefault(resource.getIsDefault());
        milogMiddlewareConfig.setStorageType(resource.getStorageType());
        return milogMiddlewareConfig;
    }

    public Long getId() {
        return this.id;
    }

    public Integer getType() {
        return this.type;
    }

    public String getRegionEn() {
        return this.regionEn;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getAk() {
        return this.ak;
    }

    public String getSk() {
        return this.sk;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public Integer getIsDefault() {
        return this.isDefault;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getToken() {
        return this.token;
    }

    public String getDtCatalog() {
        return this.dtCatalog;
    }

    public String getDtDatabase() {
        return this.dtDatabase;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setRegionEn(String regionEn) {
        this.regionEn = regionEn;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDtCatalog(String dtCatalog) {
        this.dtCatalog = dtCatalog;
    }

    public void setDtDatabase(String dtDatabase) {
        this.dtDatabase = dtDatabase;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MilogMiddlewareConfig)) {
            return false;
        }
        MilogMiddlewareConfig other = (MilogMiddlewareConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$isDefault = this.getIsDefault();
        Integer other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        String this$regionEn = this.getRegionEn();
        String other$regionEn = other.getRegionEn();
        if (this$regionEn == null ? other$regionEn != null : !this$regionEn.equals(other$regionEn)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$nameServer = this.getNameServer();
        String other$nameServer = other.getNameServer();
        if (this$nameServer == null ? other$nameServer != null : !this$nameServer.equals(other$nameServer)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$ak = this.getAk();
        String other$ak = other.getAk();
        if (this$ak == null ? other$ak != null : !this$ak.equals(other$ak)) {
            return false;
        }
        String this$sk = this.getSk();
        String other$sk = other.getSk();
        if (this$sk == null ? other$sk != null : !this$sk.equals(other$sk)) {
            return false;
        }
        String this$brokerName = this.getBrokerName();
        String other$brokerName = other.getBrokerName();
        if (this$brokerName == null ? other$brokerName != null : !this$brokerName.equals(other$brokerName)) {
            return false;
        }
        String this$authorization = this.getAuthorization();
        String other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$teamId = this.getTeamId();
        String other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$dtCatalog = this.getDtCatalog();
        String other$dtCatalog = other.getDtCatalog();
        if (this$dtCatalog == null ? other$dtCatalog != null : !this$dtCatalog.equals(other$dtCatalog)) {
            return false;
        }
        String this$dtDatabase = this.getDtDatabase();
        String other$dtDatabase = other.getDtDatabase();
        if (this$dtDatabase == null ? other$dtDatabase != null : !this$dtDatabase.equals(other$dtDatabase)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$storageType = this.getStorageType();
        String other$storageType = other.getStorageType();
        return !(this$storageType == null ? other$storageType != null : !this$storageType.equals(other$storageType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MilogMiddlewareConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        String $regionEn = this.getRegionEn();
        result = result * 59 + ($regionEn == null ? 43 : $regionEn.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $nameServer = this.getNameServer();
        result = result * 59 + ($nameServer == null ? 43 : $nameServer.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $ak = this.getAk();
        result = result * 59 + ($ak == null ? 43 : $ak.hashCode());
        String $sk = this.getSk();
        result = result * 59 + ($sk == null ? 43 : $sk.hashCode());
        String $brokerName = this.getBrokerName();
        result = result * 59 + ($brokerName == null ? 43 : $brokerName.hashCode());
        String $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $dtCatalog = this.getDtCatalog();
        result = result * 59 + ($dtCatalog == null ? 43 : $dtCatalog.hashCode());
        String $dtDatabase = this.getDtDatabase();
        result = result * 59 + ($dtDatabase == null ? 43 : $dtDatabase.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $storageType = this.getStorageType();
        result = result * 59 + ($storageType == null ? 43 : $storageType.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MilogMiddlewareConfig(id=" + this.getId() + ", type=" + this.getType() + ", regionEn=" + this.getRegionEn() + ", alias=" + this.getAlias() + ", nameServer=" + this.getNameServer() + ", serviceUrl=" + this.getServiceUrl() + ", ak=" + this.getAk() + ", sk=" + this.getSk() + ", brokerName=" + this.getBrokerName() + ", authorization=" + this.getAuthorization() + ", orgId=" + this.getOrgId() + ", teamId=" + this.getTeamId() + ", isDefault=" + this.getIsDefault() + ", labels=" + String.valueOf(this.getLabels()) + ", token=" + this.getToken() + ", dtCatalog=" + this.getDtCatalog() + ", dtDatabase=" + this.getDtDatabase() + ", clusterName=" + this.getClusterName() + ", storageType=" + this.getStorageType() + ")";
    }
}

