/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanConfig {
    private static final Logger log = LoggerFactory.getLogger(DoceanConfig.class);
    private Properties properties;

    private DoceanConfig() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config.properties");
        this.properties = new Properties();
        try {
            this.properties.load(is);
        }
        catch (Exception e) {
            log.warn("load config error:{}", (Object)e.getMessage());
        }
    }

    public static DoceanConfig ins() {
        return LazyHolder.ins;
    }

    public String get(String key, String defaultValue) {
        return this.properties.getOrDefault((Object)key, defaultValue).toString().trim();
    }

    private static final class LazyHolder {
        private static final DoceanConfig ins = new DoceanConfig();

        private LazyHolder() {
        }
    }
}

