/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugin;

import java.util.ArrayList;
import java.util.List;
import org.nutz.lang.Lang;
import org.nutz.plugin.NoPluginCanWorkException;
import org.nutz.plugin.Plugin;
import org.nutz.plugin.PluginException;
import org.nutz.plugin.PluginManager;

public class SimplePluginManager<T>
implements PluginManager<T> {
    private List<Plugin> list = new ArrayList<Plugin>();

    public SimplePluginManager(String ... classNames) throws PluginException {
        if (classNames != null) {
            for (String className : classNames) {
                this.loadPlugin(className);
            }
        }
    }

    public SimplePluginManager(Class<? extends T> ... classNames) throws PluginException {
        if (classNames != null) {
            for (Class<? extends T> pluginClass : classNames) {
                this.loadPlugin(pluginClass);
            }
        }
    }

    @Override
    public T get() throws NoPluginCanWorkException {
        for (Plugin plugin : this.list) {
            if (!plugin.canWork()) continue;
            return (T)plugin;
        }
        throw new NoPluginCanWorkException();
    }

    @Override
    public List<T> gets() {
        ArrayList<Plugin> aList = new ArrayList<Plugin>(this.list.size());
        for (Plugin plugin : this.list) {
            if (!plugin.canWork()) continue;
            aList.add(plugin);
        }
        return aList;
    }

    protected void loadPlugin(Class<? extends T> pluginClass) throws PluginException {
        if (pluginClass != null) {
            try {
                this.list.add((Plugin)pluginClass.newInstance());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void loadPlugin(String pluginClassName) throws PluginException {
        if (pluginClassName != null) {
            try {
                this.loadPlugin(Lang.loadClass(pluginClassName));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

