/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.dubbo.common.Experimental;
import org.apache.dubbo.rpc.Invoker;

public interface Invocation {
    public String getTargetServiceUniqueName();

    public String getProtocolServiceKey();

    public String getMethodName();

    public String getServiceName();

    public Class<?>[] getParameterTypes();

    default public String[] getCompatibleParamSignatures() {
        return (String[])Stream.of(this.getParameterTypes()).map(Class::getName).toArray(String[]::new);
    }

    public Object[] getArguments();

    public Map<String, String> getAttachments();

    @Experimental(value="Experiment api for supporting Object transmission")
    public Map<String, Object> getObjectAttachments();

    public void setAttachment(String var1, String var2);

    @Experimental(value="Experiment api for supporting Object transmission")
    public void setAttachment(String var1, Object var2);

    @Experimental(value="Experiment api for supporting Object transmission")
    public void setObjectAttachment(String var1, Object var2);

    public void setAttachmentIfAbsent(String var1, String var2);

    @Experimental(value="Experiment api for supporting Object transmission")
    public void setAttachmentIfAbsent(String var1, Object var2);

    @Experimental(value="Experiment api for supporting Object transmission")
    public void setObjectAttachmentIfAbsent(String var1, Object var2);

    public String getAttachment(String var1);

    @Experimental(value="Experiment api for supporting Object transmission")
    public Object getObjectAttachment(String var1);

    public String getAttachment(String var1, String var2);

    @Experimental(value="Experiment api for supporting Object transmission")
    public Object getObjectAttachment(String var1, Object var2);

    public Invoker<?> getInvoker();

    public Object put(Object var1, Object var2);

    public Object get(Object var1);

    public Map<Object, Object> getAttributes();
}

