/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.support.GroupServiceKeyCache;

public class ProtocolUtils {
    private static final ConcurrentMap<String, GroupServiceKeyCache> groupServiceKeyCacheMap = new ConcurrentHashMap<String, GroupServiceKeyCache>();

    private ProtocolUtils() {
    }

    public static String serviceKey(URL url) {
        return ProtocolUtils.serviceKey(url.getPort(), url.getPath(), url.getParameter("version"), url.getParameter("group"));
    }

    public static String serviceKey(int port, String serviceName, String serviceVersion, String serviceGroup) {
        GroupServiceKeyCache groupServiceKeyCache = (GroupServiceKeyCache)groupServiceKeyCacheMap.get(serviceGroup = serviceGroup == null ? "" : serviceGroup);
        if (groupServiceKeyCache == null) {
            groupServiceKeyCacheMap.putIfAbsent(serviceGroup, new GroupServiceKeyCache(serviceGroup));
            groupServiceKeyCache = (GroupServiceKeyCache)groupServiceKeyCacheMap.get(serviceGroup);
        }
        return groupServiceKeyCache.getServiceKey(serviceName, serviceVersion, port);
    }

    public static boolean isGeneric(String generic) {
        return StringUtils.isNotEmpty(generic) && ("true".equalsIgnoreCase(generic) || "nativejava".equalsIgnoreCase(generic) || "bean".equalsIgnoreCase(generic) || "protobuf-json".equalsIgnoreCase(generic) || "youpin_json".equalsIgnoreCase(generic) || "raw.return".equalsIgnoreCase(generic));
    }

    public static boolean isValidGenericValue(String generic) {
        return ProtocolUtils.isGeneric(generic) || Boolean.FALSE.toString().equalsIgnoreCase(generic);
    }

    public static boolean isDefaultGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "true".equalsIgnoreCase(generic);
    }

    public static boolean isJavaGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "nativejava".equalsIgnoreCase(generic);
    }

    public static boolean isGsonGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "youpin_json".equalsIgnoreCase(generic);
    }

    public static boolean isBeanGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "bean".equals(generic);
    }

    public static boolean isProtobufGenericSerialization(String generic) {
        return ProtocolUtils.isGeneric(generic) && "protobuf-json".equals(generic);
    }

    public static boolean isGenericReturnRawResult(String generic) {
        return "raw.return".equals(generic);
    }

    public static Object getObj(Gson gson, String value, int index, Method method) throws IllegalArgumentException {
        Type[] types = method.getGenericParameterTypes();
        if (types[index].getTypeName().equals("java.lang.String")) {
            return value;
        }
        if (types[index].getTypeName().equals("int")) {
            return Integer.valueOf(value);
        }
        if (types[index].getTypeName().equals("long")) {
            return Long.valueOf(value);
        }
        if (types[index].getTypeName().equals("byte")) {
            if (value.getBytes().length == 1) {
                return value.getBytes()[0];
            }
            throw new IllegalArgumentException("params is wrong!");
        }
        if (types[index].getTypeName().equals("char")) {
            if (value.toCharArray().length == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new IllegalArgumentException("params is wrong!");
        }
        if (types[index].getTypeName().equals("boolean")) {
            return Boolean.valueOf(value);
        }
        return gson.fromJson(value, TypeToken.get((Type)types[index]).getType());
    }
}

