/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.common.trace;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.tspandata.TAttributeKey;
import org.apache.ozhera.tspandata.TAttributeType;
import org.apache.ozhera.tspandata.TAttributes;
import org.apache.ozhera.tspandata.TEvent;
import org.apache.ozhera.tspandata.TExtra;
import org.apache.ozhera.tspandata.TInstrumentationLibraryInfo;
import org.apache.ozhera.tspandata.TKind;
import org.apache.ozhera.tspandata.TLink;
import org.apache.ozhera.tspandata.TResource;
import org.apache.ozhera.tspandata.TSpanContext;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.ozhera.tspandata.TStatus;
import org.apache.ozhera.tspandata.TValue;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceUtil {
    private static final Logger log = LoggerFactory.getLogger(TraceUtil.class);
    private static final TProtocolFactory PROTOCOL_FACTORY = new TCompactProtocol.Factory();
    private static final String TAG_KEY_SPAN_KIND = "span.kind";
    private static final String TAG_KEY_SERVICE_NAME = "service.name";
    private static final String SPAN_KIND_INTERNAL = "INTERNAL";
    private static final String TAG_KEY_IP = "ip";
    private static final String TAG_KEY_HOST = "host.name";
    private static final Set<String> SPECIAL_TAG_KEYS = Sets.newHashSet((Object[])new String[]{"span.kind", "service.name", "ip", "host.name"});
    private static Pattern EMPTY_PATTERN = Pattern.compile("\\r\\n");

    public static byte[] toBytes(String spanStr) {
        try {
            TSpanData tSpanData = TraceUtil.toTSpanData(spanStr);
            return TraceUtil.toBytes(tSpanData);
        }
        catch (Throwable ex) {
            log.error("Failed to convert span to thrift,spanStr={}", (Object)spanStr, (Object)ex);
            return null;
        }
    }

    public static byte[] toBytes(TSpanData tSpanData) {
        if (tSpanData == null) {
            return null;
        }
        try {
            TSerializer serializer = new TSerializer(PROTOCOL_FACTORY);
            return serializer.serialize((TBase)tSpanData);
        }
        catch (TTransportException e) {
            log.error("Failed to convert span to thrift TTransportException", (Throwable)e);
        }
        catch (TException e) {
            log.error("Failed to convert span to thrift TException", (Throwable)e);
        }
        return null;
    }

    public static TSpanData toTSpanData(String spanStr) {
        String message;
        if ((spanStr = EMPTY_PATTERN.matcher(spanStr).replaceAll("")).contains(" ||| ")) {
            String[] messages = spanStr.split(" \\|\\|\\| ");
            message = messages[1];
        } else {
            message = spanStr.split(" \\| ")[1];
        }
        String[] messageArray = message.split(" ### ");
        if (messageArray.length != 12) {
            log.error("message count illegal : " + spanStr);
            return null;
        }
        return TraceUtil.toTSpanData(messageArray);
    }

    private static TSpanData toTSpanData(String[] array) {
        TSpanData span = new TSpanData();
        span.setTraceId(array[6]);
        span.setSpanId(array[7]);
        span.setName(array[4]);
        span.setStatus(TraceUtil.toTStatus(array[5]));
        span.setStartEpochNanos(Long.parseLong(array[0]));
        span.setEndEpochNanos(span.getStartEpochNanos() + Long.parseLong(array[1]));
        HashMap<String, TValue> specialAttrMap = new HashMap<String, TValue>();
        span.setAttributes(TraceUtil.toTAttributes(JSONArray.parseArray((String)TraceUtil.decodeLineBreak(array[8])), specialAttrMap));
        span.setTotalAttributeCount(span.getAttributes().getKeysSize());
        String spanKind = specialAttrMap.get(TAG_KEY_SPAN_KIND) == null ? SPAN_KIND_INTERNAL : ((TValue)specialAttrMap.get(TAG_KEY_SPAN_KIND)).getStringValue();
        span.setKind(TraceUtil.toTKind(spanKind));
        span.setEvents(TraceUtil.toTEventList(JSONArray.parseArray((String)TraceUtil.decodeLineBreak(array[9]))));
        span.setTotalRecordedEvents(span.getEventsSize());
        span.setResouce(TraceUtil.toTResource(JSONObject.parseObject((String)array[10]), specialAttrMap));
        span.setExtra(TraceUtil.toTExtra(specialAttrMap));
        AtomicReference<TSpanContext> parentSpanContextRef = new AtomicReference<TSpanContext>();
        span.setLinks(TraceUtil.toTLinkList(JSONArray.parseArray((String)array[11]), parentSpanContextRef));
        span.setParentSpanContext(parentSpanContextRef.get());
        span.setTotalRecordedLinks(span.getLinksSize());
        return span;
    }

    private static String decodeLineBreak(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value.replaceAll("\\\\", "\\\\\\\\").replaceAll("##r'", "\\\\\"").replaceAll("##n", "\\\\n").replaceAll("##r", "\\\\r").replaceAll("##t", "\\\\t").replaceAll("##tat", "\\\\tat").replaceAll("##'", "\\\\\"");
        }
        return value;
    }

    private static List<TLink> toTLinkList(JSONArray links, AtomicReference<TSpanContext> spanContextAtomicReference) {
        if (links == null) {
            return null;
        }
        ArrayList<TLink> ret = new ArrayList<TLink>(links.size());
        links.forEach(link -> {
            JSONObject linkJson = (JSONObject)link;
            if ("CHILD_OF".equals(linkJson.getString("refType"))) {
                spanContextAtomicReference.set(TraceUtil.toTSpanContext(linkJson));
            } else {
                ret.add(TraceUtil.toTLink(linkJson));
            }
        });
        return ret;
    }

    private static List<TEvent> toTEventList(JSONArray events) {
        if (events == null) {
            return null;
        }
        ArrayList<TEvent> ret = new ArrayList<TEvent>(events.size());
        events.forEach(event -> {
            JSONObject eventJson = (JSONObject)event;
            ret.add(TraceUtil.toTEvent(eventJson));
        });
        return ret;
    }

    private static TSpanContext toTSpanContext(JSONObject ctx) {
        if (ctx == null) {
            return null;
        }
        TSpanContext spanContext = new TSpanContext();
        spanContext.setTraceId(ctx.getString("traceID"));
        spanContext.setSpanId(ctx.getString("spanID"));
        return spanContext;
    }

    private static TInstrumentationLibraryInfo toTInstrumentationLibraryInfo(String name, String version) {
        if (name == null && version == null) {
            return null;
        }
        TInstrumentationLibraryInfo ret = new TInstrumentationLibraryInfo();
        ret.setName(name);
        ret.setVersion(version);
        return ret;
    }

    private static TResource toTResource(JSONObject resource, Map<String, TValue> specialAttrMap) {
        if (resource == null || !resource.containsKey((Object)"tags")) {
            return null;
        }
        TResource ret = new TResource();
        ret.setAttributes(TraceUtil.toTAttributes(resource.getJSONArray("tags"), specialAttrMap));
        return ret;
    }

    private static TAttributes toTAttributes(JSONArray attributes) {
        return TraceUtil.toTAttributes(attributes, null);
    }

    private static TAttributes toTAttributes(JSONArray attributes, Map<String, TValue> specialAttrMap) {
        if (attributes == null) {
            return null;
        }
        TAttributes ret = new TAttributes();
        ret.setKeys(new ArrayList());
        ret.setValues(new ArrayList());
        attributes.forEach(attr -> {
            JSONObject attrJson = (JSONObject)attr;
            TAttributeKey attributeKey = TraceUtil.toTAttributeKey(attrJson);
            Object value = attrJson.get((Object)"value");
            TValue attributeValue = new TValue();
            switch (attributeKey.getType()) {
                case LONG: {
                    if (value instanceof String) {
                        attributeValue.setLongValue(Long.valueOf((String)value).longValue());
                        break;
                    }
                    attributeValue.setLongValue(((Long)value).longValue());
                    break;
                }
                case DOUBLE: {
                    if (value instanceof String) {
                        attributeValue.setDoubleValue(Double.valueOf((String)value).doubleValue());
                        break;
                    }
                    attributeValue.setDoubleValue(((Double)value).doubleValue());
                    break;
                }
                case STRING: {
                    attributeValue.setStringValue(String.valueOf(value));
                    break;
                }
                case BOOLEAN: {
                    if (value instanceof String) {
                        attributeValue.setBoolValue(Boolean.valueOf((String)value).booleanValue());
                        break;
                    }
                    attributeValue.setBoolValue(((Boolean)value).booleanValue());
                }
            }
            if (specialAttrMap != null && SPECIAL_TAG_KEYS.contains(attributeKey.getValue())) {
                specialAttrMap.put(attributeKey.getValue(), attributeValue);
            }
            ret.getKeys().add(attributeKey);
            ret.getValues().add(attributeValue);
        });
        return ret;
    }

    private static TAttributeKey toTAttributeKey(JSONObject attrJson) {
        if (attrJson == null) {
            return null;
        }
        TAttributeKey ret = new TAttributeKey();
        ret.setType(TraceUtil.toTAttributeType(attrJson.getString("type")));
        ret.setValue(attrJson.getString("key"));
        return ret;
    }

    private static TAttributeType toTAttributeType(String type) {
        if (type == null) {
            return null;
        }
        switch (type = type.toUpperCase()) {
            case "INT64": {
                return TAttributeType.LONG;
            }
            case "FLOAT64": {
                return TAttributeType.DOUBLE;
            }
            case "STRING": {
                return TAttributeType.STRING;
            }
            case "BOOL": {
                return TAttributeType.BOOLEAN;
            }
        }
        return null;
    }

    private static TStatus toTStatus(String status) {
        if (status == null) {
            return null;
        }
        switch (status = status.toUpperCase()) {
            case "OK": {
                return TStatus.OK;
            }
            case "ERROR": {
                return TStatus.ERROR;
            }
            case "UNSET": {
                return TStatus.UNSET;
            }
        }
        return null;
    }

    private static TEvent toTEvent(JSONObject event) {
        if (event == null) {
            return null;
        }
        TEvent ret = new TEvent();
        ret.setName(event.getString("name"));
        if (event.containsKey((Object)"fields")) {
            TAttributes attributes = TraceUtil.toTAttributes(event.getJSONArray("fields"));
            ret.setAttributes(attributes);
            ret.setTotalAttributeCount(attributes.getKeysSize());
        }
        ret.setEpochNanos(event.getLong("timestamp").longValue());
        return ret;
    }

    private static TKind toTKind(String kind) {
        if (kind == null) {
            return null;
        }
        switch (kind = kind.toUpperCase()) {
            case "CLIENT": {
                return TKind.CLIENT;
            }
            case "SERVER": {
                return TKind.SERVER;
            }
            case "CONSUMER": {
                return TKind.CONSUMER;
            }
            case "PRODUCER": {
                return TKind.PRODUCER;
            }
        }
        return TKind.INTERNAL;
    }

    private static TLink toTLink(JSONObject link) {
        if (link == null) {
            return null;
        }
        TLink ret = new TLink();
        ret.setSpanContext(TraceUtil.toTSpanContext(link));
        return ret;
    }

    private static TExtra toTExtra(Map<String, TValue> specialAttrMap) {
        TExtra tExtra = new TExtra();
        if (specialAttrMap.containsKey(TAG_KEY_SERVICE_NAME)) {
            tExtra.setServiceName(specialAttrMap.get(TAG_KEY_SERVICE_NAME).getStringValue());
        }
        if (specialAttrMap.containsKey(TAG_KEY_IP)) {
            tExtra.setIp(specialAttrMap.get(TAG_KEY_IP).getStringValue());
        }
        if (specialAttrMap.containsKey(TAG_KEY_HOST)) {
            tExtra.setHostname(specialAttrMap.get(TAG_KEY_HOST).getStringValue());
        }
        return tExtra;
    }
}

