/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.google.gson.Gson;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.ozhera.monitor.aop.HeraRequestMapping;
import org.apache.ozhera.monitor.bo.AlertGroupInfo;
import org.apache.ozhera.monitor.bo.AlertGroupParam;
import org.apache.ozhera.monitor.bo.InterfaceNameEnum;
import org.apache.ozhera.monitor.bo.UserInfo;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlertGroupService;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionAlertGroupAdd;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionAlertGroupDelete;
import org.apache.ozhera.monitor.service.aop.action.HeraRequestMappingActionAlertGroupEdit;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.user.UserConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alertGroup"})
public class AlertGroupController {
    private static final Logger log = LoggerFactory.getLogger(AlertGroupController.class);
    @Autowired
    private AlertGroupService alertGroupService;
    @Autowired
    private UserConfigService userconfigService;

    @RequestMapping(value={"/test"})
    public Result<PageData<List<UserInfo>>> test() {
        Object userInfo = null;
        try {
            return this.alertGroupService.initAlertGroupData();
        }
        catch (Exception e) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/user/search"})
    public Result<PageData<List<UserInfo>>> userSearch(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.userSearch param : {} ", (Object)param);
            param.pageQryInit();
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.userSearch request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.userSearch param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.userSearch(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.userSearch\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/sync/{type}"})
    public Result sync(HttpServletRequest request, @PathVariable(name="type") String type) {
        AuthUserVo userInfo = null;
        try {
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.sync type={}, user : {}", (Object)type, (Object)user);
            return this.alertGroupService.sync(user, type);
        }
        catch (Exception e) {
            log.error("AlertGroupController.sync\u5f02\u5e38 type : {} ,userInfo :{}", new Object[]{type, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/search"})
    public Result<PageData<List<AlertGroupInfo>>> alertGroupSearch(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.alertGroupSearch param : {} ", (Object)param);
            param.pageQryInit();
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.alertGroupSearch request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            Result pageDataResult = this.alertGroupService.alertGroupSearch(user, param);
            log.info("AlertGroupController.alertGroupSearch param : {} ,user : {} , result : {}", new Object[]{param, user, new Gson().toJson((Object)pageDataResult)});
            return pageDataResult;
        }
        catch (Exception e) {
            log.error("AlertGroupController.alertGroupSearch\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/searchByIds"})
    public Result<Map<Long, AlertGroupInfo>> alertGroupSearchByIds(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.alertGroupSearchByIds param : {} ", (Object)param);
            if (param.getRelIds() == null || param.getRelIds().isEmpty() || param.getRelIds().size() > 10) {
                log.info("AlertGroupController.alertGroupSearchByIds request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.alertGroupSearchByIds request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.alertGroupSearchByIds param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.alertGroupSearchByIds(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.alertGroupSearchByIds\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/detailed"})
    public Result<AlertGroupInfo> alertGroupDetailed(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.alertGroupDetailed param : {} ", (Object)param);
            if (param.getId() <= 0L) {
                log.info("AlertGroupController.alertGroupDetailed request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.alertGroupDetailed request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.alertGroupDetailed param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.alertGroupDetailed(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.alertGroupDetailed\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/create"}, interfaceName=InterfaceNameEnum.ALERT_GROUP_ADD, actionClass=HeraRequestMappingActionAlertGroupAdd.class)
    public Result<AlertGroupInfo> alertGroupCreate(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.alertGroupCreate param : {} ", (Object)param);
            if (!param.createArgCheck()) {
                log.info("AlertGroupController.alertGroupCreate request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.alertGroupCreate request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.alertGroupCreate param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.alertGroupCreate(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.alertGroupCreate\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/edit"}, interfaceName=InterfaceNameEnum.ALERT_GROUP_EDIT, actionClass=HeraRequestMappingActionAlertGroupEdit.class)
    public Result alertGroupEdit(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.alertGroupEdit param : {} ", (Object)param);
            if (!param.createArgCheck() || param.getId() <= 0L) {
                log.info("AlertGroupController.alertGroupEdit request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.alertGroupEdit request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.alertGroupEdit param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.alertGroupEdit(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.alertGroupEdit\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @HeraRequestMapping(value={"/delete"}, interfaceName=InterfaceNameEnum.ALERT_GROUP_EDIT, actionClass=HeraRequestMappingActionAlertGroupDelete.class)
    public Result alertGroupDelete(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.alertGroupDelete param : {} ", (Object)param);
            if (param.getId() <= 0L) {
                log.info("AlertGroupController.alertGroupDelete request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.alertGroupDelete request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.alertGroupDelete param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.alertGroupDelete(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.alertGroupDelete\u5f02\u5e38 param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @ResponseBody
    @PostMapping(value={"/duty_list"})
    public Result dutyInfoList(HttpServletRequest request, @RequestBody AlertGroupParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlertGroupController.dutyInfoList param : {} ", (Object)param);
            if (param.getId() <= 0L) {
                log.info("AlertGroupController.dutyInfoList request info error no arg error! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlertGroupController.dutyInfoList request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.INVALID_USER);
            }
            String user = userInfo.genFullAccount();
            user = this.userconfigService.getAssignUser(user);
            log.info("AlertGroupController.dutyInfoList param : {} ,user : {}", (Object)param, (Object)user);
            return this.alertGroupService.dutyInfoList(user, param);
        }
        catch (Exception e) {
            log.error("AlertGroupController.dutyInfoList param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

