/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(MybatisTransaction.class);
    protected DataSource dataSource;
    protected Connection connection;
    protected TransactionIsolationLevel level;
    protected boolean autoCommmit;

    public MybatisTransaction(TransactionIsolationLevel level, boolean autoCommmit) {
        this.level = level;
        this.autoCommmit = autoCommmit;
    }

    public MybatisTransaction(DataSource ds, TransactionIsolationLevel desiredLevel, boolean desiredAutoCommit) {
        this.dataSource = ds;
        this.level = desiredLevel;
        this.autoCommmit = desiredAutoCommit;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            if (log.isDebugEnabled()) {
                log.info("Committing JDBC Connection [" + String.valueOf(this.connection) + "]");
            }
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.getAutoCommit()) {
            if (log.isDebugEnabled()) {
                log.debug("Rolling back JDBC Connection [" + String.valueOf(this.connection) + "]");
            }
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.resetAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug("Closing JDBC Connection [" + String.valueOf(this.connection) + "]");
            }
            this.connection.close();
        }
    }

    public Integer getTimeout() throws SQLException {
        return null;
    }

    protected void resetAutoCommit() {
        block4: {
            try {
                if (!this.connection.getAutoCommit()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Resetting autocommit to true on JDBC Connection [" + String.valueOf(this.connection) + "]");
                    }
                    this.connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Error resetting autocommit to true before closing the connection.  Cause: " + String.valueOf(e));
            }
        }
    }

    protected void openConnection() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Opening JDBC Connection");
        }
        this.connection = this.dataSource.getConnection();
        if (this.level != null) {
            this.connection.setTransactionIsolation(this.level.getLevel());
        }
        this.setDesiredAutoCommit(this.autoCommmit);
    }

    protected void setDesiredAutoCommit(boolean desiredAutoCommit) {
        try {
            if (this.connection.getAutoCommit() != desiredAutoCommit) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting autocommit to " + desiredAutoCommit + " on JDBC Connection [" + String.valueOf(this.connection) + "]");
                }
                this.connection.setAutoCommit(desiredAutoCommit);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error configuring AutoCommit.  Your driver may not support getAutoCommit() or setAutoCommit(). Requested setting: " + desiredAutoCommit + ".  Cause: " + String.valueOf(e), e);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

